//
//  LetterFix.m
//  LetterFix2
//
//  Created by kuri on 10/02/01.
//  Copyright 2010-2011 kuri. All rights reserved.
//
#import <objc/runtime.h>
#import <objc/objc-runtime.h>
#import <WebKit/WebKit.h>
#import "LetterFix.h"
#import "LFApp.h"

static NSMutableArray *khash;
static NSMutableArray *check_at_save;
static LFApp *app;
static NSString *roman[] = {@"I", @"II", @"III", @"IV", @"V", @"VI", @"VII", @"VIII", @"IX", @"X"};
static NSString *dep[] = {@"ミリ", @"キロ", @"センチ", @"メートル", @"グラム", @"トン", @"アール", @"ヘクタール",
    @"リットル", @"ワット", @"カロリー", @"ドル", @"セント", @"パーセント", @"ミリバール", @"ページ",
    @"mm", @"cm", @"km", @"mg", @"kg", @"cc", @"明治", @"大正", @"昭和", @"平成", @"No.", @"K.K.", @"TEL",
    @"(上)", @"(中)", @"(下)", @"(左)", @"(右)", @"(株)", @"(有)", @"(代)", @"Σ"};
static NSString *dayOfWeek = @"㈰㈪㈫㈬㈭㈮㈯㉀㈷㉂㉃㈹㈺㈱㈾㈴㈲㈻㈶㈳㈵㈼㈽㈿㈸";
static NSString *subOfDayOfWeek[] = {@"(日)",@"(月)",@"(火)",@"(水)",@"(木)",@"(金)",@"(土)",@"(祭)",@"(祝)",@"(自)",
    @"(至)",@"(代)",@"(呼)",@"(株)",@"(資)",@"(名)",@"(有)",@"(学)",@"(財)",@"(社)",
    @"(特)",@"(監)",@"(企)",@"(協)",@"(労)"};
static NSString *circledNumbers = @"①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ";
static NSString *subOfCircledNum[] = {@"(1)",@"(2)",@"(3)",@"(4)",@"(5)",@"(6)",@"(7)",@"(8)",@"(9)",@"(10)",
    @"(11)",@"(12)",@"(13)",@"(14)",@"(15)",@"(16)",@"(17)",@"(18)",@"(19)",@"(20)",
    @"I",@"II",@"III",@"IV",@"V"};
static NSString *symbols = @"㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㍾㍽㍼㍻№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹∑";

static unsigned long long LF_Encoding_ISO2022JP = NSISO2022JPStringEncoding;
static unsigned long long LF_Encoding_Auto = 0;

void swizzlingMethod(Class aClass, SEL aSelector, SEL nSelector, IMP nImplement) {
    Method orig_method, alt_method;
    
    if ((orig_method = class_getInstanceMethod(aClass, aSelector)) == NULL) {
	NSLog(@"Swizzling Method: Original Method is not found. [%@ %@]", NSStringFromClass(aClass), NSStringFromSelector(aSelector));
	return; // Original Method is not found.
    }
    // If orig_method was the superclass's instance method, so now we'll add the implement as method of self class.
    if (class_addMethod(aClass, aSelector, method_getImplementation(orig_method), method_getTypeEncoding(orig_method)) == YES) {
	orig_method = class_getInstanceMethod(aClass, aSelector);
    }
    if (class_addMethod(aClass, nSelector, nImplement, method_getTypeEncoding(orig_method)) == NO) {
	NSLog(@"Swizzling Method: Can't add new method.");
	return; // Can't add new method
    }
    alt_method  = class_getInstanceMethod(aClass, nSelector);
    method_exchangeImplementations(orig_method, alt_method);
    //NSLog(@"Swizzling Method: Success.");
}

static void backendSetPreferredEncoding(id backend, unsigned long long encoding)
{
    Ivar ivar = object_getInstanceVariable(backend, "_flags", NULL);
    _LF_flags *_flags = (_LF_flags *)((char *)backend + ivar_getOffset(ivar));
    _flags->encodingHint = encoding;
 
    //[backend setPreferredEncoding:LF_Encoding_ISO2022JP];
}

static unsigned long long backendGetPreferredEncoding(id backend)
{
    Ivar ivar = object_getInstanceVariable(backend, "_flags", NULL);
    _LF_flags *_flags = (_LF_flags *)((char *)backend + ivar_getOffset(ivar));
    return _flags->encodingHint; //FIXME: [backend _encodingHint] return wrong value?
    
    //return [backend preferredEncoding];
}

int fixTextNode(DOMText *node, DOMRange *range, BOOL isCheck, BOOL isOpen)
{
    int      replaced = 0;
    int      c_start = -1;
    int      c_end = -1;
    int      i;
    
    if ([node nodeType] != DOM_TEXT_NODE) return 0;
    
    // 文字列選択位置を保存
    if ([node isEqualNode:[range startContainer]]) {
	c_start = [range startOffset];
    }
    if ([node isEqualNode:[range endContainer]]) {
	c_end = [range endOffset];
    }
    
    // 誤ったUnicodeテーブルが用いられている文字を本来の文字に置換
    for (i = 0; i < [[node data] length]; i++) {
	switch ([[node data] characterAtIndex:i]) {
	    case 0x2015: // ―
		[node replaceData:i length:1 data:@"—"]; // U+2014
		break;
	    case 0xff5e: // ～
		[node replaceData:i length:1 data:@"〜"]; // U+301c
		break;
	    case 0x2225: // ∥
		[node replaceData:i length:1 data:@"‖"]; // U+2016
		break;
	    case 0xff0d: // －
		[node replaceData:i length:1 data:@"−"]; // U+2212
		break;
	    case 0xffe0: // ￠
		[node replaceData:i length:1 data:@"¢"]; // U+00a2
		break;
	    case 0xffe1: // ￡
		[node replaceData:i length:1 data:@"£"]; // U+00a3
		break;
	    case 0xffe2: // ￢
		[node replaceData:i length:1 data:@"¬"]; // U+00ac
		break;
	}
    }
    
    for (i = 0; i < [[node data] length]; i++) {
	NSString *us = [[node data] substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	NSInteger loc;
	NSString *ns = nil;
	if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES && uc != 0xa0) {
	    replaced++;
            if (isOpen) { // 編集開始時
                if ([app isOsDependentFix] == YES) {
                    if ((loc = [dayOfWeek rangeOfString:us].location) != NSNotFound) {
                        if ([app parenSymbolFix] == YES) {
                            if (((loc == 11)||(loc == 13)||(loc == 16)) &&
                                ([app someParenSymbolNotFix] == YES)) {
                                ns = subOfDayOfWeek[loc];
                            } else {
                                ns = subOfCircledNum[loc];
                            }
                        } else {
                            ns = subOfDayOfWeek[loc];
                        }
                    } else { // (SnowLeopard or Lion) OR (not DayOfWeek)
                        if ((0x2460 <= uc) && (uc <= 0x2473)) {       // ①〜⑳ -> (1)〜(20)
                            ns = subOfCircledNum[uc-0x2460];
                        } else if ((0x2160 <= uc && uc <= 0x2169) && ([app isOsDependentFix]==YES)) {// Ⅰ〜Ⅹ -> I〜X
                            ns = roman[uc-0x2160];
                        } else if (((loc = [symbols rangeOfString:us].location) != NSNotFound)
                                   ) {
                            ns = dep[loc];
                        } else {
                            if ([app isAllLetterFix] == YES) {
                                ns = @"〓";
                            } else { // [app isAllLetterFix] == NO
                                ns = us;
                            }
                        }
                    }
                } else { // [app isOsDependentFix] == NO
                    if ([app isAllLetterFix] == YES) {
                        ns = @"〓";
                    } else { // [app isAllLetterFix] == NO
                        ns = us;
                    }
                }
            } else { // 保存・送信時
                if ([app isOsDependentFix] == YES) {
                    if ((0x2460 <= uc) && (uc <= 0x2473)) {       // ①〜⑳ -> (1)〜(20)
                        ns = subOfCircledNum[uc-0x2460];
                    } else if ((0x2160 <= uc && uc <= 0x2169) && ([app isOsDependentFix]==YES)) {// Ⅰ〜Ⅹ -> I〜X
                        ns = roman[uc-0x2160];
                    } else if ((loc = [symbols rangeOfString:us].location) != NSNotFound) {
                        ns = dep[loc];
                    } else if ((loc = [dayOfWeek rangeOfString:us].location) != NSNotFound) {
                        ns = subOfDayOfWeek[loc];
                    } else {
                        if ([app isAllLetterFix] == YES) {
                            ns = @"〓";
                        } else { // [app isAllLetterFix] == NO
                            ns = us;
                        }
                    }
                } else { // [app isOsDependentFix] == NO
                    if ([app isAllLetterFix] == YES) {
                        ns = @"〓";
                    } else { // [app isAllLetterFix] == NO
                        ns = us;
                    }
                }
	    }
	    
	    if ((c_start != -1) && (i < c_start)) {
		c_start += [ns length] - 1;
	    }
	    if ((c_end != -1) && (i < c_end)) {
		c_end += [ns length] - 1;
	    }
	    if (!isCheck) {
		[node replaceData:i length:1 data:ns];
		i += [ns length] - 1;
	    }
	}
    }
    if (!isCheck) {
	if ((c_start != -1) && 0 < replaced) {
	    [range setStart:node offset:c_start];
	}
	if ((c_end != -1) && 0 < replaced) {
	    [range setEnd:node offset:c_end];
	}
    }
    return replaced;
}

int fixReflexively(DOMNode *node, DOMRange *range, BOOL isCheck, BOOL isOpen)
{
    DOMNode *n;
    int      replaced = 0;
    
    if ([node hasChildNodes]) {
	for (n = [node firstChild]; n != NULL; n = [n nextSibling]) {
	    replaced += fixReflexively(n, range, isCheck, isOpen); // 再帰的にノードをたどる
	}
    } else {
	if ([node nodeType] == DOM_TEXT_NODE) {
	    replaced = fixTextNode((DOMText*)node, range, isCheck, isOpen);
	}
    }
    return replaced;
}

int fixLetter(id self, id composeView, BOOL isCheck, BOOL isOpen)
{
    int replaced = 0;
    
    @try {
	WebFrame    *frame     = [(WebView *)composeView mainFrame];
	DOMDocument *dom       = [frame DOMDocument];
	DOMElement  *root      = [dom documentElement];
	DOMNodeList *nodelist  = [root getElementsByTagName:@"body"];
	
	if ([nodelist length] != 1) return -1;
	
	DOMNode     *body      = [nodelist item:0];
	DOMRange    *range     = [composeView selectedDOMRange];
	
	replaced = fixReflexively(body, range, isCheck, isOpen);
	
	if (0 < replaced && !isCheck) {
	    [composeView setSelectedDOMRange:range affinity:NSSelectionAffinityUpstream];
	}
    }
    @catch (NSException * e) {
	NSLog(@"LetterFix: caught %@ %@", [e name], [e reason]);
    }
    
    return replaced;
}

BOOL checkSubject(id self)
{
    NSMutableString *substr = [NSMutableString stringWithString:[[self backEnd] subject]];
    NSInteger i;
    
    for (i = 0; i < [substr length]; i++) {
	NSString *us = [substr substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	switch (uc) {
	    case 0x2015: // ―
	    case 0xff5e: // ～
	    case 0x2225: // ∥
	    case 0xff0d: // －
	    case 0xffe0: // ￠
	    case 0xffe1: // ￡
	    case 0xffe2: // ￢
		return TRUE;
	    default:
		if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES) return TRUE;
		break;
	}
    }
    
    return FALSE;
}

BOOL checkSubjectOnLoad(id self)
{
    NSMutableString *substr = [NSMutableString stringWithString:[[self backEnd] subject]];
    NSInteger i, loc;
    
    for (i = 0; i < [substr length]; i++) {
	NSString *us = [substr substringWithRange:NSMakeRange(i, 1)];
        if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES) {
            if (([app isOsDependentFix] == YES) && ([app parenSymbolFix] == YES) &&
                ((loc = [dayOfWeek rangeOfString:us].location) != NSNotFound) &&
                ([app someParenSymbolNotFix] == NO || (loc != 11 && loc != 13 && loc != 16))) {
                return TRUE;
            }
        }
    }
    return FALSE;
}

void fixSubjectOnLoad(id self)
{
    NSMutableString *substr = [NSMutableString stringWithString:[[self backEnd] subject]];
    
    NSInteger i;
    for (i = 0; i < [substr length]; i++) {
	NSString *us = [substr substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	NSInteger loc;
	
	switch (uc) {
	    case 0x2015: // ―
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"—"];
                break;
	    case 0xff5e: // ～
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"〜"];
                break;
	    case 0xff0d: // －
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"−"];
                break;
	    case 0x2225: // ∥
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"‖"];
                break;
	    case 0xffe0: // ￠
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"¢"];
                break;
	    case 0xffe1: // ￡
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"£"];
                break;
	    case 0xffe2: // ￢
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"¬"];
                break;
	    default:
		if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES) {
                    if (([app isOsDependentFix] == YES) && ([app parenSymbolFix] == YES) &&
                        ((loc = [dayOfWeek rangeOfString:us].location) != NSNotFound) &&
                        ([app someParenSymbolNotFix] == NO || (loc != 11 && loc != 13 && loc != 16))) {
                        [substr replaceCharactersInRange:NSMakeRange(i, 1)
					      withString:[circledNumbers substringWithRange:NSMakeRange(loc, 1)]];
                    }
		}
		break;
	}
    }
    [[(LetterFix *)self backEnd] setSubject:substr];
    [[self window] setTitle:substr];
    
    id headers = [self headersEditor];
    NSTextField *subjectField = nil;
    object_getInstanceVariable(headers, "_subjectField", (void **)&subjectField);
    if (subjectField != nil)
	[subjectField setStringValue:substr];
}

void fixHeader(id self)
{
    NSMutableString *substr = [NSMutableString stringWithString:[[self backEnd] subject]];
    
    NSInteger i;
    for (i = 0; i < [substr length]; i++) {
	NSString *us = [substr substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	NSString *ns;
	NSInteger loc;
	
	switch (uc) {
            case 0x2015: // ―
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"—"];
                break;
	    case 0xff5e: // ～
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"〜"];
                break;
	    case 0xff0d: // －
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"−"];
                break;
	    case 0x2225: // ∥
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"‖"];
                break;
	    case 0xffe0: // ￠
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"¢"];
                break;
	    case 0xffe1: // ￡
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"£"];
                break;
	    case 0xffe2: // ￢
                [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"¬"];
                break;
	    default:
		if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES) {
		    if ((0x2460 <= uc && uc <= 0x2473) && ([app isOsDependentFix]==YES)) {       // ①〜⑳ -> (1)〜(20)
			ns = subOfCircledNum[uc-0x2460];
		    } else if ((0x2160 <= uc && uc <= 0x2169) && ([app isOsDependentFix]==YES)) {// Ⅰ〜Ⅹ -> I〜X
			ns = roman[uc-0x2160];
		    } else if (((loc = [symbols rangeOfString:us].location) != NSNotFound)
			       && ([app isOsDependentFix]==YES)) {
			ns = dep[loc];
		    } else {
			ns = @"〓";
		    }
		    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:ns];
		    if (1 < [ns length]) {
			i += [ns length] - 1;
		    }
		}
		break;
	}
    }
    [[(LetterFix *)self backEnd] setSubject:substr];
    [[self window] setTitle:substr];
    
    id headers = [self headersEditor];
    NSTextField *subjectField = nil;
    object_getInstanceVariable(headers, "_subjectField", (void **)&subjectField);
    if (subjectField != nil)
	[subjectField setStringValue:substr];
}

BOOL _LF_IMP_isLoaded(id self, SEL _cmd)
{
    BOOL result = [self _LF_isLoaded]; // call swizzled(original) method
    if ([app isActive] == NO) {
	return result;
    }
    if (result == NO) {
	[khash removeObject:self];
	return result;
    }
    if ([khash containsObject:self] == YES) return result;
    
    @try {
	id composeView = [self webView];
        if ((composeView==NULL) || ([(WebView *)composeView isLoading]==YES) || ([(WebView *)composeView isEditable]==NO)) {
            //[self performSelector:@selector(isLoaded) withObject:nil afterDelay:2];
	    return result;
        }
        
	id backend   = [self backEnd];
        backendSetPreferredEncoding(backend, LF_Encoding_ISO2022JP);
	[khash addObject:self];
        
	switch ([self messageType]) {
	    case 1: // 返信
	    case 2: // 全員に返信
	    case 3: // 転送
	    case 4: // 下書きを開く
	    case 7: // リダイレクト
	    case 8: // 差出人に返信
		break;
	    case 5: // 新規メッセージ
	    case 14:// 添付ファイルとして返信
		return result;
	    default:
		NSLog(@"Unknown MessageType: %d", [self messageType]);
		return result;
	}
        
	if (0 < fixLetter(self, [self webView], TRUE, TRUE) || checkSubjectOnLoad(self)) {
            if ([app operationAtOpen] == 0) {
                NSAlert *alert = [[[NSAlert alloc] init] autorelease];
                [alert addButtonWithTitle:@"変換"];
                [alert addButtonWithTitle:@"変換しない"];
                [alert setShowsSuppressionButton:TRUE];
                [alert setMessageText:@"編集前にメッセージを変換しますか？"];
                [alert setInformativeText:@"このメッセージには ISO 2022-JP に変換できない文字が含まれています。"];
                [alert setAlertStyle:NSInformationalAlertStyle];
                [alert beginSheetModalForWindow:[self window] modalDelegate:self
				 didEndSelector:@selector(_LF_alert0DidEnd:returnCode:contextInfo:)
				    contextInfo:nil];
            } else if ([app operationAtOpen] == 1) {
                fixSubjectOnLoad(self);
                fixLetter(self, [self webView], FALSE, TRUE);
                [[self backEnd] setHasChanges:FALSE];
            }
	}
    }
    @catch (NSException * exception) {
	NSLog(@"LetterFix: caught %@ %@", [exception name], [exception reason]);
    }
    
    return result;
}

void alert0DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
        fixSubjectOnLoad(self);
	fixLetter(self, [self webView], FALSE, TRUE);
	//[[self backEnd] setHasChanges:FALSE];
    } else if (returnCode == NSAlertSecondButtonReturn) {
    }
    if ([[alert suppressionButton] state] == NSOnState) {
	if (returnCode == NSAlertFirstButtonReturn) {
            [app setOperationAtOpen:1];
	} else if (returnCode == NSAlertSecondButtonReturn) {
            [app setOperationAtOpen:2];
	}
    }
}

void _LF_IMP_send_(id self, SEL _cmd, id arg1)
{
    if ([app isActive] == NO) {
	[self _LF_send: arg1];
	return;
    }
    
    backendSetPreferredEncoding([self backEnd], LF_Encoding_ISO2022JP);
    if (0 < fixLetter(self, [self webView], TRUE, FALSE)) {
        NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert addButtonWithTitle:@"変換して送信"];
	[alert addButtonWithTitle:@"キャンセル"];
	[alert addButtonWithTitle:@"変換せずに送信"];
	[alert addButtonWithTitle:@"変換のみ"];
	[alert setMessageText:@"メッセージを変換して送信しますか？"];
	[alert setInformativeText:@"送信しようとしているメッセージには ISO 2022-JP に変換できない文字が含まれています。"];
	[alert setAlertStyle:NSInformationalAlertStyle];
	[alert beginSheetModalForWindow:[self window]
			  modalDelegate:self
			 didEndSelector:@selector(_LF_alert1DidEnd:returnCode:contextInfo:)
			    contextInfo:arg1];
    } else if (([app isCheckSubject] != NO) && checkSubject(self)) {
	_LF_alertSubject(self, _cmd, arg1);
    } else {
	[self _LF_send: arg1];
    }
}

void _LF_alertSubject(id self, SEL _cmd, id arg1)
{
    NSAlert *alert = [[[NSAlert alloc] init] autorelease];
    [alert addButtonWithTitle:@"変換して送信"];
    [alert addButtonWithTitle:@"キャンセル"];
    [alert addButtonWithTitle:@"変換せずに送信"];
    [alert addButtonWithTitle:@"変換のみ"];
    [alert setMessageText:@"件名に ISO 2022-JP に変換できない文字が含まれています"];
    [alert setInformativeText:@"送信するメッセージの件名に ISO 2022-JP に変換できない文字が含まれています。"];
    [alert setAlertStyle:NSInformationalAlertStyle];
    [alert beginSheetModalForWindow:[self window]
		      modalDelegate:self
		     didEndSelector:@selector(_LF_alert3DidEnd:returnCode:contextInfo:)
			contextInfo:arg1];
}

void alert1DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixLetter(self, [self webView], FALSE, FALSE);
	if (backendGetPreferredEncoding([self backEnd]) != LF_Encoding_ISO2022JP) backendSetPreferredEncoding([self backEnd], LF_Encoding_ISO2022JP);
	[[alert window] orderOut:arg1];
	if (([app isCheckSubject] != NO) && checkSubject(self)) _LF_alertSubject(self, _cmd, arg1);
	else [self _LF_send: arg1];
    } else if (returnCode == NSAlertSecondButtonReturn) {
	// Cancel
    } else if (returnCode == NSAlertThirdButtonReturn) { // 変換せずに送信
	if (backendGetPreferredEncoding([self backEnd]) == LF_Encoding_ISO2022JP) {
	    backendSetPreferredEncoding([self backEnd], LF_Encoding_Auto); // ISO2022JPのままだとISO2022JP-2とかで送ってしまう
	}
	[[alert window] orderOut:arg1];
	[self _LF_send: arg1];
    } else if (returnCode == (NSAlertThirdButtonReturn + 1)) { // 変換のみ
	fixLetter(self, [self webView], FALSE, FALSE);
	if (backendGetPreferredEncoding([self backEnd]) != LF_Encoding_ISO2022JP) backendSetPreferredEncoding([self backEnd], LF_Encoding_ISO2022JP);
    }
}

void alert3DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixHeader(self);
	[[alert window] orderOut:arg1];
	[self _LF_send: arg1];
    } else if (returnCode == NSAlertSecondButtonReturn) {
	// Cancel
    } else if (returnCode == NSAlertThirdButtonReturn) {
	[[alert window] orderOut:arg1];
	[self _LF_send: arg1];
    } else if (returnCode == (NSAlertThirdButtonReturn + 1)) {
	fixHeader(self);
    }
}

void _LF_IMP_saveDocument_(id self, SEL _cmd, id arg1)
{
    if (([app isActive] != NO) && ([check_at_save containsObject:self]==NO) &&(0 < fixLetter(self, [self webView], TRUE, FALSE)) && (backendGetPreferredEncoding([self backEnd]) == LF_Encoding_ISO2022JP)) {
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert addButtonWithTitle:@"変換"];
	[alert addButtonWithTitle:@"変換しない"];
	[alert setMessageText:@"保存前にメッセージを変換しますか？"];
	[alert setInformativeText:@"このメッセージには ISO 2022-JP エンコーディングに変換できない文字が含まれています。\n"
	 @"変換しないを選択した場合、メールの送信またはウインドウを開き直すまでエンコーディングの確認を行いません。"];
	[alert setAlertStyle:NSWarningAlertStyle];
	[alert beginSheetModalForWindow:[self window] modalDelegate:self didEndSelector:@selector(_LF_alert2DidEnd:returnCode:contextInfo:) contextInfo:arg1];
    } else {
	[self _LF_saveDocument: arg1];
    }
}

void alert2DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixLetter(self, [self webView], FALSE, FALSE);
    } else if (returnCode == NSAlertSecondButtonReturn) {
	[check_at_save addObject:self];
    }
    [[alert window] orderOut:arg1];
    [self _LF_saveDocument: (id)arg1];
}

void _LF_IMP_animationCompleted(id self, SEL _cmd)
{
    [self performSelector:@selector(isLoaded) withObject:nil afterDelay:0.5];
    [self _LF_animationCompleted];
}

#define MVMailBundle        (NSClassFromString(@"MVMailBundle"))
#define LFDocumentEditor    (NSClassFromString(@"DocumentEditor"))

@implementation LetterFix
+ (void) initialize
{
    class_setSuperclass([self class], MVMailBundle); // depricated function 10.5対応のためこのワーニングだけは消せません
    [super initialize];
    [self registerBundle];
    
    khash = [[NSMutableArray alloc] initWithCapacity:1];
    check_at_save = [[NSMutableArray alloc] initWithCapacity:1];
    
    app = [[LFApp alloc] init];
    
    
    //
    // swizzling method
    //
    swizzlingMethod(LFDocumentEditor, @selector(isLoaded), @selector(_LF_isLoaded), (IMP)_LF_IMP_isLoaded);
    swizzlingMethod(LFDocumentEditor, @selector(send:), @selector(_LF_send:), (IMP)_LF_IMP_send_);
    swizzlingMethod(LFDocumentEditor, @selector(saveDocument:), @selector(_LF_saveDocument:), (IMP)_LF_IMP_saveDocument_);
    swizzlingMethod(LFDocumentEditor, @selector(_animationCompleted), @selector(_LF_animationCompleted), (IMP)_LF_IMP_animationCompleted);
    class_addMethod(LFDocumentEditor, @selector(_LF_alert0DidEnd:returnCode:contextInfo:), (IMP)alert0DidEnd_returnCode_contextInfo_, "v@:@i^v");
    class_addMethod(LFDocumentEditor, @selector(_LF_alert1DidEnd:returnCode:contextInfo:), (IMP)alert1DidEnd_returnCode_contextInfo_, "v@:@i^v");
    class_addMethod(LFDocumentEditor, @selector(_LF_alert2DidEnd:returnCode:contextInfo:), (IMP)alert2DidEnd_returnCode_contextInfo_, "v@:@i^v");
    class_addMethod(LFDocumentEditor, @selector(_LF_alert3DidEnd:returnCode:contextInfo:), (IMP)alert3DidEnd_returnCode_contextInfo_, "v@:@i^v");
    //
    // end of swizzling method
    //
    
    NSLog(@"LetterFix Plugin (version %s/%ld) is registered.", LETTERFIX_VERSION, (unsigned long int)[app verm]);
}
@end