//
//  LFMenu.m
//  LetterFix2
//
//  Created by kuri on 10/02/26.
//  Copyright 2010-2011 kuri. All rights reserved.
//

#import "LFMenu.h"

@implementation LFMenu

- (id) initWithApp:(LFApp *)app
{
    self = [super init];
    
    _app       = app;
    
    return self;
}

- (BOOL) inject
{
    NSMenu *newmenu, *appmenu;
    NSMenuItem *item;
    
    @try {
	[self retain];
	
	newmenu = [[NSMenu alloc] initWithTitle:@"LetterFix Plug-in"];
	
	onoff = [self newMenuItem:@"LetterFix を有効にする" action:@selector(onOffItemChange:) state:[_app isActive] indent:0];
	[newmenu addItem:onoff];
	[newmenu addItem:[self newMenuItem:@"機種依存文字を代替形式に変換" action:@selector(osDependentFix:) state:[_app isOsDependentFix] indent:1]];
        if (([_app ver] == LF_Leopard)||([_app ver] == LF_MountainLion)||([_app ver] == LF_Mavericks)) {
            [newmenu addItem:[self newMenuItem:@"編集開始時に㈪㈫…㈵㈼…を丸数字・ローマ数字と見なす" action:@selector(parenSymbolFix:) state:[_app parenSymbolFix] indent:2]];
            [newmenu addItem:[self newMenuItem:@"㈹㈱㈲は⑫⑭⑰と見なさない" action:@selector(someParenSymbolNotFix:) state:[_app someParenSymbolNotFix] indent:3]];
        }
	[newmenu addItem:[self newMenuItem:@"ISO 2022-JP に変換できない文字を「〓」に修正" action:@selector(allLetterFix:) state:[_app isAllLetterFix] indent:1]];
	[newmenu addItem:[self newMenuItem:@"エンコーディングの初期値を ISO 2022-JP に設定" action:@selector(changeEncode:) state:[_app changeEncode] indent:1]];
	[newmenu addItem:[self newMenuItem:@"件名をチェックする" action:@selector(checkSubject:) state:[_app isCheckSubject] indent:1]];
	[newmenu addItem:[NSMenuItem separatorItem]];
	[newmenu addItem:[self newMenuItem:@"メッセージ編集開始時の動作をリセット" action:@selector(changeAtOpen:) state:NO indent:0]];
	[newmenu addItem:[self newMenuItem:@"LetterFixについて…" action:@selector(aboutItemSelected:) state:NO indent:0]];
	
	item = [[NSMenuItem alloc] initWithTitle:@"LetterFix Plug-in" action:NULL keyEquivalent:@""];
	[item setSubmenu:newmenu];
	
	appmenu = [[[[NSApplication sharedApplication] mainMenu] itemAtIndex:0] submenu];
	[appmenu insertItem:[NSMenuItem separatorItem] atIndex:1];
	[appmenu insertItem:item atIndex:2];
    }
    @catch (NSException * e) {
	NSLog(@"raise %@", e);
    }  
    
    return YES;
}

- (NSMenuItem *)newMenuItem:(NSString *)title action:(SEL)sel state:(BOOL)state indent:(NSInteger)indent
{
    NSMenuItem *item;
    item = [[NSMenuItem alloc] initWithTitle:title action:sel keyEquivalent:@""];
    [item setTarget:self];
    [item setState:state];
    [item setIndentationLevel:indent];
    return item;
}

- (void) onOffItemChange:(NSMenuItem *)sender
{
    [_app setIsActive:(![sender state])];
    [sender setState:[_app isActive]];
}

- (void) osDependentFix:(NSMenuItem *)sender
{
    [_app setIsOsDependentFix:(![sender state])];
    [sender setState:[_app isOsDependentFix]];
}

- (void) parenSymbolFix:(NSMenuItem *)sender
{
    [_app setParenSymbolFix:(![sender state])];
    [sender setState:[_app parenSymbolFix]];
}

- (void) someParenSymbolNotFix:(NSMenuItem *)sender
{
    [_app setSomeParenSymbolNotFix:(![sender state])];
    [sender setState:[_app someParenSymbolNotFix]];
}

- (void) allLetterFix:(NSMenuItem *)sender
{
    [_app setIsAllLetterFix:(![sender state])];
    [sender setState:[_app isAllLetterFix]];
}

- (void) changeEncode:(NSMenuItem *)sender
{
    [_app setChangeEncode:(![sender state])];
    [sender setState:[_app changeEncode]];
}

- (void) changeAtOpen:(NSMenuItem *)sender
{
    [_app setOperationAtOpen:0];
}

- (void) checkSubject:(NSMenuItem *)sender
{
    [_app setIsCheckSubject:(![sender state])];
    [sender setState:[_app isCheckSubject]];
}

- (void) aboutItemSelected:(NSMenuItem *)sender
{
    NSAlert *alert = [[NSAlert alloc] init];
    [alert setMessageText:[NSString stringWithFormat:@"LetterFix plug-in v%s",(LETTERFIX_VERSION)]];
    [alert setInformativeText:@"このプラグインは，メールに含まれる ISO 2022-JP に変換できない文字を置換し，"
     @"ISO 2022-JP を用いてメールを返信・転送可能にするためのものです。"];
    [alert setAlertStyle:NSInformationalAlertStyle];
    [alert runModal];
    [alert release];
}

- (BOOL) validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)anItem
{
    if (![_app isActive]) {
	if (([anItem action] == @selector(osDependentFix:))||
            ([anItem action] == @selector(parenSymbolFix:))||
            ([anItem action] == @selector(someParenSymbolNotFix:))||
	    ([anItem action] == @selector(allLetterFix:))||
	    ([anItem action] == @selector(changeEncode:))||
	    ([anItem action] == @selector(checkSubject:)))
	    return NO;
    } else if (![_app isOsDependentFix]) {
	if (([anItem action] == @selector(parenSymbolFix:))||
            ([anItem action] == @selector(someParenSymbolNotFix:)))
	    return NO;
    } else if (![_app parenSymbolFix]) {
	if ([anItem action] == @selector(someParenSymbolNotFix:))
	    return NO;
    }
    return YES;
}

- (NSMenuItem *)onoffMenuItem
{
    return onoff;
}
@end
