/***********************************************************
	decode.c
***********************************************************/
#include "ar.h"

extern struct lha_opts opts;

void
decode_start(struct lzh_istream *rp)
{
    huf_decode_start(rp, opts.method);
}

void
decode(struct huf_t *huf, struct lzh_istream *rp, uint count,
       char *buf, unsigned int *slide_off, int *slide_len)
        /* The calling function must keep the number of
           bytes to be processed.  This function decodes
           either 'count' bytes or 'DICSIZ' bytes, whichever
           is smaller, into the array 'buffer[]' of size
           'DICSIZ' or more.
           Call decode_start() once for each new file
           before calling this function. */
{
    uint r, c;

    r = 0;
    while (--*slide_len >= 0) {
        buf[r] = buf[*slide_off];
        *slide_off = (*slide_off+1) & (MAXDICSIZ - 1);
        if (++r == count)
            return;
    }
    for (;;) {
        c = decode_c(huf, rp);
        if (c <= UCHAR_MAX) {
            buf[r] = c;
            if (++r == count)
                return;
        }
        else {
            *slide_len = c - (UCHAR_MAX + 1 - THRESHOLD);
            *slide_off = (r - decode_p(huf, rp) - 1) & (MAXDICSIZ - 1);
            while (--*slide_len >= 0) {
                buf[r] = buf[*slide_off];
                *slide_off = (*slide_off+1) & (MAXDICSIZ - 1);
                if (++r == count)
                    return;
            }
        }
    }
}
