#include <errno.h>
#include <utime.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "ar.h"

void
extract(struct lzh_istream *rp, int to_file, struct lzh_header *h)
{
    FILE *outfile = NULL;
    unsigned int crc;
    struct huf_t huf;

    if (to_file) {
        if (memcmp(h->method, "-lhd-", sizeof(h->method)) == 0) {
            /* directory */
            if (mkdir(h->filename, 0777) == -1) {
                if (errno != EEXIST)
                    error("cannot make directory \"%s\"", opts.outdir);
            }
        }
        else {
            /* regular file */
            if (file_exists(h->filename)) {
                if (!opts.force_extract) {
                    message("'%s' has been already exist. skip", h->filename);
                    skip(rp->fp, h);
                    return;
                }
            }
            while ((outfile = fopen(h->filename, "wb")) == NULL) {
                fprintf(stderr, "Can't open %s\nNew filename: ", h->filename);
                if (get_line(h->filename, sizeof(h->filename)) == 0) {
                    fprintf(stderr, "Not extracted\n");
                    skip(rp->fp, h);
                    return;
                }
                h->namelen = strlen(h->filename);
            }
        }
        if (opts.quiet < 2)
            printf("Extracting %s ", h->filename);
    }
    else {
        outfile = stdout;
        if (opts.quiet < 2)
            printf("===== %s =====\n", h->filename);
    }
    crc = INIT_CRC;
    opts.method = which_method(h->method);
    if (opts.method == NULL) {
        fprintf(stderr, "Unknown method: %.5s\n", h->method);
        skip(rp->fp, h);
    }
    else {
        char buf[MAXDICSIZ];
        unsigned int slide_off = 0;
        int slide_len = 0;
        unsigned long remainder = h->origsize;

        crc = INIT_CRC;
        if (opts.method->dicbit != 0)
            decode_start(rp);
        while (remainder != 0) {
            uint n = (uint)MIN(remainder, MAXDICSIZ);
            if (opts.method->dicbit != 0)
                decode(&huf, rp, n, buf, &slide_off, &slide_len);
            else {
                /* no compress */
                if (fread(buf, 1, n, rp->fp) != n)
                    error("Can't read");
            }
            fwrite_crc(buf, n, outfile, &crc);
            if (outfile != stdout && opts.quiet < 1) {
                putc('.', stdout);
            }
            remainder -= n;
        }
    }

    if ((crc ^ INIT_CRC) != h->file_crc)
        error("CRC error");

    if (to_file) {
        fprintf(stdout, "\n");
        if (outfile) {
            struct utimbuf ut;

            fclose(outfile);

            ut.actime = ut.modtime = h->mtime;
            utime(h->filename, &ut);
        }
    }
    outfile = NULL;
}
