/***********************************************************
	decode.c
***********************************************************/
#include "ar.h"

static int j;                   /* remaining bytes to copy */

extern struct lha_opts opts;

void
decode_start(struct lzh_istream *rp)
{
    huf_decode_start(rp, opts.method);
    j = 0;
}

void
decode(struct lzh_istream *rp, uint count, char *buf)
        /* The calling function must keep the number of
           bytes to be processed.  This function decodes
           either 'count' bytes or 'DICSIZ' bytes, whichever
           is smaller, into the array 'buffer[]' of size
           'DICSIZ' or more.
           Call decode_start() once for each new file
           before calling this function. */
{
    static uint i;
    uint r, c;

    r = 0;
    while (--j >= 0) {
        buf[r] = buf[i];
        i = (i + 1) & (MAXDICSIZ - 1);
        if (++r == count)
            return;
    }
    for (;;) {
        c = decode_c(rp);
        if (c <= UCHAR_MAX) {
            buf[r] = c;
            if (++r == count)
                return;
        }
        else {
            j = c - (UCHAR_MAX + 1 - THRESHOLD);
            i = (r - decode_p(rp) - 1) & (MAXDICSIZ - 1);
            while (--j >= 0) {
                buf[r] = buf[i];
                i = (i + 1) & (MAXDICSIZ - 1);
                if (++r == count)
                    return;
            }
        }
    }
}
