#!/bin/sh

exec > prototypes.h

cat <<END
/* This file was generated by cproto. */
#if PROTOTYPES /* defined in config.h */
#define P_(s) s
#else
#define P_(s) ()
#endif

END

cproto -m -d \
	-D STDC_HEADERS=1 -D HAVE_STRDUP=0 -D HAVE_MEMSET=0 -D HAVE_MEMMOVE=0 \
	append.c crcio.c dhuf.c extract.c header.c \
	huf.c larc.c lhadd.c lharc.c lhext.c \
	lhlist.c maketbl.c maketree.c patmatch.c \
	shuf.c slide.c util.c

cat <<END

/* lharc.c */
RETSIGTYPE interrupt(int signo);
/* util.c */
#if !HAVE_MEMMOVE
void *memmove P_(void *dst, const void *src, size_t cnt)
#endif
#if !HAVE_STRDUP
char *strdup P_((char *buf));
#endif
#if !HAVE_MEMSET
char *memset P_((char *s, int c, int n));
#endif

/* vsnprintf.c */
#if !HAVE_VSNPRINTF
int vsnprintf P_((char *str, size_t n, const char *fmt, va_list ap));
int snprintf P_((char *str, size_t n, char const *fmt, ...));
#endif

#undef P_
END
