/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <string.h>

#ifdef __cplusplus

#include "1stclass.hpp"
int firstclass::remove_path(const string in_path){
  char *path=NULL;
  try {
    path=new char[sizeof(char)*(in_path.length()+1)];
    path[0]='\0';
    safe_strcat(path, in_path.c_str(), in_path.length()+1);
  
#else

#include "1stclass.h"
int remove_path(const char *path){

#endif

  DIR *dirp;
  struct dirent *dp;
  if((dirp = opendir(path))==NULL){
    
#ifdef __cplusplus
    delete[] path;
#endif
    
    return 0;
  }
  else{
    while( (dp = readdir(dirp)) != NULL){
      if(!strcmp(dp->d_name, ".") || !strcmp(dp->d_name,"..")){
      }
      else{
        char file[512]="";
        safe_strcat(file, path, sizeof(file));
        safe_strcat(file, "/", sizeof(file));
        safe_strcat(file, dp->d_name, sizeof(file));
        remove(file);
      }
    }
    closedir(dirp);
    rmdir(path);
  }
#ifdef __cplusplus
    delete[] path;
  }
  catch (...) {
    if(path!=NULL)
      delete[] path;
    return 1;
  }
#endif
  return 0;
}
