/**
 * @file  CriticalSection.h
 * @brief NeBJZNV֘ANX`.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#ifndef CRITICALSECTION_H_
#define CRITICALSECTION_H_

#include <boost/utility.hpp>

namespace GenericUtility {

//-----------------------------------------------------------------------------
/**
 * NeBJZNV.
 */
class CCriticalSection : boost::noncopyable
{
public:
	CCriticalSection() throw()
	{
		::InitializeCriticalSection(&m_CriticalSection);
	}
	~CCriticalSection() throw()
	{
		::DeleteCriticalSection(&m_CriticalSection);
	}

	void Enter()
	{
		::EnterCriticalSection(&m_CriticalSection);
	}
	void Leave()
	{
		::LeaveCriticalSection(&m_CriticalSection);
	}

	operator CRITICAL_SECTION&() throw()
	{
		return m_CriticalSection;
	}

protected:
	CRITICAL_SECTION m_CriticalSection;
};

//-----------------------------------------------------------------------------
/**
 * NeBJZNV.
 */
class CAutoCriticalSection : boost::noncopyable
{
public:
	CAutoCriticalSection(CRITICAL_SECTION& i_cs) throw()
		: m_bEntered(true), m_CriticalSection(i_cs)
	{
		::EnterCriticalSection(&m_CriticalSection);
	}
	~CAutoCriticalSection() throw()
	{
		Leave();
	}

	void Leave()
	{
		// NeBJZNVɓĂΔ
		if (m_bEntered) {
			m_bEntered = false;
			::LeaveCriticalSection(&m_CriticalSection);
		}
	}

protected:
	/// NeBJZNVɓĂ邩ǂ
	bool m_bEntered;

	CRITICAL_SECTION& m_CriticalSection;
};

/**
 * NeBJZNVꎞ.
 */
class CAutoLeaveCriticalSection : boost::noncopyable
{
public:
	CAutoLeaveCriticalSection(CRITICAL_SECTION& i_cs) throw() :
		m_CriticalSection(i_cs)
	{
		::LeaveCriticalSection(&m_CriticalSection);
	}
	~CAutoLeaveCriticalSection() throw()
	{
		::EnterCriticalSection(&m_CriticalSection);
	}

protected:
	CRITICAL_SECTION& m_CriticalSection;
};

}	// namespace GenericUtility

#endif
