/**
 * @file  DialogSizeHelper.cpp
 * @brief _CAOTCYύXNX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#include "stdafx.h"
//#include <Common.h>

#define DIALOGUTILITY_DLLEXPORT
#include "DialogSizeHelper.h"

#pragma warning(disable : 4244)	/* 'XXX' : 'XXX'  'XXX' ɕϊ܂BްĂ邩܂B */

namespace DialogUtility {

// for obsolete enum
const CDialogSizeHelper::SyncInfoPair CDialogSizeHelper::SyncTypeBottom(
	CDialogSizeHelper::SyncInfoPair(CDialogSizeHelper::SyncTypeNormal, CDialogSizeHelper::SyncTypeNone));
const CDialogSizeHelper::SyncInfoPair CDialogSizeHelper::SyncTypeRight(
	CDialogSizeHelper::SyncInfoPair(CDialogSizeHelper::SyncTypeNone, CDialogSizeHelper::SyncTypeNormal));
const CDialogSizeHelper::SyncInfoPair CDialogSizeHelper::SyncTypeBottomRight(
	CDialogSizeHelper::SyncInfoPair(CDialogSizeHelper::SyncTypeNormal, CDialogSizeHelper::SyncTypeNormal));

namespace {

/**
 * _CAOTCYw͈͓ɕۂ.
 */
CRect GetNewDialogRect(
	const CSize& sizeMin, const CSize& sizeMax,
	UINT nSide, const CRect& rectCurrent)
{
	CRect rectNew = rectCurrent;

	{
		int nHeight = rectNew.Height();
		bool bTooSmall = sizeMin.cy >= 0 ? nHeight < sizeMin.cy : false;
		bool bTooLarge = sizeMax.cy >= 0 ? nHeight > sizeMax.cy : false;
		if (bTooSmall || bTooLarge) {
			// 𒲐
			switch (nSide) {
			// hbO
			case WMSZ_BOTTOM:
			case WMSZ_BOTTOMLEFT:
			case WMSZ_BOTTOMRIGHT:
				// 𒲐
				rectNew.bottom = rectNew.top + (bTooSmall ? sizeMin.cy : sizeMax.cy);
				break;
			// 㑤hbO
			case WMSZ_TOP:
			case WMSZ_TOPLEFT:
			case WMSZ_TOPRIGHT:
				// 㑤𒲐
				rectNew.top = rectNew.bottom - (bTooSmall ? sizeMin.cy : sizeMax.cy);
				break;
			default:
				ASSERT(0);
			}
		}
	}

	{
		int nWidth = rectNew.Width();
		bool bTooSmall = sizeMin.cx >= 0 ? nWidth < sizeMin.cx : false;
		bool bTooLarge = sizeMax.cx >= 0 ? nWidth > sizeMax.cx : false;
		if (bTooSmall || bTooLarge) {
			// 𒲐
			switch (nSide) {
			// hbO
			case WMSZ_LEFT:
			case WMSZ_BOTTOMLEFT:
			case WMSZ_TOPLEFT:
				// 𒲐
				rectNew.left = rectNew.right - (bTooSmall ? sizeMin.cx : sizeMax.cx);
				break;
			// EhbO
			case WMSZ_RIGHT:
			case WMSZ_BOTTOMRIGHT:
			case WMSZ_TOPRIGHT:
				// E𒲐
				rectNew.right = rectNew.left + (bTooSmall ? sizeMin.cx : sizeMax.cx);
				break;
			default:
				ASSERT(0);
			}
		}
	}

	// ς݂̐V rect
	return rectNew;
}

/**
 * _CAOƃRg[̏ʒu/TCYyь݈ʒu/TCYA
 * Rg[̐Vʒu/TCY߂.
 */
class IRectCalculator
{
public:
	virtual ~IRectCalculator() {}

	virtual CRect operator()(
		const CRect& rectInitialDialog, const CRect& rectCurrentDialog,
		const CRect& rectInitialControl, const CRect& rectCurrentControl) const = 0;
};

/**
 * control ̈ʒu/TCYύX.
 */
void MoveControl(
	CWnd* pParent, const CRect& rectInitialParent,
	CWnd* pControl, const CRect& rectInitialControl,
	IRectCalculator& refCalculator)
{
	ASSERT(pParent && pControl);
	// parent  client Wł parent  client rect
	CRect rectParent;
	pParent->GetClientRect(rectParent);
	// parent  client Wł control  window rect
	CRect rectControl;
	pControl->GetWindowRect(rectControl);
	pParent->ScreenToClient(rectControl);

#if 0
	TRACE(_T("\ninitial parent : (%d, %d, %d, %d)\n"),
		rectInitialParent.top, rectInitialParent.bottom, rectInitialParent.left, rectInitialParent.right);
	TRACE(_T("current parent : (%d, %d, %d, %d)\n"),
		rectParent.top, rectParent.bottom, rectParent.left, rectParent.right);
	TRACE(_T("current control : (%d, %d, %d, %d)\n"),
		rectControl.top, rectControl.bottom, rectControl.left, rectControl.right);
#endif

	// Vʒu/TCYvZ
	CRect rectControlNew = refCalculator(
		rectInitialParent, rectParent,
		rectInitialControl, rectControl);

#if 0
	TRACE(_T("new control : (%d, %d, %d, %d)\n"),
		rectControlNew.top, rectControlNew.bottom, rectControlNew.left, rectControlNew.right);
#endif

	if (rectControl != rectControlNew) {
		// control ێĂ{̐e (_CAO)
		CWnd* pDialog = pControl->GetParent();
		// ʒu/TCY̊ (pParent) ɂ rect {̐eɂ rect ɕϊ
		pParent->ClientToScreen(rectControlNew);
		pDialog->ScreenToClient(rectControlNew);
		// V control ̈ʒu/TCYݒ
		pControl->MoveWindow(rectControlNew);
	}
}

/**
 * IRectCalculator ̎.
 */
template<class DiffCalculator, class CurrentRectMover>
class CRectCalculator : public IRectCalculator
{
public:
	CRectCalculator(
		const CDialogSizeHelper::SyncInfoPair& SyncInfoPair)
		: m_SyncInfoPair(SyncInfoPair)
	{
	}

	CRect operator()(
		const CRect& rectInitialParent, const CRect& rectCurrentParent,
		const CRect& rectInitialControl, const CRect& rectCurrentControl) const
	{
		// non-proportional ɂČvZ
		CSize sizeDiffNormal = DiffCalculator()(
			rectInitialParent, rectCurrentParent, rectInitialControl, rectCurrentControl,
			m_SyncInfoPair.VerticalInfo.fParam, m_SyncInfoPair.HorizontalInfo.fParam);

		// SyncTypeEnum ɏ]āACSize ݒ肷
		CSize sizeDiff(0, 0);
		if (m_SyncInfoPair.HorizontalInfo.nType == CDialogSizeHelper::SyncTypeNormal)
			sizeDiff.cx = sizeDiffNormal.cx;
		if (m_SyncInfoPair.VerticalInfo.nType == CDialogSizeHelper::SyncTypeNormal)
			sizeDiff.cy = sizeDiffNormal.cy;

		// Rg[̈ʒu/TCYύX
		return CurrentRectMover()(rectCurrentControl, sizeDiff);
	}

private:
	CDialogSizeHelper::SyncInfoPair m_SyncInfoPair;
};


/**
 * _CAOTCY̕ύXʂƃRg[TCY̕ύXʂ𓯂ɂ邽߂ɁA
 * ݂̃Rg[ǂꂾ傫΂vZ.
 */
class CDiffCalculatorSize
{
public:
	CSize operator()(
		const CRect& rectInitialParent, const CRect& rectCurrentParent,
		const CRect& rectInitialControl, const CRect& rectCurrentControl,
		double fVerticalParam, double fHorizontalParam) const
	{
		CSize sizeDiff = rectCurrentParent.Size() - rectInitialParent.Size();
		sizeDiff.cx *= fHorizontalParam;
		sizeDiff.cy *= fVerticalParam;
		return sizeDiff	- (rectCurrentControl.Size() - rectInitialControl.Size());
	}
};

/**
 * Rg[Eɑ傫.
 */
class CCurrentRectMoverSize
{
public:
	CRect operator()(const CRect& rectCurrentControl, const CSize& sizeDiff) const
	{
		CRect rectNewControl = rectCurrentControl;
		rectNewControl.InflateRect(0, 0, sizeDiff.cx, sizeDiff.cy);
		return rectNewControl;
	}
};

/**
 * Rg[TCY calculator.
 */
typedef CRectCalculator<CDiffCalculatorSize, CCurrentRectMoverSize> CRectCalculatorSize;

/**
 * _CAỎEɍ킹āARg[̍ (܂͉E) ̈ʒuς邽߂ɁA
 * ݂̃Rg[ǂꂾ΂vZ.
 * HACK: Rg[̃TCY𓯎ɕύXꍇAE͕ύXĂ\邽߁A
 * HACK: ɂȂ΂ȂȂ.
 */
template <bool bBaseTopLeft>
class CDiffCalculatorPosition
{
public:
	CSize operator()(
		const CRect& rectInitialDialog, const CRect& rectCurrentDialog,
		const CRect& rectInitialControl, const CRect& rectCurrentControl,
		double fVerticalParam, double fHorizontalParam) const
	{
		CSize sizeDiff = rectCurrentDialog.Size() - rectInitialDialog.Size();
		sizeDiff.cx *= fHorizontalParam;
		sizeDiff.cy *= fVerticalParam;
		if (bBaseTopLeft) {
			return sizeDiff - (rectCurrentControl.TopLeft() - rectInitialControl.TopLeft());
		}
		else {
			return sizeDiff - (rectCurrentControl.BottomRight() - rectInitialControl.BottomRight());
		}
	}
};

/**
 * Rg[̈ʒuς.
 */
class CCurrentRectMoverPosition
{
public:
	CRect operator()(const CRect& rectCurrentControl, const CSize& sizeDiff) const
	{
		CRect rectNewControl = rectCurrentControl;
		rectNewControl.OffsetRect(sizeDiff);
		return rectNewControl;
	}
};

typedef CRectCalculator<CDiffCalculatorPosition<true>, CCurrentRectMoverPosition> CRectCalculatorPositionTopLeft;
typedef CRectCalculator<CDiffCalculatorPosition<false>, CCurrentRectMoverPosition> CRectCalculatorPositionBottomRight;

}	// anonymous namespace

/////////////////////////////////////////////////////////////////////////////
/**
 * Rg[ vector.
 */
class CDialogSizeHelper::ControlInfoVec : public std::vector<ControlInfo>
{
};

/////////////////////////////////////////////////////////////////////////////
CDialogSizeHelper::CDialogSizeHelper(BOOL bGlobalUpdate, BOOL bMoveBaseTopLeft)
	: m_bGlobalUpdate(bGlobalUpdate), m_bMoveBaseTopLeft(bMoveBaseTopLeft)
	,m_pParent(NULL), m_sizeMin(-1, -1), m_sizeMax(-1, -1)
{
	m_pControlID = new ControlInfoVec;
}

CDialogSizeHelper::~CDialogSizeHelper()
{
	delete m_pControlID;
}

void CDialogSizeHelper::SetParent(CWnd* pParent)
{
	m_pParent = pParent;
}

void CDialogSizeHelper::SetParentRange(const CSize* sizeMin, const CSize* sizeMax)
{
	if (sizeMin)
		m_sizeMin = *sizeMin;
	else
		m_sizeMin = CSize(-1, -1);
	if (sizeMax)
		m_sizeMax = *sizeMax;
	else
		m_sizeMax = CSize(-1, -1);
}

void CDialogSizeHelper::AddControl(
	CWnd* pWnd,
	const SyncInfoPair& SizeInfo, const SyncInfoPair& PositionInfo,
	BOOL bForceInvalidate)
{
	ASSERT(m_pControlID);
	if (!m_pControlID)
		return;
	ASSERT(pWnd);
	if (!pWnd)
		return;

	ControlInfo info;
	info.pWnd = pWnd;
	info.SizeInfo = SizeInfo;
	info.PositionInfo = PositionInfo;
	info.bForceInvalidate = bForceInvalidate;

	// ̂̂Βu
	bool found = false;
	for (ControlInfoVec::size_type i = 0; i < m_pControlID->size(); ++i) {
		ControlInfo& ci = (*m_pControlID)[i];
		if (ci.pWnd == pWnd) {
			ci = info;
			found = true;
			break;
		}
	}
	if (!found)
		m_pControlID->push_back(info);
}

void CDialogSizeHelper::AddControlForSize(
	CWnd* pWnd, const SyncInfoPair& SizeInfo, BOOL bForceInvalidate)
{
	AddControl(pWnd, SizeInfo, SyncInfoPair(), bForceInvalidate);
}

void CDialogSizeHelper::AddControlForPosition(
	CWnd* pWnd, const SyncInfoPair& PositionInfo, BOOL bForceInvalidate)
{
	AddControl(pWnd, SyncInfoPair(), PositionInfo, bForceInvalidate);
}

void CDialogSizeHelper::Initialize()
{
	if (!m_pParent)
		return;

	ASSERT(m_pControlID);
	if (!m_pControlID)
		return;

	// dialog  client Wł dialog  client rect
	// (OnSize() Ŏg)
	m_pParent->GetClientRect(m_rectParentClient);
	// dialog  client Wł dialog  window rect
	// (OnSizing() Ŏg)
	m_pParent->GetWindowRect(m_rectParentWindow);
	m_pParent->ScreenToClient(m_rectParentWindow);

	for (ControlInfoVec::iterator it = m_pControlID->begin();
			it != m_pControlID->end(); ++it) {
		CWnd* pWnd = it->pWnd;
		ASSERT(pWnd);
		pWnd->GetWindowRect(it->rectControl);
		m_pParent->ScreenToClient(it->rectControl);
	}
}

void CDialogSizeHelper::OnSize()
{
	if (!m_pParent)
		return;

	ASSERT(m_pControlID);
	if (!m_pControlID)
		return;

	if (m_bGlobalUpdate) {
		// `~
		m_pParent->SetRedraw(FALSE);
	}

	for (ControlInfoVec::iterator it = m_pControlID->begin(); it != m_pControlID->end(); ++it) {
		CWnd* pWnd = it->pWnd;
		ASSERT(pWnd);

		// ܂TCYύX
		MoveControl(
			m_pParent, m_rectParentClient, pWnd, it->rectControl,
			CRectCalculatorSize(it->SizeInfo));

		// ̌ʒuύX
		if (m_bMoveBaseTopLeft) {
			MoveControl(
				m_pParent, m_rectParentClient, pWnd, it->rectControl,
				CRectCalculatorPositionTopLeft(it->PositionInfo));
		}
		else {
			MoveControl(
				m_pParent, m_rectParentClient, pWnd, it->rectControl,
				CRectCalculatorPositionBottomRight(it->PositionInfo));
		}
	}

	if (m_bGlobalUpdate) {
		// `ĊJ
		m_pParent->SetRedraw(TRUE);
		// ĕ`悷
		// HACK: Win2k ł́AwiȂƕ\ꍇ(?)
		m_pParent->Invalidate(/*FALSE*/);
	}
	else {
		// SĂIŁAForceInvalidate ̂̂ invaildate 
		for (ControlInfoVec::iterator it = m_pControlID->begin(); it != m_pControlID->end(); ++it) {
			if (it->bForceInvalidate) {
				it->pWnd->Invalidate(FALSE);
			}
		}
	}
}

void CDialogSizeHelper::OnSizing(UINT nSide, LPRECT lpRect)
{
	if (!m_pParent)
		return;

	*lpRect = GetNewDialogRect(m_sizeMin, m_sizeMax, nSide, *lpRect);
}

}	// namespace DialogUtility
