/**
 * @file  Thread.cpp
 * @brief XbhǗNX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#include "stdafx.h"

#include "thread.h"

namespace GenericUtility {

//-----------------------------------------------------------------------------
CThread::CThread() : m_hThread(NULL)
{
}

CThread::~CThread()
{
	if (m_hThread)
		::CloseHandle(m_hThread);
}

bool CThread::Create(Runnable* pRunnable)
{
	if (m_hThread)
		return false;
	m_pRunnable = NULL;
	if (!pRunnable || !pRunnable->Initialize())
		return false;
	DWORD dwThreadId;
	m_hThread = ::CreateThread(NULL, 0, CThread::ThreadProc, pRunnable, 0, &dwThreadId);
	if (!m_hThread)
		return false;
#if 0
	::SetThreadPriority(m_hThread, THREAD_PRIORITY_BELOW_NORMAL);
#endif
	m_pRunnable = pRunnable;
	return true;
}

bool CThread::Peek(DWORD* pdwReturnCode)
{
	if (!m_hThread)
		return false;
	if (::WaitForSingleObject(m_hThread, 0) != WAIT_OBJECT_0)
		return false;
	if (pdwReturnCode) {
		*pdwReturnCode = 0;
		VERIFY(::GetExitCodeThread(m_hThread, pdwReturnCode));
	}
	::CloseHandle(m_hThread);
	m_hThread = NULL;
	return true;
}

bool CThread::Stop(DWORD* pdwReturnCode)
{
	if (!m_hThread)
		return false;
	if (!m_pRunnable->Stop())
		return false;
	bool ret = true;
	if (::WaitForSingleObject(m_hThread, INFINITE) != WAIT_OBJECT_0)
		ret = false;
	if (pdwReturnCode) {
		*pdwReturnCode = 0;
		VERIFY(::GetExitCodeThread(m_hThread, pdwReturnCode));
	}
	if (!::CloseHandle(m_hThread))
		ret = false;
	m_hThread = NULL;
	return true;
}

DWORD WINAPI CThread::ThreadProc(LPVOID lpParameter)
{
	Runnable* pRunnable = static_cast<Runnable*>(lpParameter);
	if (!pRunnable)
		return ~0;
	return pRunnable->Run();
}

}	// namespace GenericUtility
