/**
 * @file  WaitableHandle.h
 * @brief WaitForSingleObject() łnh̃bpNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#ifndef WAITABLEHANDLE_H_
#define WAITABLEHANDLE_H_

namespace GenericUtility {

/////////////////////////////////////////////////////////////////////////////
/**
 * WaitForSingleObject() łnh̃bp.
 */
class CWaitableHandle
{
public:
	CWaitableHandle(HANDLE hHandle);
	virtual ~CWaitableHandle();

	/**
	 * VOiԂɂȂĂ邩ǂ.
	 */
	bool IsSet() const;
	/**
	 * VOiԂɂȂ̂҂.
	 */
	bool Wait() const;

	/**
	 * VOiԂɂȂ̂҂.
	 * @return -1 s.
	 * @return  0 handle1  set ꂽ.
	 * @return  1 handle2  set ꂽ.
	 */
	static int Wait(const CWaitableHandle& handle1, const CWaitableHandle& handle2);

	operator HANDLE() const;

protected:
	HANDLE m_hHandle;
};

/////////////////////////////////////////////////////////////////////////////
/**
 * Cxgnh̃bp.
 */
class CEvent : public CWaitableHandle, public boost::noncopyable
{
public:
	CEvent();
	virtual ~CEvent();

	bool Set();
	bool Reset();
};

}	// namespace GenericUtility

#endif
