#pragma once

#include "ListPasteDoc.h"

#include "../GenericLib/DialogPositionSaver.h"
#include "../GenericLib/DlgWithToolTip.h"
#include "../GenericLib/ResizableDialog.h"

typedef
	Dialog::CDlgWithToolTip<
		Dialog::CResizableDialog<CDialog, FALSE, FALSE, Dialog::CResizeGripper>>
	CDataGroupDlgBase;

// CDataGroupDlg dialog
/**
 * f[^O[vҏW_CAO.
 */
class CDataGroupDlg : public CDataGroupDlgBase
{
public:
	CDataGroupDlg(CListPasteDoc* pDoc, CWnd* pParent = NULL);   // standard constructor
	virtual ~CDataGroupDlg();

// Dialog Data
	enum { IDD = IDD_DIALOG_DATA_GROUP };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnNMDblclkListGroup(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclickListGroup(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnKeyDownListGroup(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnBeginLabelEditListGroup(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnEndLabelEditListGroup(NMHDR *pNMHDR, LRESULT *pResult);
	DECLARE_MESSAGE_MAP()

public:
	/**
	 * ŌɑIĂO[v擾.
	 * (DoModal() ̌ʂ IDOK ̂Ƃ̂ݗL)
	 * (< 0 ̂Ƃ́AIĂȂ)
	 */
	int GetSelectedGroup() const;

private:
	/**
	 * ݂̃Xg̑IԂɏ]āA폜.
	 */
	void DoDelete();
	/**
	 * ݂̃Xg̑IԂɏ]āAǉ.
	 */
	void DoAdd();
	/**
	 * ݂̃Xg̑IԂɏ]āAړ.
	 * @param[in] up ֈړ邩ǂ
	 */
	void DoMove(bool up);

	/**
	 * XĝׂĂ̍ڂI.
	 */
	void SelectAllItems();

	/**
	 * O[vXgXV.
	 * XVOɑIĂACȇIԂ.
	 * @param[in] bKeepSelection IԂ𕜌邩ǂ
	 * @param[in] nSelectOffset  XVɑIԂ𕜌ACe (ƂƑIĂ̂̃ItZbg)
	 */
	void UpdateList(bool bKeepSelection, int nSelectOffset = 0);

	typedef std::vector<int> IntVec;
	/**
	 * XgőIĂŏ̃ACe擾.
	 */
	int GetSelectedItem() const;
	/**
	 * XgőIĂ邷ׂẴACe擾.
	 */
	IntVec GetAllSelectedItems() const;

	/**
	 * @see CResizableDialog::OnInitializeDialogSizeHelper().
	 */
	virtual void OnInitializeDialogSizeHelper(DialogUtility::CDialogSizeHelper& dsh);

private:
	CListCtrl m_listGroups;

	/// IꂽO[v
	/// (DoModal() == IDOK ̌ŁAŌɑIĂ̂擾ł悤ɂ)
	/// (< 0 ̂Ƃ́AIĂȂ)
	int m_nSelectedGroup;

	CListPasteDoc* m_pDoc;

	/////////////////////////////////////////////////////////////////////////////
private:
	/**
	 * _CAȌԂۑ.
	 */
	void SaveDialog();
	/**
	 * _CAȌԂ𕜌.
	 */
	void RestoreDialog();

private:
	/// _CAOʒu.
	static DialogUtility::CDialogPositionSaver m_DialogPosition;
	/// O[vXgJ.
	static DialogUtility::CListColumnWidthSaver m_ListColumnWidth;
};
