/**
 * @file task_colorled.h
 * @author Shinichiro Nakamura
 * @brief カラーLEDタスクの定義。
 */

/*
 * ===============================================================
 *  Color LED Task
 * ===============================================================
 * Copyright (c) 2010-2011 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef TASK_COLORLED_H
#define TASK_COLORLED_H

#define TSKPRI_COLORLED  10      /**< カラーLEDタスクのプライオリティ。 */
#define TSKSTK_COLORLED  2048    /**< カラーLEDタスクのスタックサイズ。 */

void task_colorled(intptr_t exinf);

#define COLOR_R (1 << 0)    /**< R発光ビット。 */
#define COLOR_G (1 << 1)    /**< G発光ビット。 */
#define COLOR_B (1 << 2)    /**< B発光ビット。 */

/**
 * @brief カラーLEDタスクに色の変更をリクエストする。
 *
 * @param color 色。
 *
 * @retval 0 成功。
 * @retval !0 失敗。
 */
int tskapi_colorled_set_color(int color);

/**
 * @brief カラーLEDタスクに色の変更をリクエストする。
 * @param COLOR 色。
 */
#define TSKAPI_COLORLED_SET_COLOR(COLOR) \
    tskapi_colorled_set_color(COLOR)

#endif

