
#ifndef LPCXCLK_H
#define LPCXCLK_H

#ifdef __cplusplus
extern "C" {
#endif

#define SEGSEL_A	(1 << 0)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_B	(1 << 1)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_C	(1 << 2)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_D	(1 << 3)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_E	(1 << 4)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_F	(1 << 5)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_G	(1 << 6)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_P	(1 << 7)	/**< セグメント選択ビットマップ。 */

#define SEGSEL_NUM0	(SEGSEL_A | SEGSEL_B | SEGSEL_C | SEGSEL_D | SEGSEL_E | SEGSEL_F)		/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM1	(SEGSEL_B | SEGSEL_C)								/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM2	(SEGSEL_A | SEGSEL_B | SEGSEL_G | SEGSEL_E | SEGSEL_D)				/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM3	(SEGSEL_A | SEGSEL_B | SEGSEL_G | SEGSEL_C | SEGSEL_D)				/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM4	(SEGSEL_F | SEGSEL_G | SEGSEL_B | SEGSEL_C)					/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM5	(SEGSEL_A | SEGSEL_F | SEGSEL_G | SEGSEL_C | SEGSEL_D)				/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM6	(SEGSEL_A | SEGSEL_F | SEGSEL_E | SEGSEL_D | SEGSEL_C | SEGSEL_G)		/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM7	(SEGSEL_A | SEGSEL_B | SEGSEL_C)						/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM8	(SEGSEL_A | SEGSEL_B | SEGSEL_C | SEGSEL_D | SEGSEL_E | SEGSEL_F | SEGSEL_G)	/**< セグメント選択ビットマップ。 */
#define SEGSEL_NUM9	(SEGSEL_A | SEGSEL_B | SEGSEL_C | SEGSEL_D | SEGSEL_F | SEGSEL_G)		/**< セグメント選択ビットマップ。 */

#define SEGSEL_DOT_LEFT_UPPER           (1 << 0)	/**< ドット選択。 */
#define SEGSEL_DOT_LEFT_LOWER           (1 << 1)	/**< ドット選択。 */
#define SEGSEL_DOT_CENTER_LEFT_UPPER    (1 << 2)	/**< ドット選択。 */
#define SEGSEL_DOT_CENTER_LEFT_LOWER    (1 << 3)	/**< ドット選択。 */
#define SEGSEL_DOT_CENTER_RIGHT_UPPER   (1 << 4)	/**< ドット選択。 */
#define SEGSEL_DOT_CENTER_RIGHT_LOWER   (1 << 5)	/**< ドット選択。 */
#define SEGSEL_DOT_RIGHT_UPPER          (1 << 6)	/**< ドット選択。 */
#define SEGSEL_DOT_RIGHT_LOWER          (1 << 7)	/**< ドット選択。 */

typedef unsigned char segsel_t;

/**
 * @brief LPCXpresso Clock制御用構造体。
 * @details
 * 本来は実装の詳細をCソースコードに隠蔽し、ここでは不完全定義としたいところだ。
 * しかし、小規模組み込みシステム（特にマイコン）において、
 * ハンドラ領域を確保するための標準的なメモリアロケーションサービスが使える事を
 * 前提にしない方が移植性を高める結果を生むことがある。
 * ここでは完全定義として実装し、ユーザ側で制御構造体の領域を確保してもらう。
 */
typedef struct {
    unsigned char counter;          /**< 表示カウンタ。 */
    unsigned char colsel;           /**< カラム選択番号。 */
    segsel_t segsel[8];             /**< セグメント選択ビットマップ。 */
    unsigned char brightness[8];    /**< 輝度。 */
} lpcxclk_t;


void lpcxclk_open(lpcxclk_t *p);
void lpcxclk_7seg_write(
        lpcxclk_t *p,
        const unsigned char segsel0,
        const unsigned char segsel1,
        const unsigned char segsel2,
        const unsigned char segsel3,
        const unsigned char segsel4,
        const unsigned char segsel5,
        const segsel_t dotsel);
void lpcxclk_7seg_brightness(
        lpcxclk_t *p,
        const int index,
        const unsigned char brightness);
void lpcxclk_7seg_clock(lpcxclk_t *p);
void lpcxclk_close(lpcxclk_t *p);

#ifdef __cplusplus
}
#endif

#endif

