#ifndef TASK_CAMERA_H
#define TASK_CAMERA_H

#define TSKPRI_CAMERA   8       /**< カメラタスクのプライオリティ。 */
#define TSKSTK_CAMERA   2048    /**< カメラタスクのスタック。 */

/**
 * @brief カメラタスクの本体。
 * @param exinf タスクパラメータ。
 */
void task_camera(intptr_t exinf);

/**
 * @brief カメラタスクへのメッセージ通信用構造体。
 */
typedef struct {
    T_MSG header;       /**< カーネルが使用するメッセージヘッダ。 */
    uint8_t cmd;        /**< コマンド。 */
    uint8_t param[64];  /**< 最大64バイトのパラメータ領域。 */
} camera_msg_t;

/**
 * @brief Capture
 * @param camnum Camera number.
 */
void tskapi_camera_capture(int camnum);
#define TSKAPI_CAMERA_CAPTURE(CAMNUM)   tskapi_camera_capture(CAMNUM)

#endif

