/**
 * @file task_gps.h
 * @author Shinichiro Nakamura
 * @brief タスククロックの定義。
 */

/*
 * ===============================================================
 *  LPCXpresso Clock
 * ===============================================================
 * Copyright (c) 2010-2011 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef TASK_GPS_H
#define TASK_GPS_H

#define TSKPRI_GPS  7     /**< クロックタスクのタスクプライオリティ */
#define TSKSTK_GPS  2048  /**< クロックタスクのタスクスタック */

typedef struct {
    T_MSG header;
    uint8_t cmd;
    uint8_t param[32];
} gps_msg_t;

/**
 * @brief クロックタスクの本体。
 * @param exinf タスクパラメータ。
 */
void task_gps(intptr_t exinf);

void tskapi_gps_actmode(uint8_t actmode);
#define TSKAPI_GPS_ACTMODE(ACTMODE) \
    tskapi_gps_actmode(ACTMODE)

#endif

