;;; ntemacs-font.el -- fontsets for Emacs on Windows -*- coding: iso-2022-7bit -*-

;; Copyright (C) 2004-2005 by T. Hiromatsu <matsuan@users.sourceforge.jp>
;; Version 1_0_0

;;; Commentary:

;;----------------------------------------------------------------------
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; The GNU General Public License can be gotten from
;; the Free Software Foundation, Inc.,
;;     59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;;     http://www.gnu.org/licenses/gpl.html
;;
;;----------------------------------------------------------------------
;;      $BK\%W%m%0%i%`$O%U%j!<!&%=%U%H%&%'%"$G$9!#(B
;;      $B$"$J$?$O!"(BFree Software Foundation$B$,8xI=$7$?(BGNU $B0lHL8xM-;HMQ5vBz$N(B
;;      $B!V%P!<%8%g%s#2!W0?$$$O$=$l0J9_$N3F%P!<%8%g%s$NCf$+$i$$$:$l$+$rA*Br$7!"(B
;;      $B$=$N%P!<%8%g%s$,Dj$a$k>r9`$K=>$C$FK\%W%m%0%i%`$r(B
;;      $B:FHRI[$^$?$OJQ99$9$k$3$H$,$G$-$^$9!#(B
;;
;;      $BK\%W%m%0%i%`$OM-MQ$H$O;W$$$^$9$,!"HRI[$K$"$?$C$F$O!"(B
;;      $B;T>l@-5Z$SFCDjL\E*E,9g@-$K$D$$$F$N0EL[$NJ]>Z$r4^$a$F!"(B
;;      $B$$$+$J$kJ]>Z$b9T$J$$$^$;$s!#(B
;;      $B>\:Y$K$D$$$F$O(BGNU $B0lHL8xM-;HMQ5vBz=q$r$*FI$_$/$@$5$$!#(B
;;
;;      GNU$B0lHL8xM-;HMQ5vBz$O!"!!(B
;;      Free Software Foundation,
;;         59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
;;         http://www.gnu.org/licenses/gpl.html
;;      $B$+$iF~<j2DG=$G$9!#(B
;;
;;----------------------------------------------------------------------
;; ntemacs-font.el 2005-09-13$BHG(B;;
;;
;;  1. Introduction
;;  1.1. idea
;;      ntemacs-font provides font-width-compensation for fixed-width
;;      fontset for Emacs on W32. The reasons are:
;;          bold fonts has different width from normal font.
;;
;;      Defined fontset names are
;;          msgothic (Sans Serif)
;;          msmincho (Serif)
;;
;;      Defined sizes are
;;          point 7,8,9,10,12,14,16,18,20,24
;;
;;      then totally 20 fontsets were defined.
;;
;;  1.2. Emacs version
;;      ntemacs-font supports only CVS version of Emacs.
;;
;;  2. Usage
;;  2.1. Installation
;;      Please put two files in the folder on load-path.
;;          ntemacs-font.el (this file)
;;          fixed-width-fontset.el
;;
;;  2.2. load package
;;      (if (eq window-system 'w32) (require 'ntemacs-font))
;;
;;  2.3. set fontset
;;      Fontset names doesn't include size. If you set the fontset like as
;;          (set-default-font "fontset-msgothic")
;;      font size was set to 12 (default).
;;
;;      If you want to use another size, please use full fontset name like as
;;          (set-default-font
;;              "-*-*-medium-r-normal--10-*-*-*-*-*-fontset-msgothic")
;;          (add-to-list
;;              'default-frame-alist
;;              '(font . "-*-*-medium-r-normal--10-*-*-*-*-*-fontset-msgothic"))
;;
;;  2.4. recommendation
;;      I strongly recommend to set like as below.
;;          (setq w32-use-w32-font-dialog nil)
;;          (setq w32-enable-synthesized-fonts t)
;;
;;  3. create your own fontset
;;      If you want to create another fontset, please use  new function
;;          (fixed-width-create-fontset fontset size list)
;;              fontset : fontset name(striings)
;;              size : size or list of size that you want to create
;;              list : alist of encodings and font family name
;;    
;;      example : IPA$B%4%7%C%/(B(ipa_gohic) for ascii and Japanese
;;
;;      (setq ntemacs-font-encode-family-list-ipa
;;        '((ascii . "IPA$B%4%7%C%/(B")
;;          (latin-iso8859-1 . "Lucida Console*")
;;          (japanese-jisx0208 . "IPA$B%4%7%C%/(B*")
;;          (katakana-jisx0201 . "IPA$B%4%7%C%/(B*")
;;          (chinese-gb2312 . "Arial Unicode MS*")
;;          (chinese-big5-1 . "Arial Unicode MS*")
;;          (korean-ksc5601 . "Arial Unicode MS*")
;;          (mule-unicode-0100-24ff . "Arial Unicode MS*")
;;          (mule-unicode-e000-ffff . "Arial Unicode MS*")))
;; 
;;      (fixed-width-create-fontset "ipa"
;;                                  ntemacs-font-defined-sizes
;;                                  ntemacs-font-encode-family-list-ipa)
;;
;;      Then, you can get new fontsets "fontset-ipa", that have sizes
;;      from 7 to 24 point.
;;
;;----------------------------------------------------------------------
;;
;; 1. Introduction
;; 1.1. $B$3$N%U%!%$%k$NCf?H(B
;;	$B$3$N%U%!%$%k$O!"(BEmacs on W32 $B$G!"(Bbold $B$rEyI}$GI=<($9$k$?$a$N(B
;;	fontset$B$rDs6!$7$F$$$^$9!#(B
;;
;;	$BDj5A$7$F$$$k$N$O!"2<5-$N(B2$B<o$NJ8;z%;%C%H$G$9!#(B
;;          msgothic (Sans Serif)
;;          msmincho (Serif)
;;
;;	    point 7,8,9,10,12,14,16,18,20,24 $B$N%5%$%:(B
;;
;;	$B$rDj5A$7$F$$$^$9!#$D$^$j!"$3$N%U%!%$%k$G$O!"(B20$B<o$N!"(Bfontset $B$rDj5A(B
;;	$B$7$F$$$k$3$H$K$J$j$^$9!#(B
;;      default$B$N%5%$%:$O!"(B12$B$G$9!#(B
;; 
;; 1.2. $BF0:n4D6-(B
;;	emacs on W32 $B$O!"(BCVS$B$+$iF~<j$7$?J*$r8f;H$$$/$@$5$$!#(B
;;
;; 2. Usage($B;H$$J}(B)
;;  2.1. Install
;;      $B2<5-(B2$B$D$N%U%!%$%k$r%m!<%I%Q%9$NDL$C$?$H$3$m$KCV$$$F2<$5$$!#(B
;;          ntemacs-font.el (this file)
;;          fixed-width-fontset.el
;;
;;  2.2. load package
;;      (if (eq window-system 'w32) (require 'ntemacs-font))
;;      $B$H$7$F$/$@$5$$!#(B
;;
;;  2.3. set fontset
;;      $B<!$N$h$&$K$7$?>l9g!"(B
;;          (set-default-font "fontset-msgothic")
;;      $B#M#S%4%7%C%/$N(B12point $B$,;H$o$l$^$9!#(B
;;
;;      $B$3$l0J30$N%5%$%:$r;H$$$?$$>l9g$O!"(B
;;          (set-default-font
;;              "-*-*-medium-r-normal--10-*-*-*-*-*-fontset-msgothic")
;;          (add-to-list
;;              'default-frame-alist
;;              '(font . "-*-*-medium-r-normal--10-*-*-*-*-*-fontset-msgothic"))
;;      $B$H$7$F$/$@$5$$!#(B
;;
;;      $B:G=i$O!"(Bfontset$B$N;XDj$r$7$J$$$G!"(Bshift + click $B$G=P$F$/$k!"(Bfontset
;;      menu $B$+$i!"$*9%$_$NJ*$rC5$9J}$,NI$$$+$b$7$l$^$;$s!#(B
;;
;;  2.4. recomendation
;;      $B0J2<$N@_Dj$rDI2C$5$l$k$3$H$r!"6/$/$*4+$a$7$^$9!#(B
;;          (setq w32-use-w32-font-dialog nil)
;;          (setq w32-enable-synthesized-fonts t)
;;
;;  3. $BJL$N%U%)%s%H%;%C%H$r:n$j$?$$>l9g(B
;;      $BJL$NAH9g$;$N(B fontset $B$r@_Dj$7$?$$>l9g!#(B
;;
;;      (fixed-width-create-fontset fontset size list) $B$r;H$C$F$/$@$5$$!#(B
;;          fontset : fontset $B$NL>A0(B(striings)
;;          size : $B@_Dj$7$?$$%5%$%:!"Kt$O%5%$%:$N%j%9%H(B
;;          list : $B%(%s%3!<%G%#%s%0$H%U%)%s%H$N%U%!%_%j!<%M!<%`$NO"A[%j%9%H(B
;;         
;;      $BNc$($P!"(BIPA$B%4%7%C%/(B(ipa_gohic) $B$r!"%"%9%-!<$HF|K\8l$K;H$$$?$$>l9g!"(B
;;      $B0J2<$N$h$&$K$7$F$/$@$5$$(B
;;
;;      (setq ntemacs-font-encode-family-list-ipa
;;        '((ascii . "IPA$B%4%7%C%/(B")
;;          (latin-iso8859-1 . "Lucida Console*")
;;          (japanese-jisx0208 . "IPA$B%4%7%C%/(B*")
;;          (katakana-jisx0201 . "IPA$B%4%7%C%/(B*")
;;          (chinese-gb2312 . "Arial Unicode MS*")
;;          (chinese-big5-1 . "Arial Unicode MS*")
;;          (korean-ksc5601 . "Arial Unicode MS*")
;;          (mule-unicode-0100-24ff . "Arial Unicode MS*")
;;          (mule-unicode-e000-ffff . "Arial Unicode MS*")))
;; 
;;      (fixed-width-create-fontset "ipa"
;;                                  ntemacs-font-defined-sizes
;;                                  ntemacs-font-encode-family-list-ipa)
;;
;;      $B$rI>2A$9$l$P!"(B7$B!A(B24 $B$^$G$N%5%$%:$N(B fontset $B$,!"(Bfontset-ipa $B$H$$$&L>A0$G(B
;;      $BDj5A$5$l$^$9!#(B
;;
;;                                                  T.Hiromatsu
;;                                                  matsuan@users.sourceforge.jp

(require 'fixed-width-fontset)

(defvar fixed-width-encode-reg-alist
  '((latin-iso8859-1 . "iso8859*")
    (latin-iso8859-2 . "iso8859-2")
    (latin-iso8859-3 . "iso8859-3")
    (latin-iso8859-4 . "iso8859-4")
    (thai-tis620 . "tis620")
    (greek-iso8859-7 . "iso8859-7")
    (arabic-iso8859-6 . "iso8859-6")
    (hebrew-iso8859-8 . "iso8859-8")
    (katakana-jisx0201 . "jisx0201-katakana")
    (latin-jisx0201 . "jisx0201-latin")
    (cyrillic-iso8859-5 . "iso8859*")
    (latin-iso8859-9 . "iso8859*")
    (japanese-jisx0208-1978 . "jisx0208.1978")
    (chinese-gb2312 . "gb2312")
    (japanese-jisx0208 . "jisx0208-sjis")
    (korean-ksc5601 . "ksc5601.1987")
    (japanese-jisx0212 . "jisx0212")
    (chinese-cns11643-1 . "cns11643.1992-1")
    (chinese-cns11643-2 . "cns11643.1992-2")
    (chinese-cns11643-3 . "cns11643.1992-3")
    (chinese-cns11643-4 . "cns11643.1992-4")
    (chinese-cns11643-5 . "cns11643.1992-5")
    (chinese-cns11643-6 . "cns11643.1992-6")
    (chinese-cns11643-7 . "cns11643.1992-7")
    (chinese-big5-1 . "big5")
    (chinese-big5-2 . "big5")
    (chinese-sisheng . "sisheng_cwnn")
    (vietnamese-viscii-lower . "viscii1.1")
    (vietnamese-viscii-upper . "viscii1.1")
    (arabic-digit . "mulearabic*")
    (arabic-1-column . "mulearabic*")
    (arabic-2-column . "mulearabic*")
    (ipa . "muleipa")
    (ethiopic . "ethiopic-unicode")
    (ascii-right-to-left . "iso8859*")
    (indian-is13194 . "is13194-devanagari")
    (indian-2-column . "muleindian*")
    (lao . "mulelao*")
    (tibetan . "muletibetan*")
    (tibetan-1-column . "muletibetan*")
    (latin-iso8859-14 . "iso8859*")
    (latin-iso8859-15 . "iso8859*")
    (mule-unicode-0100-24ff . "iso10646-1")
    (mule-unicode-2500-33ff . "iso10646-1")
    (mule-unicode-e000-ffff . "iso10646-1")
    (japanese-jisx0213-1 . "jisx0213.2000*")
    (japanese-jisx0213-2 . "jisx0213.2000*")))

(defvar fixed-width-xlfd-template
  "-outline-%s-normal-r-normal-normal-%d-*-*-*-*-*-iso8859-1")

(defalias 'fixed-width-create-fontset-func 'create-fontset-from-ascii-font)

(defvar fixed-width-get-scale-alist
  '(("bold-.*-iso8859" . (( "7" . 0.8)
                          ( "8" . 0.8)
                          ( "9" . 0.9)
                          ("10" . 0.8)
                          ("12" . 0.9)
                          ("14" . 0.9)
                          ("16" . 0.9)
                          ("18" . 0.9)
                          ("20" . 0.95)
                          ("24" . 0.95)))
    ("bold-.*-jisx02" . ( ( "7" . 0.9)
                          ( "8" . 0.9)
                          ( "9" . 0.9)
                          ("10" . 0.9)
                          ("12" . 0.95)
                          ("14" . 0.95)
                          ("16" . 0.95)
                          ("18" . 0.95)
                          ("20" . 0.98)
                          ("24" . 0.98)))
    ("Arial" . (          ( "7" . 1.05)
                          ( "8" . 1.05)
                          ( "9" . 1.05)
                          ("10" . 1.05)
                          ("12" . 1.05)
                          ("14" . 1.05)
                          ("16" . 1.05)
                          ("18" . 1.05)
                          ("20" . 1.05)
                          ("24" . 1.05))))
  "ReScale factor alist for each fonts and size.")

(defvar ntemacs-font-defined-sizes '(12 7 8 9 10 14 16 18 20 24))

(defvar ntemacs-font-encode-family-list-msgothic
  '((ascii . "$B#M#S(B $B%4%7%C%/(B")
    (japanese-jisx0208 . "$B#M#S(B $B%4%7%C%/(B*")
    (katakana-jisx0201 . "$B#M#S(B $B%4%7%C%/(B*")
    (chinese-gb2312 . "Arial Unicode MS*")
    (chinese-big5-1 . "Arial Unicode MS*")
    (korean-ksc5601 . "Arial Unicode MS*")
    (mule-unicode-0100-24ff . "Arial Unicode MS*")
    (mule-unicode-e000-ffff . "Arial Unicode MS*")))

(fixed-width-create-fontset "msgothic"
                             ntemacs-font-defined-sizes
                             ntemacs-font-encode-family-list-msgothic)

(defvar ntemacs-font-encode-family-list-msmincho
  '((ascii . "$B#M#S(B $BL@D+(B")
    (japanese-jisx0208 . "$B#M#S(B $BL@D+(B*")
    (katakana-jisx0201 . "$B#M#S(B $BL@D+(B*")
    (chinese-gb2312 . "Arial Unicode MS*")
    (chinese-big5-1 . "Arial Unicode MS*")
    (korean-ksc5601 . "Arial Unicode MS*")
    (mule-unicode-0100-24ff . "Arial Unicode MS*")
    (mule-unicode-e000-ffff . "Arial Unicode MS*")))

(fixed-width-create-fontset "msmincho"
                             ntemacs-font-defined-sizes
                             ntemacs-font-encode-family-list-msmincho)

;; variable pitch $B$O(B default $B$G!"(Bhelv $B$@$1$I!"L5$$$N$G(B arial $B$KJQ99(B
;; face $B$N(B attribute $B$G!"(Bfamily $B$rJQ99(B

(set-face-attribute 'variable-pitch nil
                    :family "arial"
                    :slant 'normal
                    :weight 'normal)

(provide 'ntemacs-font)
