/*
 * States definitions file for GNU Enscript.
 * Copyright (c) 1997-2001 Markku Rossi.
 * Author: Markku Rossi <mtr@iki.fi>
 *
 * The latest version of this file can be downloaded from URL:
 *
 *     http://www.iki.fi/~mtr/genscript/enscript.st
 */

/*
 * This file is part of GNU enscript.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * $Id: enscript.st 318 2004-08-22 05:37:38Z sakito $
 */

/*
 * Guildelines for writing new highlighting rules for the GNU Enscript.
 *
 * - all highlighting states should have a document comment like this:
 *
 *   /**
 *    * Name: c
 *    * Description: C programming language.
 *    * Author: Author Name <author@email.address>
 *    * ...
 *
 *   It is used by enscript's --help-pretty-print option to print
 *   description about supported highlighting modes.
 *
 * - the main entry state (for example, for the C, the state `c') must
 *   be inherited from state `HighlightEntry':
 *
 *   state c extends HighlightEntry
 *   {
 *     ...
 *
 * - all help-states smust be inherited from state `Highlight':
 *
 *   state c_string extends Highlight
 *   {
 *     ...
 *
 * - all printing should be done with the language_print() procedure
 *   instead of the print() primitive.
 *
 * - using enscript.el to build regular expressions:
 *
 *      M-x load-file RET enscript.el RET
 *
 *   Move in the buffer to the point where the (build-re '()) ends,
 *   that is, after the last closing parenthesis ')'.  Then, type:
 *
 *      C-x C-e
 *
 *   Magic should happen.
 *
 * These rules ensures that enscript's --help-pretty-print option and
 * the different output languages (HTML, RTF, etc.) work.
 */

/* This script needs at least this version of the States program. */
prereq ("1.6.2");

/*
 * Constants, fonts, etc.
 */

debug = "0";

/* Boolean values. */
true = 1;
false = 0;

font_spec = "Courier@10";

/* These components are resolved from <font_spec>. */
font = "";
ptsize = "";

/*
 * Generatel table of contents?  This is not supported by all output
 * languages.
 */
toc = "0";

/*
 * The Highlight style.  The default style is `emacs' to imitate
 * Emacs' font lock mode.
 */
style = "macemacs";

/*
 * Create color outputs?
 */
color = "1";

/*
 * Use verbose highlighting rules?
 */
verbose_highlighting = false;

/*
 * Target language.  Possible values are:
 * - enscript		generate enscript special escapes
 * - html		generate HTML
 * - overstrike		generate overstrike (line printers, less)
 * - texinfo		generate Texinfo
 * - rtf                generate Rich Text Format (rtf - MS Word, WordPerfect)
 *                      This code can be souched into MS Word or PowerPoint
 *                      for a pretty version of the code
 */
language = "macemacs";

/*
 * How many input files we have.
 */
num_input_files = "1";
current_input_file = 0;

/*
 * Document title.
 */
document_title = "MacEmacs JP Project";

/*
 * Global variables for nested highlighting `nested.st'.
 */
nested_start = "^-+(([ \t]*)([a-zA-Z_0-9]*)([ \t]*))-+$";
nested_start_re = 0;
nested_end = "^-+$";
nested_end_re_cached = 0;
nested_end_re = 0;
nested_default = "passthrough";

/*
 * Color definitions.
 */

cindex = 0;
rgb_values = list ();

sub define_color (name, r, g, b)
{
  rgb_values[cindex] = list (name, r, g, b);
  cindex = cindex + 1;
}

sub color_index (name)
{
  local i;

  for (i = 0; i < length (rgb_values); i = i + 1)
    if (strcmp (rgb_values[i][0], name) == 0)
      return i;

  return -1;
}

sub language_color (name)
{
  local idx;

  idx = color_index (name);
  if (idx < 0)
    panic ("unknown color `", name, "'");

  /*
   * The map_color() subroutine is language specific and defined in
   * *_faces() subroutine.
   */
  map_color (rgb_values[idx][1], rgb_values[idx][2], rgb_values[idx][3]);
}

/* RGB definitions for colors.	These are borrowed from X's rgb.txt file. */

/*define_color ("black",			0, 0, 0);
define_color ("gray25",			64, 64, 64);
define_color ("gray50",			127, 127, 127);
define_color ("gray75",			191, 191, 191);
define_color ("gray85",			217, 217, 217);
define_color ("gray90",			229, 229, 229);
define_color ("gray95",			242, 242, 242);
define_color ("blue",			0, 0, 255);
define_color ("cadet blue",		95, 158, 160);
define_color ("dark goldenrod",		184, 134, 11);
define_color ("dark olive green",	85, 107, 47);
define_color ("firebrick",		178, 34, 34);
define_color ("forest green",		34, 139, 34);
define_color ("green",			0, 255, 0);
define_color ("orchid",			218, 112, 214);
define_color ("purple",			160, 32, 240);
define_color ("red",			255, 0, 0);
define_color ("rosy brown",		188, 143, 143);

define_color ("DarkSeaGreen",		143, 188, 143);
define_color ("DarkSeaGreen1",		193, 255, 193);
define_color ("DarkSeaGreen2",		180, 238, 180);
define_color ("DarkSeaGreen3",		155, 205, 155);
define_color ("DarkSeaGreen4",		105, 139, 105);
define_color ("Goldenrod",		237, 218, 116);
define_color ("Aquamarine",		67, 183, 186);
define_color ("SeaGreen2",		100, 233, 134);
define_color ("Coral",			247, 101,  65);
define_color ("DarkSlateGray1",		154, 254, 255);
define_color ("LightGrey",		211, 211, 211);*/

define_color ("snow", 255, 250, 250);
define_color ("ghost white", 248, 248, 255);
define_color ("GhostWhite", 248, 248, 255);
define_color ("white smoke", 245, 245, 245);
define_color ("WhiteSmoke", 245, 245, 245);
define_color ("gainsboro", 220, 220, 220);
define_color ("floral white", 255, 250, 240);
define_color ("FloralWhite", 255, 250, 240);
define_color ("old lace", 253, 245, 230);
define_color ("OldLace", 253, 245, 230);
define_color ("linen", 250, 240, 230);
define_color ("antique white", 250, 235, 215);
define_color ("AntiqueWhite", 250, 235, 215);
define_color ("papaya whip", 255, 239, 213);
define_color ("PapayaWhip", 255, 239, 213);
define_color ("blanched almond", 255, 235, 205);
define_color ("BlanchedAlmond", 255, 235, 205);
define_color ("bisque", 255, 228, 196);
define_color ("peach puff", 255, 218, 185);
define_color ("PeachPuff", 255, 218, 185);
define_color ("navajo white", 255, 222, 173);
define_color ("NavajoWhite", 255, 222, 173);
define_color ("moccasin", 255, 228, 181);
define_color ("cornsilk", 255, 248, 220);
define_color ("ivory", 255, 255, 240);
define_color ("lemon chiffon", 255, 250, 205);
define_color ("LemonChiffon", 255, 250, 205);
define_color ("seashell", 255, 245, 238);
define_color ("honeydew", 240, 255, 240);
define_color ("mint cream", 245, 255, 250);
define_color ("MintCream", 245, 255, 250);
define_color ("azure", 240, 255, 255);
define_color ("alice blue", 240, 248, 255);
define_color ("AliceBlue", 240, 248, 255);
define_color ("lavender", 230, 230, 250);
define_color ("lavender blush", 255, 240, 245);
define_color ("LavenderBlush", 255, 240, 245);
define_color ("misty rose", 255, 228, 225);
define_color ("MistyRose", 255, 228, 225);
define_color ("white", 255, 255, 255);
define_color ("black", 0, 0, 0);
define_color ("dark slate gray", 47, 79, 79);
define_color ("DarkSlateGray", 47, 79, 79);
define_color ("dark slate grey", 47, 79, 79);
define_color ("DarkSlateGrey", 47, 79, 79);
define_color ("dim gray", 105, 105, 105);
define_color ("DimGray", 105, 105, 105);
define_color ("dim grey", 105, 105, 105);
define_color ("DimGrey", 105, 105, 105);
define_color ("slate gray", 112, 128, 144);
define_color ("SlateGray", 112, 128, 144);
define_color ("slate grey", 112, 128, 144);
define_color ("SlateGrey", 112, 128, 144);
define_color ("light slate gray", 119, 136, 153);
define_color ("LightSlateGray", 119, 136, 153);
define_color ("light slate grey", 119, 136, 153);
define_color ("LightSlateGrey", 119, 136, 153);
define_color ("gray", 190, 190, 190);
define_color ("grey", 190, 190, 190);
define_color ("light grey", 211, 211, 211);
define_color ("LightGrey", 211, 211, 211);
define_color ("light gray", 211, 211, 211);
define_color ("LightGray", 211, 211, 211);
define_color ("midnight blue", 25, 25, 112);
define_color ("MidnightBlue", 25, 25, 112);
define_color ("navy", 0, 0, 128);
define_color ("navy blue", 0, 0, 128);
define_color ("NavyBlue", 0, 0, 128);
define_color ("cornflower blue", 100, 149, 237);
define_color ("CornflowerBlue", 100, 149, 237);
define_color ("dark slate blue", 72, 61, 139);
define_color ("DarkSlateBlue", 72, 61, 139);
define_color ("slate blue", 106, 90, 205);
define_color ("SlateBlue", 106, 90, 205);
define_color ("medium slate blue", 123, 104, 238);
define_color ("MediumSlateBlue", 123, 104, 238);
define_color ("light slate blue", 132, 112, 255);
define_color ("LightSlateBlue", 132, 112, 255);
define_color ("medium blue", 0, 0, 205);
define_color ("MediumBlue", 0, 0, 205);
define_color ("royal blue", 65, 105, 225);
define_color ("RoyalBlue", 65, 105, 225);
define_color ("blue", 0, 0, 255);
define_color ("dodger blue", 30, 144, 255);
define_color ("DodgerBlue", 30, 144, 255);
define_color ("deep sky blue", 0, 191, 255);
define_color ("DeepSkyBlue", 0, 191, 255);
define_color ("sky blue", 135, 206, 235);
define_color ("SkyBlue", 135, 206, 235);
define_color ("light sky blue", 135, 206, 250);
define_color ("LightSkyBlue", 135, 206, 250);
define_color ("steel blue", 70, 130, 180);
define_color ("SteelBlue", 70, 130, 180);
define_color ("light steel blue", 176, 196, 222);
define_color ("LightSteelBlue", 176, 196, 222);
define_color ("light blue", 173, 216, 230);
define_color ("LightBlue", 173, 216, 230);
define_color ("powder blue", 176, 224, 230);
define_color ("PowderBlue", 176, 224, 230);
define_color ("pale turquoise", 175, 238, 238);
define_color ("PaleTurquoise", 175, 238, 238);
define_color ("dark turquoise", 0, 206, 209);
define_color ("DarkTurquoise", 0, 206, 209);
define_color ("medium turquoise", 72, 209, 204);
define_color ("MediumTurquoise", 72, 209, 204);
define_color ("turquoise", 64, 224, 208);
define_color ("cyan", 0, 255, 255);
define_color ("light cyan", 224, 255, 255);
define_color ("LightCyan", 224, 255, 255);
define_color ("cadet blue", 95, 158, 160);
define_color ("CadetBlue", 95, 158, 160);
define_color ("medium aquamarine", 102, 205, 170);
define_color ("MediumAquamarine", 102, 205, 170);
define_color ("aquamarine", 127, 255, 212);
define_color ("dark green", 0, 100, 0);
define_color ("DarkGreen", 0, 100, 0);
define_color ("dark olive green", 85, 107, 47);
define_color ("DarkOliveGreen", 85, 107, 47);
define_color ("dark sea green", 143, 188, 143);
define_color ("DarkSeaGreen", 143, 188, 143);
define_color ("sea green", 46, 139, 87);
define_color ("SeaGreen", 46, 139, 87);
define_color ("medium sea green", 60, 179, 113);
define_color ("MediumSeaGreen", 60, 179, 113);
define_color ("light sea green", 32, 178, 170);
define_color ("LightSeaGreen", 32, 178, 170);
define_color ("pale green", 152, 251, 152);
define_color ("PaleGreen", 152, 251, 152);
define_color ("spring green", 0, 255, 127);
define_color ("SpringGreen", 0, 255, 127);
define_color ("lawn green", 124, 252, 0);
define_color ("LawnGreen", 124, 252, 0);
define_color ("green", 0, 255, 0);
define_color ("chartreuse", 127, 255, 0);
define_color ("medium spring green", 0, 250, 154);
define_color ("MediumSpringGreen", 0, 250, 154);
define_color ("green yellow", 173, 255, 47);
define_color ("GreenYellow", 173, 255, 47);
define_color ("lime green", 50, 205, 50);
define_color ("LimeGreen", 50, 205, 50);
define_color ("yellow green", 154, 205, 50);
define_color ("YellowGreen", 154, 205, 50);
define_color ("forest green", 34, 139, 34);
define_color ("ForestGreen", 34, 139, 34);
define_color ("olive drab", 107, 142, 35);
define_color ("OliveDrab", 107, 142, 35);
define_color ("dark khaki", 189, 183, 107);
define_color ("DarkKhaki", 189, 183, 107);
define_color ("khaki", 240, 230, 140);
define_color ("pale goldenrod", 238, 232, 170);
define_color ("PaleGoldenrod", 238, 232, 170);
define_color ("light goldenrod yellow", 250, 250, 210);
define_color ("LightGoldenrodYellow", 250, 250, 210);
define_color ("light yellow", 255, 255, 224);
define_color ("LightYellow", 255, 255, 224);
define_color ("yellow", 255, 255, 0);
define_color ("gold", 255, 215, 0);
define_color ("light goldenrod", 238, 221, 130);
define_color ("LightGoldenrod", 238, 221, 130);
define_color ("goldenrod", 218, 165, 32);
define_color ("dark goldenrod", 184, 134, 11);
define_color ("DarkGoldenrod", 184, 134, 11);
define_color ("rosy brown", 188, 143, 143);
define_color ("RosyBrown", 188, 143, 143);
define_color ("indian red", 205, 92, 92);
define_color ("IndianRed", 205, 92, 92);
define_color ("saddle brown", 139, 69, 19);
define_color ("SaddleBrown", 139, 69, 19);
define_color ("sienna", 160, 82, 45);
define_color ("peru", 205, 133, 63);
define_color ("burlywood", 222, 184, 135);
define_color ("beige", 245, 245, 220);
define_color ("wheat", 245, 222, 179);
define_color ("sandy brown", 244, 164, 96);
define_color ("SandyBrown", 244, 164, 96);
define_color ("tan", 210, 180, 140);
define_color ("chocolate", 210, 105, 30);
define_color ("firebrick", 178, 34, 34);
define_color ("brown", 165, 42, 42);
define_color ("dark salmon", 233, 150, 122);
define_color ("DarkSalmon", 233, 150, 122);
define_color ("salmon", 250, 128, 114);
define_color ("light salmon", 255, 160, 122);
define_color ("LightSalmon", 255, 160, 122);
define_color ("orange", 255, 165, 0);
define_color ("dark orange", 255, 140, 0);
define_color ("DarkOrange", 255, 140, 0);
define_color ("coral", 255, 127, 80);
define_color ("light coral", 240, 128, 128);
define_color ("LightCoral", 240, 128, 128);
define_color ("tomato", 255, 99, 71);
define_color ("orange red", 255, 69, 0);
define_color ("OrangeRed", 255, 69, 0);
define_color ("red", 255, 0, 0);
define_color ("hot pink", 255, 105, 180);
define_color ("HotPink", 255, 105, 180);
define_color ("deep pink", 255, 20, 147);
define_color ("DeepPink", 255, 20, 147);
define_color ("pink", 255, 192, 203);
define_color ("light pink", 255, 182, 193);
define_color ("LightPink", 255, 182, 193);
define_color ("pale violet red", 219, 112, 147);
define_color ("PaleVioletRed", 219, 112, 147);
define_color ("maroon", 176, 48, 96);
define_color ("medium violet red", 199, 21, 133);
define_color ("MediumVioletRed", 199, 21, 133);
define_color ("violet red", 208, 32, 144);
define_color ("VioletRed", 208, 32, 144);
define_color ("magenta", 255, 0, 255);
define_color ("violet", 238, 130, 238);
define_color ("plum", 221, 160, 221);
define_color ("orchid", 218, 112, 214);
define_color ("medium orchid", 186, 85, 211);
define_color ("MediumOrchid", 186, 85, 211);
define_color ("dark orchid", 153, 50, 204);
define_color ("DarkOrchid", 153, 50, 204);
define_color ("dark violet", 148, 0, 211);
define_color ("DarkViolet", 148, 0, 211);
define_color ("blue violet", 138, 43, 226);
define_color ("BlueViolet", 138, 43, 226);
define_color ("purple", 160, 32, 240);
define_color ("medium purple", 147, 112, 219);
define_color ("MediumPurple", 147, 112, 219);
define_color ("thistle", 216, 191, 216);
define_color ("snow1", 255, 250, 250);
define_color ("snow2", 238, 233, 233);
define_color ("snow3", 205, 201, 201);
define_color ("snow4", 139, 137, 137);
define_color ("seashell1", 255, 245, 238);
define_color ("seashell2", 238, 229, 222);
define_color ("seashell3", 205, 197, 191);
define_color ("seashell4", 139, 134, 130);
define_color ("AntiqueWhite1", 255, 239, 219);
define_color ("AntiqueWhite2", 238, 223, 204);
define_color ("AntiqueWhite3", 205, 192, 176);
define_color ("AntiqueWhite4", 139, 131, 120);
define_color ("bisque1", 255, 228, 196);
define_color ("bisque2", 238, 213, 183);
define_color ("bisque3", 205, 183, 158);
define_color ("bisque4", 139, 125, 107);
define_color ("PeachPuff1", 255, 218, 185);
define_color ("PeachPuff2", 238, 203, 173);
define_color ("PeachPuff3", 205, 175, 149);
define_color ("PeachPuff4", 139, 119, 101);
define_color ("NavajoWhite1", 255, 222, 173);
define_color ("NavajoWhite2", 238, 207, 161);
define_color ("NavajoWhite3", 205, 179, 139);
define_color ("NavajoWhite4", 139, 121, 94);
define_color ("LemonChiffon1", 255, 250, 205);
define_color ("LemonChiffon2", 238, 233, 191);
define_color ("LemonChiffon3", 205, 201, 165);
define_color ("LemonChiffon4", 139, 137, 112);
define_color ("cornsilk1", 255, 248, 220);
define_color ("cornsilk2", 238, 232, 205);
define_color ("cornsilk3", 205, 200, 177);
define_color ("cornsilk4", 139, 136, 120);
define_color ("ivory1", 255, 255, 240);
define_color ("ivory2", 238, 238, 224);
define_color ("ivory3", 205, 205, 193);
define_color ("ivory4", 139, 139, 131);
define_color ("honeydew1", 240, 255, 240);
define_color ("honeydew2", 224, 238, 224);
define_color ("honeydew3", 193, 205, 193);
define_color ("honeydew4", 131, 139, 131);
define_color ("LavenderBlush1", 255, 240, 245);
define_color ("LavenderBlush2", 238, 224, 229);
define_color ("LavenderBlush3", 205, 193, 197);
define_color ("LavenderBlush4", 139, 131, 134);
define_color ("MistyRose1", 255, 228, 225);
define_color ("MistyRose2", 238, 213, 210);
define_color ("MistyRose3", 205, 183, 181);
define_color ("MistyRose4", 139, 125, 123);
define_color ("azure1", 240, 255, 255);
define_color ("azure2", 224, 238, 238);
define_color ("azure3", 193, 205, 205);
define_color ("azure4", 131, 139, 139);
define_color ("SlateBlue1", 131, 111, 255);
define_color ("SlateBlue2", 122, 103, 238);
define_color ("SlateBlue3", 105, 89, 205);
define_color ("SlateBlue4", 71, 60, 139);
define_color ("RoyalBlue1", 72, 118, 255);
define_color ("RoyalBlue2", 67, 110, 238);
define_color ("RoyalBlue3", 58, 95, 205);
define_color ("RoyalBlue4", 39, 64, 139);
define_color ("blue1", 0, 0, 255);
define_color ("blue2", 0, 0, 238);
define_color ("blue3", 0, 0, 205);
define_color ("blue4", 0, 0, 139);
define_color ("DodgerBlue1", 30, 144, 255);
define_color ("DodgerBlue2", 28, 134, 238);
define_color ("DodgerBlue3", 24, 116, 205);
define_color ("DodgerBlue4", 16, 78, 139);
define_color ("SteelBlue1", 99, 184, 255);
define_color ("SteelBlue2", 92, 172, 238);
define_color ("SteelBlue3", 79, 148, 205);
define_color ("SteelBlue4", 54, 100, 139);
define_color ("DeepSkyBlue1", 0, 191, 255);
define_color ("DeepSkyBlue2", 0, 178, 238);
define_color ("DeepSkyBlue3", 0, 154, 205);
define_color ("DeepSkyBlue4", 0, 104, 139);
define_color ("SkyBlue1", 135, 206, 255);
define_color ("SkyBlue2", 126, 192, 238);
define_color ("SkyBlue3", 108, 166, 205);
define_color ("SkyBlue4", 74, 112, 139);
define_color ("LightSkyBlue1", 176, 226, 255);
define_color ("LightSkyBlue2", 164, 211, 238);
define_color ("LightSkyBlue3", 141, 182, 205);
define_color ("LightSkyBlue4", 96, 123, 139);
define_color ("SlateGray1", 198, 226, 255);
define_color ("SlateGray2", 185, 211, 238);
define_color ("SlateGray3", 159, 182, 205);
define_color ("SlateGray4", 108, 123, 139);
define_color ("LightSteelBlue1", 202, 225, 255);
define_color ("LightSteelBlue2", 188, 210, 238);
define_color ("LightSteelBlue3", 162, 181, 205);
define_color ("LightSteelBlue4", 110, 123, 139);
define_color ("LightBlue1", 191, 239, 255);
define_color ("LightBlue2", 178, 223, 238);
define_color ("LightBlue3", 154, 192, 205);
define_color ("LightBlue4", 104, 131, 139);
define_color ("LightCyan1", 224, 255, 255);
define_color ("LightCyan2", 209, 238, 238);
define_color ("LightCyan3", 180, 205, 205);
define_color ("LightCyan4", 122, 139, 139);
define_color ("PaleTurquoise1", 187, 255, 255);
define_color ("PaleTurquoise2", 174, 238, 238);
define_color ("PaleTurquoise3", 150, 205, 205);
define_color ("PaleTurquoise4", 102, 139, 139);
define_color ("CadetBlue1", 152, 245, 255);
define_color ("CadetBlue2", 142, 229, 238);
define_color ("CadetBlue3", 122, 197, 205);
define_color ("CadetBlue4", 83, 134, 139);
define_color ("turquoise1", 0, 245, 255);
define_color ("turquoise2", 0, 229, 238);
define_color ("turquoise3", 0, 197, 205);
define_color ("turquoise4", 0, 134, 139);
define_color ("cyan1", 0, 255, 255);
define_color ("cyan2", 0, 238, 238);
define_color ("cyan3", 0, 205, 205);
define_color ("cyan4", 0, 139, 139);
define_color ("DarkSlateGray1", 151, 255, 255);
define_color ("DarkSlateGray2", 141, 238, 238);
define_color ("DarkSlateGray3", 121, 205, 205);
define_color ("DarkSlateGray4", 82, 139, 139);
define_color ("aquamarine1", 127, 255, 212);
define_color ("aquamarine2", 118, 238, 198);
define_color ("aquamarine3", 102, 205, 170);
define_color ("aquamarine4", 69, 139, 116);
define_color ("DarkSeaGreen1", 193, 255, 193);
define_color ("DarkSeaGreen2", 180, 238, 180);
define_color ("DarkSeaGreen3", 155, 205, 155);
define_color ("DarkSeaGreen4", 105, 139, 105);
define_color ("SeaGreen1", 84, 255, 159);
define_color ("SeaGreen2", 78, 238, 148);
define_color ("SeaGreen3", 67, 205, 128);
define_color ("SeaGreen4", 46, 139, 87);
define_color ("PaleGreen1", 154, 255, 154);
define_color ("PaleGreen2", 144, 238, 144);
define_color ("PaleGreen3", 124, 205, 124);
define_color ("PaleGreen4", 84, 139, 84);
define_color ("SpringGreen1", 0, 255, 127);
define_color ("SpringGreen2", 0, 238, 118);
define_color ("SpringGreen3", 0, 205, 102);
define_color ("SpringGreen4", 0, 139, 69);
define_color ("green1", 0, 255, 0);
define_color ("green2", 0, 238, 0);
define_color ("green3", 0, 205, 0);
define_color ("green4", 0, 139, 0);
define_color ("chartreuse1", 127, 255, 0);
define_color ("chartreuse2", 118, 238, 0);
define_color ("chartreuse3", 102, 205, 0);
define_color ("chartreuse4", 69, 139, 0);
define_color ("OliveDrab1", 192, 255, 62);
define_color ("OliveDrab2", 179, 238, 58);
define_color ("OliveDrab3", 154, 205, 50);
define_color ("OliveDrab4", 105, 139, 34);
define_color ("DarkOliveGreen1", 202, 255, 112);
define_color ("DarkOliveGreen2", 188, 238, 104);
define_color ("DarkOliveGreen3", 162, 205, 90);
define_color ("DarkOliveGreen4", 110, 139, 61);
define_color ("khaki1", 255, 246, 143);
define_color ("khaki2", 238, 230, 133);
define_color ("khaki3", 205, 198, 115);
define_color ("khaki4", 139, 134, 78);
define_color ("LightGoldenrod1", 255, 236, 139);
define_color ("LightGoldenrod2", 238, 220, 130);
define_color ("LightGoldenrod3", 205, 190, 112);
define_color ("LightGoldenrod4", 139, 129, 76);
define_color ("LightYellow1", 255, 255, 224);
define_color ("LightYellow2", 238, 238, 209);
define_color ("LightYellow3", 205, 205, 180);
define_color ("LightYellow4", 139, 139, 122);
define_color ("yellow1", 255, 255, 0);
define_color ("yellow2", 238, 238, 0);
define_color ("yellow3", 205, 205, 0);
define_color ("yellow4", 139, 139, 0);
define_color ("gold1", 255, 215, 0);
define_color ("gold2", 238, 201, 0);
define_color ("gold3", 205, 173, 0);
define_color ("gold4", 139, 117, 0);
define_color ("goldenrod1", 255, 193, 37);
define_color ("goldenrod2", 238, 180, 34);
define_color ("goldenrod3", 205, 155, 29);
define_color ("goldenrod4", 139, 105, 20);
define_color ("DarkGoldenrod1", 255, 185, 15);
define_color ("DarkGoldenrod2", 238, 173, 14);
define_color ("DarkGoldenrod3", 205, 149, 12);
define_color ("DarkGoldenrod4", 139, 101, 8);
define_color ("RosyBrown1", 255, 193, 193);
define_color ("RosyBrown2", 238, 180, 180);
define_color ("RosyBrown3", 205, 155, 155);
define_color ("RosyBrown4", 139, 105, 105);
define_color ("IndianRed1", 255, 106, 106);
define_color ("IndianRed2", 238, 99, 99);
define_color ("IndianRed3", 205, 85, 85);
define_color ("IndianRed4", 139, 58, 58);
define_color ("sienna1", 255, 130, 71);
define_color ("sienna2", 238, 121, 66);
define_color ("sienna3", 205, 104, 57);
define_color ("sienna4", 139, 71, 38);
define_color ("burlywood1", 255, 211, 155);
define_color ("burlywood2", 238, 197, 145);
define_color ("burlywood3", 205, 170, 125);
define_color ("burlywood4", 139, 115, 85);
define_color ("wheat1", 255, 231, 186);
define_color ("wheat2", 238, 216, 174);
define_color ("wheat3", 205, 186, 150);
define_color ("wheat4", 139, 126, 102);
define_color ("tan1", 255, 165, 79);
define_color ("tan2", 238, 154, 73);
define_color ("tan3", 205, 133, 63);
define_color ("tan4", 139, 90, 43);
define_color ("chocolate1", 255, 127, 36);
define_color ("chocolate2", 238, 118, 33);
define_color ("chocolate3", 205, 102, 29);
define_color ("chocolate4", 139, 69, 19);
define_color ("firebrick1", 255, 48, 48);
define_color ("firebrick2", 238, 44, 44);
define_color ("firebrick3", 205, 38, 38);
define_color ("firebrick4", 139, 26, 26);
define_color ("brown1", 255, 64, 64);
define_color ("brown2", 238, 59, 59);
define_color ("brown3", 205, 51, 51);
define_color ("brown4", 139, 35, 35);
define_color ("salmon1", 255, 140, 105);
define_color ("salmon2", 238, 130, 98);
define_color ("salmon3", 205, 112, 84);
define_color ("salmon4", 139, 76, 57);
define_color ("LightSalmon1", 255, 160, 122);
define_color ("LightSalmon2", 238, 149, 114);
define_color ("LightSalmon3", 205, 129, 98);
define_color ("LightSalmon4", 139, 87, 66);
define_color ("orange1", 255, 165, 0);
define_color ("orange2", 238, 154, 0);
define_color ("orange3", 205, 133, 0);
define_color ("orange4", 139, 90, 0);
define_color ("DarkOrange1", 255, 127, 0);
define_color ("DarkOrange2", 238, 118, 0);
define_color ("DarkOrange3", 205, 102, 0);
define_color ("DarkOrange4", 139, 69, 0);
define_color ("coral1", 255, 114, 86);
define_color ("coral2", 238, 106, 80);
define_color ("coral3", 205, 91, 69);
define_color ("coral4", 139, 62, 47);
define_color ("tomato1", 255, 99, 71);
define_color ("tomato2", 238, 92, 66);
define_color ("tomato3", 205, 79, 57);
define_color ("tomato4", 139, 54, 38);
define_color ("OrangeRed1", 255, 69, 0);
define_color ("OrangeRed2", 238, 64, 0);
define_color ("OrangeRed3", 205, 55, 0);
define_color ("OrangeRed4", 139, 37, 0);
define_color ("red1", 255, 0, 0);
define_color ("red2", 238, 0, 0);
define_color ("red3", 205, 0, 0);
define_color ("red4", 139, 0, 0);
define_color ("DeepPink1", 255, 20, 147);
define_color ("DeepPink2", 238, 18, 137);
define_color ("DeepPink3", 205, 16, 118);
define_color ("DeepPink4", 139, 10, 80);
define_color ("HotPink1", 255, 110, 180);
define_color ("HotPink2", 238, 106, 167);
define_color ("HotPink3", 205, 96, 144);
define_color ("HotPink4", 139, 58, 98);
define_color ("pink1", 255, 181, 197);
define_color ("pink2", 238, 169, 184);
define_color ("pink3", 205, 145, 158);
define_color ("pink4", 139, 99, 108);
define_color ("LightPink1", 255, 174, 185);
define_color ("LightPink2", 238, 162, 173);
define_color ("LightPink3", 205, 140, 149);
define_color ("LightPink4", 139, 95, 101);
define_color ("PaleVioletRed1", 255, 130, 171);
define_color ("PaleVioletRed2", 238, 121, 159);
define_color ("PaleVioletRed3", 205, 104, 137);
define_color ("PaleVioletRed4", 139, 71, 93);
define_color ("maroon1", 255, 52, 179);
define_color ("maroon2", 238, 48, 167);
define_color ("maroon3", 205, 41, 144);
define_color ("maroon4", 139, 28, 98);
define_color ("VioletRed1", 255, 62, 150);
define_color ("VioletRed2", 238, 58, 140);
define_color ("VioletRed3", 205, 50, 120);
define_color ("VioletRed4", 139, 34, 82);
define_color ("magenta1", 255, 0, 255);
define_color ("magenta2", 238, 0, 238);
define_color ("magenta3", 205, 0, 205);
define_color ("magenta4", 139, 0, 139);
define_color ("orchid1", 255, 131, 250);
define_color ("orchid2", 238, 122, 233);
define_color ("orchid3", 205, 105, 201);
define_color ("orchid4", 139, 71, 137);
define_color ("plum1", 255, 187, 255);
define_color ("plum2", 238, 174, 238);
define_color ("plum3", 205, 150, 205);
define_color ("plum4", 139, 102, 139);
define_color ("MediumOrchid1", 224, 102, 255);
define_color ("MediumOrchid2", 209, 95, 238);
define_color ("MediumOrchid3", 180, 82, 205);
define_color ("MediumOrchid4", 122, 55, 139);
define_color ("DarkOrchid1", 191, 62, 255);
define_color ("DarkOrchid2", 178, 58, 238);
define_color ("DarkOrchid3", 154, 50, 205);
define_color ("DarkOrchid4", 104, 34, 139);
define_color ("purple1", 155, 48, 255);
define_color ("purple2", 145, 44, 238);
define_color ("purple3", 125, 38, 205);
define_color ("purple4", 85, 26, 139);
define_color ("MediumPurple1", 171, 130, 255);
define_color ("MediumPurple2", 159, 121, 238);
define_color ("MediumPurple3", 137, 104, 205);
define_color ("MediumPurple4", 93, 71, 139);
define_color ("thistle1", 255, 225, 255);
define_color ("thistle2", 238, 210, 238);
define_color ("thistle3", 205, 181, 205);
define_color ("thistle4", 139, 123, 139);
define_color ("gray0", 0, 0, 0);
define_color ("grey0", 0, 0, 0);
define_color ("gray1", 3, 3, 3);
define_color ("grey1", 3, 3, 3);
define_color ("gray2", 5, 5, 5);
define_color ("grey2", 5, 5, 5);
define_color ("gray3", 8, 8, 8);
define_color ("grey3", 8, 8, 8);
define_color ("gray4", 10, 10, 10);
define_color ("grey4", 10, 10, 10);
define_color ("gray5", 13, 13, 13);
define_color ("grey5", 13, 13, 13);
define_color ("gray6", 15, 15, 15);
define_color ("grey6", 15, 15, 15);
define_color ("gray7", 18, 18, 18);
define_color ("grey7", 18, 18, 18);
define_color ("gray8", 20, 20, 20);
define_color ("grey8", 20, 20, 20);
define_color ("gray9", 23, 23, 23);
define_color ("grey9", 23, 23, 23);
define_color ("gray10", 26, 26, 26);
define_color ("grey10", 26, 26, 26);
define_color ("gray11", 28, 28, 28);
define_color ("grey11", 28, 28, 28);
define_color ("gray12", 31, 31, 31);
define_color ("grey12", 31, 31, 31);
define_color ("gray13", 33, 33, 33);
define_color ("grey13", 33, 33, 33);
define_color ("gray14", 36, 36, 36);
define_color ("grey14", 36, 36, 36);
define_color ("gray15", 38, 38, 38);
define_color ("grey15", 38, 38, 38);
define_color ("gray16", 41, 41, 41);
define_color ("grey16", 41, 41, 41);
define_color ("gray17", 43, 43, 43);
define_color ("grey17", 43, 43, 43);
define_color ("gray18", 46, 46, 46);
define_color ("grey18", 46, 46, 46);
define_color ("gray19", 48, 48, 48);
define_color ("grey19", 48, 48, 48);
define_color ("gray20", 51, 51, 51);
define_color ("grey20", 51, 51, 51);
define_color ("gray21", 54, 54, 54);
define_color ("grey21", 54, 54, 54);
define_color ("gray22", 56, 56, 56);
define_color ("grey22", 56, 56, 56);
define_color ("gray23", 59, 59, 59);
define_color ("grey23", 59, 59, 59);
define_color ("gray24", 61, 61, 61);
define_color ("grey24", 61, 61, 61);
define_color ("gray25", 64, 64, 64);
define_color ("grey25", 64, 64, 64);
define_color ("gray26", 66, 66, 66);
define_color ("grey26", 66, 66, 66);
define_color ("gray27", 69, 69, 69);
define_color ("grey27", 69, 69, 69);
define_color ("gray28", 71, 71, 71);
define_color ("grey28", 71, 71, 71);
define_color ("gray29", 74, 74, 74);
define_color ("grey29", 74, 74, 74);
define_color ("gray30", 77, 77, 77);
define_color ("grey30", 77, 77, 77);
define_color ("gray31", 79, 79, 79);
define_color ("grey31", 79, 79, 79);
define_color ("gray32", 82, 82, 82);
define_color ("grey32", 82, 82, 82);
define_color ("gray33", 84, 84, 84);
define_color ("grey33", 84, 84, 84);
define_color ("gray34", 87, 87, 87);
define_color ("grey34", 87, 87, 87);
define_color ("gray35", 89, 89, 89);
define_color ("grey35", 89, 89, 89);
define_color ("gray36", 92, 92, 92);
define_color ("grey36", 92, 92, 92);
define_color ("gray37", 94, 94, 94);
define_color ("grey37", 94, 94, 94);
define_color ("gray38", 97, 97, 97);
define_color ("grey38", 97, 97, 97);
define_color ("gray39", 99, 99, 99);
define_color ("grey39", 99, 99, 99);
define_color ("gray40", 102, 102, 102);
define_color ("grey40", 102, 102, 102);
define_color ("gray41", 105, 105, 105);
define_color ("grey41", 105, 105, 105);
define_color ("gray42", 107, 107, 107);
define_color ("grey42", 107, 107, 107);
define_color ("gray43", 110, 110, 110);
define_color ("grey43", 110, 110, 110);
define_color ("gray44", 112, 112, 112);
define_color ("grey44", 112, 112, 112);
define_color ("gray45", 115, 115, 115);
define_color ("grey45", 115, 115, 115);
define_color ("gray46", 117, 117, 117);
define_color ("grey46", 117, 117, 117);
define_color ("gray47", 120, 120, 120);
define_color ("grey47", 120, 120, 120);
define_color ("gray48", 122, 122, 122);
define_color ("grey48", 122, 122, 122);
define_color ("gray49", 125, 125, 125);
define_color ("grey49", 125, 125, 125);
define_color ("gray50", 127, 127, 127);
define_color ("grey50", 127, 127, 127);
define_color ("gray51", 130, 130, 130);
define_color ("grey51", 130, 130, 130);
define_color ("gray52", 133, 133, 133);
define_color ("grey52", 133, 133, 133);
define_color ("gray53", 135, 135, 135);
define_color ("grey53", 135, 135, 135);
define_color ("gray54", 138, 138, 138);
define_color ("grey54", 138, 138, 138);
define_color ("gray55", 140, 140, 140);
define_color ("grey55", 140, 140, 140);
define_color ("gray56", 143, 143, 143);
define_color ("grey56", 143, 143, 143);
define_color ("gray57", 145, 145, 145);
define_color ("grey57", 145, 145, 145);
define_color ("gray58", 148, 148, 148);
define_color ("grey58", 148, 148, 148);
define_color ("gray59", 150, 150, 150);
define_color ("grey59", 150, 150, 150);
define_color ("gray60", 153, 153, 153);
define_color ("grey60", 153, 153, 153);
define_color ("gray61", 156, 156, 156);
define_color ("grey61", 156, 156, 156);
define_color ("gray62", 158, 158, 158);
define_color ("grey62", 158, 158, 158);
define_color ("gray63", 161, 161, 161);
define_color ("grey63", 161, 161, 161);
define_color ("gray64", 163, 163, 163);
define_color ("grey64", 163, 163, 163);
define_color ("gray65", 166, 166, 166);
define_color ("grey65", 166, 166, 166);
define_color ("gray66", 168, 168, 168);
define_color ("grey66", 168, 168, 168);
define_color ("gray67", 171, 171, 171);
define_color ("grey67", 171, 171, 171);
define_color ("gray68", 173, 173, 173);
define_color ("grey68", 173, 173, 173);
define_color ("gray69", 176, 176, 176);
define_color ("grey69", 176, 176, 176);
define_color ("gray70", 179, 179, 179);
define_color ("grey70", 179, 179, 179);
define_color ("gray71", 181, 181, 181);
define_color ("grey71", 181, 181, 181);
define_color ("gray72", 184, 184, 184);
define_color ("grey72", 184, 184, 184);
define_color ("gray73", 186, 186, 186);
define_color ("grey73", 186, 186, 186);
define_color ("gray74", 189, 189, 189);
define_color ("grey74", 189, 189, 189);
define_color ("gray75", 191, 191, 191);
define_color ("grey75", 191, 191, 191);
define_color ("gray76", 194, 194, 194);
define_color ("grey76", 194, 194, 194);
define_color ("gray77", 196, 196, 196);
define_color ("grey77", 196, 196, 196);
define_color ("gray78", 199, 199, 199);
define_color ("grey78", 199, 199, 199);
define_color ("gray79", 201, 201, 201);
define_color ("grey79", 201, 201, 201);
define_color ("gray80", 204, 204, 204);
define_color ("grey80", 204, 204, 204);
define_color ("gray81", 207, 207, 207);
define_color ("grey81", 207, 207, 207);
define_color ("gray82", 209, 209, 209);
define_color ("grey82", 209, 209, 209);
define_color ("gray83", 212, 212, 212);
define_color ("grey83", 212, 212, 212);
define_color ("gray84", 214, 214, 214);
define_color ("grey84", 214, 214, 214);
define_color ("gray85", 217, 217, 217);
define_color ("grey85", 217, 217, 217);
define_color ("gray86", 219, 219, 219);
define_color ("grey86", 219, 219, 219);
define_color ("gray87", 222, 222, 222);
define_color ("grey87", 222, 222, 222);
define_color ("gray88", 224, 224, 224);
define_color ("grey88", 224, 224, 224);
define_color ("gray89", 227, 227, 227);
define_color ("grey89", 227, 227, 227);
define_color ("gray90", 229, 229, 229);
define_color ("grey90", 229, 229, 229);
define_color ("gray91", 232, 232, 232);
define_color ("grey91", 232, 232, 232);
define_color ("gray92", 235, 235, 235);
define_color ("grey92", 235, 235, 235);
define_color ("gray93", 237, 237, 237);
define_color ("grey93", 237, 237, 237);
define_color ("gray94", 240, 240, 240);
define_color ("grey94", 240, 240, 240);
define_color ("gray95", 242, 242, 242);
define_color ("grey95", 242, 242, 242);
define_color ("gray96", 245, 245, 245);
define_color ("grey96", 245, 245, 245);
define_color ("gray97", 247, 247, 247);
define_color ("grey97", 247, 247, 247);
define_color ("gray98", 250, 250, 250);
define_color ("grey98", 250, 250, 250);
define_color ("gray99", 252, 252, 252);
define_color ("grey99", 252, 252, 252);
define_color ("gray100", 255, 255, 255);
define_color ("grey100", 255, 255, 255);
define_color ("dark grey", 169, 169, 169);
define_color ("DarkGrey", 169, 169, 169);
define_color ("dark gray", 169, 169, 169);
define_color ("DarkGray", 169, 169, 169);
define_color ("dark blue", 0, 0, 139);
define_color ("DarkBlue", 0, 0, 139);
define_color ("dark cyan", 0, 139, 139);
define_color ("DarkCyan", 0, 139, 139);
define_color ("dark magenta", 139, 0, 139);
define_color ("DarkMagenta", 139, 0, 139);
define_color ("dark red", 139, 0, 0);
define_color ("DarkRed", 139, 0, 0);
define_color ("light green", 144, 238, 144);
define_color ("LightGreen", 144, 238, 144);


/*
 * General helpers.
 */

sub debug (msg)
{
  if (debug_level)
    print ("DEBUG: ", msg, "\n");
}

sub is_prefix (prefix, string)
{
  return strncmp (prefix, string, length (prefix)) == 0;
}

sub strchr (string, ch)
{
  local len = length (string), i;

  for (i = 0; i < len; i = i + 1)
    if (string[i] == ch)
      return i;

  return -1;
}

sub need_version (major, minor, beta)
{
  local r, v, i;

  regmatch (version, (/([0-9]+)\.([0-9]+)\.([0-9]+)/));
  v = list (int ($1), int ($2), int ($3));
  r = list (major, minor, beta);

  for (i = 0; i < 3; i = i + 1)
    if (v[i] > r[i])
      return 1;
    else if (v[i] < r[i])
      return 0;

  /* Exact match. */
  return 1;
}

/* Highlight types which match expression <re> from string <data>. */
sub highlight_types (data, re)
{
  local match_len;

  while (regmatch (data, re))
    {
      language_print ($B);
      type_face (true);
      language_print ($0);
      type_face (false);

      match_len = length ($B, $0);

      data = substring (data, match_len, length (data));
    }

  language_print (data);
}


/*
 * The supported faces.  These functions are used in the highlighting
 * rules to mark different logical elements of the code.  The
 * different faces and their properties (face_*) are defined in the
 * style definition files.  The face_on() and face_off() functions are
 * defined in the output language definition files.
 */

sub bold (on)
{
  if (on)
    face_on (face_bold);
  else
    face_off (face_bold);
}

sub italic (on)
{
  if (on)
    face_on (face_italic);
  else
    face_off (face_italic);
}

sub bold_italic (on)
{
  if (on)
    face_on (face_bold_italic);
  else
    face_off (face_bold_italic);
}

sub comment_face (on)
{
  if (on)
    face_on (face_comment);
  else
    face_off (face_comment);
}

sub function_name_face (on)
{
  if (on)
    face_on (face_function_name);
  else
    face_off (face_function_name);
}

sub variable_name_face (on)
{
  if (on)
    face_on (face_variable_name);
  else
    face_off (face_variable_name);
}

sub keyword_face (on)
{
  if (on)
    face_on (face_keyword);
  else
    face_off (face_keyword);
}

sub reference_face (on)
{
  if (on)
    face_on (face_reference);
  else
    face_off (face_reference);
}

sub string_face (on)
{
  if (on)
    face_on (face_string);
  else
    face_off (face_string);
}

sub builtin_face (on)
{
  if (on)
    face_on (face_builtin);
  else
    face_off (face_builtin);
}

sub type_face (on)
{
  if (on)
    face_on (face_type);
  else
    face_off (face_type);
}

sub highlight_face (on)
{
  if (on)
    face_on (face_highlight);
  else
    face_off (face_highlight);
}


/*
 * Initializations.
 */

start
{
  /* Set debug level. */
  debug_level = int (debug);

  /* Use colors? */
  color = int (color);

  /* Increment input file count. */
  current_input_file = current_input_file + 1;

  /* Resolve fonts. */
  idx = strchr (font_spec, '@');
  if (idx < 0)
    panic ("malformed font spec: `", font_spec, "'");

  font = substring (font_spec, 0, idx);
  ptsize = substring (font_spec, idx + 1, length (font_spec));

  debug (concat ("start: ", font, "@", ptsize));

  /* Construct bold, italic, etc. fonts for our current body font. */
  if (is_prefix ("AvantGarde", font))
    {
      bold_font = "AvantGarde-Demi";
      italic_font = "AvantGarde-BookOblique";
      bold_italic_font = "AvantGarde-DemiOblique";
    }
  else if (regmatch (font, /^Bookman|Souvenir/))
    {
      bold_font = concat ($0, "-Demi");
      italic_font = concat ($0, "-LightItalic");
      bold_italic_font = concat ($0, "-DemiItalic");
    }
  else if (regmatch (font, /^Lucida(Sans-)?Typewriter/))
    {
      bold_font = concat ($0, "Bold");
      italic_font = concat ($0, "Oblique");
      bold_italic_font = concat ($0, "BoldOblique");
    }
  else if (regmatch (font, /^(.*)-Roman$/))
    {
      bold_font = concat ($1, "-Bold");
      italic_font = concat ($1, "-Italic");
      bold_italic_font = concat ($1, "-BoldItalic");
    }
  else
    {
      bold_font = concat (font, "-Bold");
      italic_font = concat (font, "-Oblique");
      bold_italic_font = concat (font, "-BoldOblique");
    }

  /* Create regular expressions for nested highlighting. */
  nested_start_re = regexp (nested_start);
  nested_end_re_cached = regexp (nested_end);

  /* Define output faces. */
  calln (concat ("lang_", language));

  /* Define our highlight style. */
  calln (concat ("style_", style));

  /* Resolve start state. */
  if (check_startrules ())
    debug ("startstate from startrules");
  if (check_namerules ())
    debug ("startstate from namerules");
}

namerules
{
  /\.(c|h)$/					c;
  /\.(c++|C|H|cpp|cc|cxx)$/			cpp;
  /\.m$/					matlab;
  /\.(mpl|mp|maple)$/				maple;
  /\.(scm|scheme)$/				scheme;
  /\b\.emacs$|\.el$/				elisp;
  /\.ad(s|b|a)$/				ada;
  /\.[Ss]$/					asm;
  /\.st$/					states;
  /(M|m)akefile.*/				makefile;
  /\.(MOD|DEF|mi|md)$/				modula_2;
  /\.tcl$/					tcl;
  /\.(v|vh)$/					verilog;
  /\.html?$/					html;
  /\bChangeLog$/				changelog;
  /\.(vhd|vhdl)$/				vhdl;
  /\.(scr|.syn|.synth)$/			synopsys;
  /\.idl$/					idl;
  /\.(hs|lhs|gs|lgs)$/				haskell;
  /\.(pm|pl)$/					perl;
  /\.(eps|EPS|ps|PS)$/				postscript;
  /\.py$/					python;
  /\.js$/					javascript;
  /\.java$/					java;
  /\.([Pp][Aa][Ss]|[Pp][Pp]|[Pp])$/		pascal;
  /\.[fF]$/					fortran;
  /\.awk$/					awk;
  /\.sh$/					sh;
  /\.vba$/					vba;
  /\.(cshrc|login|logout|history|csh)$/		csh;
  /\.tcshrc$/					tcsh;
  /\.(zshenv|zprofile|zshrc|zlogin|zlogout)$/	zsh;
  /\.(bash_profile|bashrc|inputrc)$/		bash;
  /\.m4$/					m4;
  /\.il$/					skill;
  /\.wrl$/					vrml;
  /\b(rfc.*\.txt|draft-.*\.txt)$/		rfc;
  /\.inf$/i					inf;
  /\.tex$/					tex;
  /\.wmlscript$/				wmlscript;
  /\.wmls$/					wmlscript;
  /^.*$/					passthrough;
}

startrules
{
  /.\010.\010.\010./					nroff;
  /-\*- [Cc] -\*-/					c;
  /-\*- [Cc]\+\+ -\*-/					cpp;
  /-\*- [Aa][Dd][Aa] -\*-/				ada;
  /-\*- [Aa][Ss][Mm] -\*-/				asm;
  /-\*- [Oo][Bb][Jj][Cc] -\*-/				objc;
  /-\*- [Ss][Cc][Hh][Ee][Mm][Ee] -\*-/			scheme;
  /-\*- [Ee][Mm][Aa][Cc][Ss] [Ll][Ii][Ss][Pp] -\*-/	elisp;
  /-\*- [Tt][Cc][Ll] -\*-/				tcl;
  /-\*- [Vv][Hh][Dd][Ll] -\*-/				vhdl;
  /-\*- [Hh][Aa][Ss][Kk][Ee][Ll][Ll] -\*-/		haskell;
  /-\*- [Ii][Dd][Ll] -\*-/				idl;
  /-\*- [Pp][Ee][Rr][Ll] -\*-/				perl;
  /^#![ \t]*\/.*\/perl/					perl;
  /^From:/						mail;
  /^#![ \t]*(\/usr)?\/bin\/[ngmt]?awk/			awk;
  /^#![ \t]*(\/usr)?\/bin\/sh/				sh;
  /^#![ \t]*(\/usr)?\/bin\/csh/				csh;
  /^#![ \t]*(\/usr)?(\/local)?\/bin\/tcsh/		tcsh;
  /^#![ \t]*(\/usr)?(\/local)?\/bin\/zsh/		zsh;
  /^#![ \t]*(\/usr)?(\/local)?\/bin\/bash/		bash;
  /^#![ \t]*(\/usr)?(\/ccs)?\/bin\/m4/			m4;
  /^#VRML/						vrml;
  /^\04?%!/						postscript;
}


/*
 * The global super states.
 */

state Highlight
{
  /* If you want to preserve enscript's escape sequences in the state
     highlighting, uncomment the following rule.  It passes all
     enscript's escape sequences to the output.

       /^\0[^{]+{[^}]+}/ {
        language_print ($0);
       }
  */

  /* If we are doing nested highlighting (same document can contain
     multiple highlighting styles), the variable `nested_end_re'
     specifies the end of the nesting highlight state. */
  nested_end_re {
    language_print($0);
    return;
  }

  /* Skip output language's special characters. */
  LANGUAGE_SPECIALS {
    language_print ($0);
  }
}

/* How many nesting HighlightEntry states are currently active.  The
   header and trailer will be printed at the nesting level 0. */
highlight_entry_nesting = 0;

state HighlightEntry extends Highlight
{
  BEGIN {
    if (highlight_entry_nesting++ == 0)
      header();
  }
  END {
    if (--highlight_entry_nesting == 0)
      trailer();
  }
}



/*
 * Helper subroutines and states.
 */

state match_balanced_block extends Highlight
{
  match_balanced_block_start {
    language_print ($0);
    match_balanced_block_count = match_balanced_block_count + 1;
  }

  match_balanced_block_end {
    match_balanced_block_count = match_balanced_block_count - 1;
    if (match_balanced_block_count == 0)
      return $0;

    language_print ($0);
  }
}

sub match_balanced_block (starter, ender)
{
  match_balanced_block_count = 1;
  match_balanced_block_start = starter;
  match_balanced_block_end = ender;
  return call (match_balanced_block);
}

state eat_one_line
{
  /.*\n/ {
    language_print ($0);
    return;
  }
}


/*
Local variables:
mode: c
End:
*/
