
state lang_macemacs
{
  BEGIN {
    /* RGB -> HTML color mapper function. */
    sub map_color (r, g, b)
      {
	return sprintf ("#%02X%02X%02X", r, g, b);
      }

    LANGUAGE_SPECIALS = /[<>\&\"]/;

    sub language_print (str)
      {
	str = regsuball (str, /\&/, "&amp;");
	str = regsuball (str, /</, "&lt;");
	str = regsuball (str, />/, "&gt;");
	str = regsuball (str, /\"/, "&quot;");
	print (str);
      }

    sub language_symbol (symbol)
      {
	return false;
      }

    sub header ()
      {
	local i;

	if (current_input_file == 1)
	  {
	    print ("<!DOCTYPE html PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n");
	    print ("<html>\n<head>\n<title>");
	    language_print ("MacEmacs JP Project");
	    print ("</title>\n</head>\n",
		   color
		   ? "<body bgcolor=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#1F00FF\" ALINK=\"#FF0000\" VLINK=\"#9900DD\">"
		   : "<body>",
		   "\n<a href=\"http://macemacsjp.sourceforge.jp/\"><img id=\"logo\" src=\"../emacs.png\" width=\"80\" height=\"80\" alt=\"macemacsjp\" title=\"macemacsjp\" /></a>\n<a href=\"http://sourceforge.jp/\"><img style=\"float: right;\" src=\"http://sourceforge.jp/sflogo.php?group_id=994\" width=\"96\" height=\"31\" border=\"0\" alt=\"SourceForge.jp\"></a>\nMacEmacs JP Project<br />\n<a name=\"top\">\n");

	    if (need_version (1, 5, 1) && int (toc) == 1)
	      {
		if (length (argv) == 0)
		  argv[0] = "(stdin)";

		print ("<h1>Contents</h1>\n<ol>\n");
		for (i = 0; i < length (argv); i = i + 1)
		  print ("  <li><a href=\"#file", i + 1, "\">", argv[i],
			 "</a>\n");
		print ("</ol>\n<hr>\n");
	      }
	  }

	print ("<a name=\"file", current_input_file, "\">\n<h1>");
	language_print (filename);

	if (int (num_input_files) > 1)
	  print (" ", current_input_file, "/", num_input_files);

	print ("</h1>\n");

	/* Navigation bar. */
	if (need_version (1, 5, 1))
	  {
	    if (length (argv) >= 2 )
	      {
		print ("[<a href=\"#top\">top</a>]");

		if (current_input_file == 1)
		  print ("[prev]");
		else
		  print ("[<a href=\"\#file", current_input_file - 1,
			 "\">prev</a>]");

		if (current_input_file == length (argv))
		  print ("[next]");
		else
		  print ("[<a href=\"#file", current_input_file + 1,
			 "\">next</a>]");
	      }
	  }
	else
	  print ("[<a href=\"#top\">top</a>]");
	print ("\n<pre>\n");
      }

    sub trailer ()
      {
	print ("</pre>
<hr>\n");
	if (current_input_file == int (num_input_files))
	  print ("<address>Generated by ",
		 "<a href=\"http://www.iki.fi/~mtr/genscript/\">",
		 substring (version, strchr (version, 'G'), length (version)),
		 "</a>.</address>
</body>
</html>\n");
      }

    sub face_on (face)
      {
	if (face[boldp])
	  print ("<b>");
	if (face[italicp])
	  print ("<i>");

	if (face[fg_color])
      print ("<span style=\"color: ", face[fg_color], "\">");
    if (face[bg_color])
      print ("<span style=\"background-color: ", face[bg_color], "\">");
      }

    sub face_off (face)
      {
	if (face[fg_color])
      print ("</span>");
    if (face[bg_color])
      print ("</span>");

	if (face[italicp])
	  print ("</i>");
	if (face[boldp])
	  print ("</b>");
      }

    return;
  }
}


/*
Local variables:
mode: c
End:
*/
