
state lang_macemacs_linenumbers
{
  BEGIN {
    /* RGB -> HTML color mapper function. */
    sub map_color (r, g, b)
      {
	return sprintf ("#%02X%02X%02X", r, g, b);
      }

    LANGUAGE_SPECIALS = /./;

    LASTEND = "-";
    FACEON = "";
    FACEOFF = "";

    sub language_print (str)
      {
      	local s, l, i;
	dofaceoff ();
	if (strcmp(LASTEND, "\n") == 0)
          {
	    l = sprintf("%d", $.);
      	    s = sprintf( "<font color=\"#393939\"><a name=\"%s\"></a><a href=#%s>%s</a></font>&nbsp;&nbsp;", l, l, l);
	    for (i = 0; i < 4 - length(l); i = i + 1)
	      print("&nbsp;");
	    print(s);
          }

	str = regsuball (str, /\&/, "&amp;");
	str = regsuball (str, /</, "&lt;");
	str = regsuball (str, />/, "&gt;");
	str = regsuball (str, /\"/, "&quot;");

	dofaceon();
	print(str);
	LASTEND = substring(str, length(str) - 1, length(str));
      }

    sub language_symbol (symbol)
      {
	return false;
      }

    sub header ()
      {
	local i;

	if (current_input_file == 1)
	  {
	    print ("<!DOCTYPE html PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n");
	    print ("<html>\n<head>\n<title>");
	    language_print (document_title);
	    print ("</title>\n</head>\n",
		   color
		   ? "<body BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#1F00FF\" ALINK=\"#FF0000\" VLINK=\"#9900DD\">"
		   : "<body>",
		   "\n<a name=\"top\">\n");

	    if (need_version (1, 5, 1) && int (toc) == 1)
	      {
		if (length (argv) == 0)
		  argv[0] = "(stdin)";

		print ("<h1>Contents</h1>\n<ol>\n");
		for (i = 0; i < length (argv); i = i + 1)
		  print ("  <li><a href=\"#file", i + 1, "\">", argv[i],
			 "</a>\n");
		print ("</ol>\n<hr />\n");
	      }
	  }

	print ("<a name=\"file", current_input_file, "\">\n<h1>");
	language_print (filename);

	if (int (num_input_files) > 1)
	  print (" ", current_input_file, "/", num_input_files);

	print ("</h1>\n");

	/* Navigation bar. */
	if (need_version (1, 5, 1))
	  {
	    if (length (argv) >= 2 )
	      {
		print ("[<a href=\"#top\">top</a>]");

		if (current_input_file == 1)
		  print ("[prev]");
		else
		  print ("[<a href=\"\#file", current_input_file - 1,
			 "\">prev</a>]");

		if (current_input_file == length (argv))
		  print ("[next]");
		else
		  print ("[<a href=\"#file", current_input_file + 1,
			 "\">next</a>]");
	      }
	  }
	else
	  print ("[<a href=\"#top\">top</A>]");
	print ("\n<pre>\n");
	LASTEND = "\n";
	FACEON = "";
	FACEOFF = "";
     }

    sub trailer ()
      {
	dofaceon();
	dofaceoff();
	print ("</pre>
<hr />\n");
	if (current_input_file == int (num_input_files))
	  print ("<address>Generated by ",
		 "<a href=\"http://www.iki.fi/~mtr/genscript/\">",
		 substring (version, strchr (version, 'G'), length (version)),
		 "</a>.</address>
</body>
</html>\n");
      }

    sub face_on (face)
      {
	if (face[boldp])
	  FACEON = concat (FACEON, "<b>");
	if (face[italicp])
	  FACEON = concat (FACEON, "<i>");

	if (face[fg_color])
	  FACEON = concat (FACEON, "<span style=\"color: ", face[fg_color], "\">");
    if (face[bg_color])
      FACEON = concat (FACEON, "<span style=\"background-color: ", face[bg_color], "\">");
      }

    sub face_off (face)
      {
	if (face[fg_color])
	  FACEOFF = concat (FACEOFF, "</span>");
    if (face[bg_color])
      FACEOFF = concat (FACEOFF, "</span>");

	if (face[italicp])
	  FACEOFF = concat (FACEOFF, "</i>");
	if (face[boldp])
	  FACEOFF = concat (FACEOFF, "</b>");
      }

    sub dofaceon ()
      {
	if (length(FACEON) > 0)
	  {
	    print(FACEON);
	    FACEON = "";
	  }
      }
    sub dofaceoff ()
      {
	if (length(FACEOFF) > 0)
	  {
	    print(FACEOFF);
	    FACEOFF = "";
	  }
      }
    return;
  }
}


/*
Local variables:
mode: c
End:
*/
