#import "COPrintPanelController.h"

@implementation COPrintPanelController

- (id)init
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Load nib
    if (![NSBundle loadNibNamed:@"PrintPanel" owner:self]) {
        // Error
        NSLog(@"Can't load PrintPanel.nib");
    }
    
    return self;
}

- (NSView*)view
{
    return _view;
}

- (BOOL)isPrintBackgournd
{
    return [_backgroundCheckBox state] == NSOnState;
}

- (void)setPrintBackgroundAction:(id)sender
{
    // Set print background
    [[_webView preferences] setShouldPrintBackgrounds:[self isPrintBackgournd]];
}

- (void)setWebView:(WebView*)webView
{
    _webView = webView;
    
    [self setPrintBackgroundAction:self];
}

@end
