;;; autoloads for external elisp libraries

;; In order to keep elisp variables clean, only (autoload ...) and
;; (add-to-list 'auto-mode-alist ...) should be allowed here.

;; gnuplot-mode
(autoload 'gnuplot-mode "gnuplot" "gnuplot major mode" t)
(autoload 'gnuplot-make-buffer "gnuplot" "open a buffer in gnuplot-mode" t)
(add-to-list 'auto-mode-alist '("\\.gp\\'" . gnuplot-mode))

;; haskell-mode
(load "haskell-site-file" t)

;; howm
(autoload 'howm-create "howm" "Hitori Otegaru Wiki Modoki." t)
(autoload 'howm-menu "howm" "Hitori Otegaru Wiki Modoki." t)

;; html-helper-mode
(autoload 'html-helper-mode "html-helper-mode" "Yay HTML" t)

;; imaxima
(autoload 'imaxima "imaxima" "Image support for Maxima." t)
(autoload 'imath-mode "imath" "Interactive Math minor mode." t)

;; js-mode
(autoload 'js-mode "js" "Major mode for editing JavaScript." t)
(add-to-list 'auto-mode-alist '("\\.js\\'" . js-mode))

;; lua-mode
(autoload 'lua-mode "lua-mode" "Lua editing mode." t)
(add-to-list 'auto-mode-alist '("\\.lua\\'" . lua-mode))

;; muse
(autoload 'muse-mode "muse-mode"
  "Muse is an Emacs mode for authoring and publishing documents" t)

;; php-mode
(autoload 'php-mode "php-mode" "Major mode for editing PHP code." t)
(add-to-list 'auto-mode-alist '("\\.php[s34]?\\'" . php-mode))
(add-to-list 'auto-mode-alist '("\\.phtml\\'" . php-mode))
(add-to-list 'auto-mode-alist '("\\.inc\\'" . php-mode))

;; po-mode
(autoload 'po-mode "po-mode"
  "Major mode for translators when they edit PO files.

Special commands:
\\{po-mode-map}
Turning on PO mode calls the value of the variable 'po-mode-hook',
if that value is non-nil.  Behaviour may be adjusted through some variables,
all reachable through 'M-x customize', in group 'Emacs.Editing.I18n.Po'."
  t)
(add-to-list 'auto-mode-alist '("\\.po\\'\\|\\.po\\." . po-mode))

;; psvn
(autoload 'svn-checkout "psvn" "Run svn checkout REPOS-URL PATH." t)
(defalias 'svn-examine 'svn-status)
(autoload 'svn-status "psvn" "Subversion interface for emacs" t)

;; riece
(autoload 'riece "riece" "An IRC client for Emacs." t)

;; ruby (inf-ruby)
(autoload 'run-ruby "inf-ruby" "Run an inferior Ruby process")
(autoload 'inf-ruby-keys "inf-ruby"
  "Set local key defs for inf-ruby in ruby-mode")

;; ruby (ruby-electric)
(autoload 'ruby-electric-mode "ruby-electric" "Ruby Electric minor mode." t)

;; smart-dnd
(autoload 'smart-dnd-setup "smart-dnd" "Configurable drag-n-drop feature." t)

;; yaml-mode
(autoload 'yaml-mode "yaml-mode" nil t)
(add-to-list 'auto-mode-alist '("\\.yml\\'" . yaml-mode))


;;; extra-autoloads.el ends here.
