<?php

class BruteSearch extends SearchMySQL {

        /**
         * Parse the user's query and transform it into an SQL fragment which will
         * become part of a WHERE clause
         *
         * @param $filteredText string
         * @param $fullText string
         *
         * @return string
         */
        function parseQuery( $filteredText, $fulltext ) {
                global $wgContLang;
                $lc = SearchEngine::legalSearchChars(); // Minus format chars
                $searchon = '';
                $this->searchTerms = array();

                global $wgDBmysql5;
                $field = $this->getIndexField( $fulltext );

                # @todo FIXME: This doesn't handle parenthetical expressions.
                $m = array();
                if( preg_match_all( '/([-+<>~]?)(([' . $lc . ']+)(\*?)|"[^"]*")/',
                          $filteredText, $m, PREG_SET_ORDER ) ) {
                        foreach( $m as $bits ) {
                                @list( /* all */, $modifier, $term, $nonQuoted, $wildcard ) = $bits;

                                if( $nonQuoted != '' ) {
                                        $term = $nonQuoted;
                                        $quote = '';
                                } else {
                                        $term = str_replace( '"', '', $term );
                                        $quote = '"';
                                }

                                if( $searchon !== '' ) $searchon .= ' ';
                                if( $this->strictMatching && ($modifier == '') ) {
                                        // If we leave this out, boolean op defaults to OR which is rarely helpful.
                                        $modifier = '+';
                                }


                                // Match individual terms or quoted phrase in result highlighting...
                                $regexp = $this->regexTerm( $term, $wildcard );
                                  $term = $this->db->strencode( $term );
                                  if ( !empty( $searchon ) ) { $searchon .= ' AND '; }
                                  if ( $modifier == '-' ) { $searchon .= ' NOT '; }
                                  if ( $wgDBmysql5 ) {
                                    $searchon .= (" $field LIKE '%" . $term . "%' COLLATE utf8_general_ci ");
                                  } else {
                                    $searchon .= (" $field LIKE '%" . $term . "%' ");
                                  }
                                $this->searchTerms[] = $regexp;
                        }
                        wfDebug( __METHOD__ . ": Would search with '$searchon'\n" );
                        wfDebug( __METHOD__ . ': Match with /' . implode( '|', $this->searchTerms ) . "/\n" );
                } else {
                        wfDebug( __METHOD__ . ": Can't understand search query '{$filteredText}'\n" );
                }

                if ( empty( $searchon ) ) { $searchon = ' FALSE '; } /* dummy */

                return $searchon;
        }

        function regexTerm( $string, $wildcard ) {
                global $wgContLang;

                $regex = preg_quote( $string, '/' );

                        // For Chinese, words may legitimately abut other words in the text literal.
                        // Don't add \b boundary checks... note this could cause false positives
                        // for latin chars.

                return $regex;
        }

        /**
         * Picks which field to index on, depending on what type of query.
         * @param bool $fulltext
         * @return string
         */
        function getIndexField( $fulltext ) {
                return $fulltext ? 'old_text' : 'page_title';
        }

        /**
         * Get the base part of the search query.
         *
         * @param $filteredTerm String
         * @param $fulltext Boolean
         * @since 1.18 (changed)
         */
        function queryMain( &$query, $filteredTerm, $fulltext ) {
                $match = $this->parseQuery( $filteredTerm, $fulltext );
                $query['tables'][] = 'page';
                $query['tables'][] = 'text';
                $query['tables'][] = 'revision';
                $query['fields'][] = 'page_id';
                $query['fields'][] = 'page_namespace';
                $query['fields'][] = 'page_title';
                $query['conds'][] = 'old_id=rev_text_id';
                $query['conds'][] = 'rev_page=page_id';
                $query['conds'][] = 'page_latest=rev_id';
                $query['conds'][] = $match;
        }

}
?>
