/*
main.m

Author: Makoto Kinoshita

Copyright 2005 HMDT. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY HMDT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL HMDT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

NSString*   COURLString = nil;
float       COCompressionFactor = 1.0;
NSString*   COFormatName = nil;
NSString*   COOutputFileName = nil;
int         COScreenWidth = 0;
int         COScreenHeight = 0;
float       COOutputSizeRatio = 0.0;
int         COOutputSizeWidth = 0;
int         COOutputSizeHeight = 0;
BOOL        COIsVerboseMode = NO;
BOOL        COIsDialogMode = NO;
float       COTimerTime = 0.0;

NSArray*    COFormats = nil;

void COPrintHelp()
{
    fprintf(stderr, "coral 1.0\n");
    fprintf(stderr, "Usage: coral [options...] <url>\n");
    fprintf(stderr, "Options:\n");
    fprintf(stderr, " -c/--compress <float>  Specify compression factor\n");
    fprintf(stderr, " -f/--format <format>  Specify output file format\n");
    fprintf(stderr, " -h/--help  Print this help\n");
    fprintf(stderr, " -o/--output <file>  Specify output file name\n");
    fprintf(stderr, " -s/--screen <width height>  Specify rendering screen size\n");
    fprintf(stderr, " -S/--SIZE <ratio> | <width height>  Specify output image size\n");
    fprintf(stderr, " -d/--dialog  Use print dialog\n");
    fprintf(stderr, " -t/--timer <time> Self timer mode\n");
    fprintf(stderr, " -v/--verbose  Verbose mode\n");
}

int main(int argc, char* argv[])
{
    // Create auto release pool
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    // Tokenize argv
    NSMutableArray* arg;
    arg = [NSMutableArray array];
    
    int i;
    for (i = 1; i < argc; i++) {
        NSString*   string;
        NSArray*    components;
        string = [NSString stringWithCString:argv[i]];
        components = [string componentsSeparatedByString:@" "];
        if (components && [components count] > 0) {
            [arg addObjectsFromArray:components];
        }
    }
    [arg removeObject:@" "];
    
    // Create formats array
    COFormats = [NSArray arrayWithObjects:
            @"jpg", @"JPG", @"jpeg", @"JPEG", 
            @"png", @"PNG", 
            @"gif", @"GIF", 
            @"tif", @"TIF", @"tiff", @"TIFF", 
            @"pdf", @"PDF", 
            nil];
    
    // Parse arguments
    BOOL            isLegal = YES;
    NSEnumerator*   enumerator;
    NSString*       tmp;
    enumerator = [arg objectEnumerator];
    while (tmp = [enumerator nextObject]) {
        // Compress option
        if ([tmp isEqualToString:@"-c"] || 
            [tmp isEqualToString:@"--compress"])
        {
            // Get compression factor vale
            if (!(tmp = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong format name\n");
                isLegal = NO;
                break;
            }
            COCompressionFactor = [tmp floatValue];
            if (COCompressionFactor < 0.0 || COCompressionFactor > 1.0) {
                // Error
                fprintf(stderr, "coral: Wrong compression factor value\n");
                isLegal = NO;
                break;
            }
            continue;
        }
        
        // Format option
        if ([tmp isEqualToString:@"-f"] || 
            [tmp isEqualToString:@"--format"])
        {
            // Get format name
            if (!(COFormatName = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong format name\n");
                isLegal = NO;
                break;
            }
            
            if (![COFormats containsObject:COFormatName]) {
                // Error
                fprintf(stderr, "coral: Unsupported format name\n");
                isLegal = NO;
                break;
            }
            continue;
        }
        
        // Help option
        if ([tmp isEqualToString:@"-h"] || 
            [tmp isEqualToString:@"--help"])
        {
            // Print help
            COPrintHelp();
            
            isLegal = NO;
            break;
        }
        
        // Output option
        if ([tmp isEqualToString:@"-o"] || 
            [tmp isEqualToString:@"--output"])
        {
            // Get file name
            if (!(COOutputFileName = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong output file name\n");
                isLegal = NO;
                break;
            }
            
            if (!COOutputFileName) {
                // Error
                fprintf(stderr, "coral: Wrong output file name\n");
                isLegal = NO;
                break;
            }
            continue;
        }
        
        // Screen option
        if ([tmp isEqualToString:@"-s"] || 
            [tmp isEqualToString:@"--screen"])
        {
            // Get screen size
            if (!(tmp = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong screen size\n");
                isLegal = NO;
                break;
            }
            COScreenWidth = [tmp intValue];
            
            if (!(tmp = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong screen size\n");
                isLegal = NO;
                break;
            }
            COScreenHeight = [tmp intValue];
            
            if (COScreenWidth <= 0 || COScreenHeight <= 0) {
                // Error
                fprintf(stderr, "coral: Wrong screen size\n");
                isLegal = NO;
                break;
            }
            continue;
        }
        
        // Size option
        if ([tmp isEqualToString:@"-S"] || 
            [tmp isEqualToString:@"--SIZE"])
        {
            // Get output size
            if (!(tmp = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong output size\n");
                isLegal = NO;
                break;
            }
            
            float   ratio;
            ratio = [tmp floatValue];
            if (ratio > 0.0 && ratio <= 1.0) {
                COOutputSizeRatio = ratio;
                continue;
            }
            
            COOutputSizeWidth = [tmp intValue];
            if (!(tmp = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong screen size\n");
                isLegal = NO;
                break;
            }
            COOutputSizeHeight = [tmp intValue];
            
            if (COOutputSizeWidth <= 0 || COOutputSizeHeight <= 0) {
                // Error
                fprintf(stderr, "coral: Wrong output size\n");
                isLegal = NO;
                break;
            }
            continue;
        }
        
        // Dailog option
        if ([tmp isEqualToString:@"-d"] || 
            [tmp isEqualToString:@"--dialog"])
        {
            // Set verbose mode
            COIsDialogMode = YES;
            continue;
        }
        
        // Verbose option
        if ([tmp isEqualToString:@"-v"] || 
            [tmp isEqualToString:@"--verbose"])
        {
            // Set verbose mode
            COIsVerboseMode = YES;
            continue;
        }
        
        // Timer option
        if ([tmp isEqualToString:@"-t"] || 
            [tmp isEqualToString:@"--timer"])
        {
            // Get time
            if (!(tmp = [enumerator nextObject])) {
                // Error
                fprintf(stderr, "coral: Wrong timer value\n");
                isLegal = NO;
                break;
            }
            
            COTimerTime = [tmp floatValue];
            
            continue;
        }
        
        // URL
        COURLString = tmp;
        if (!COURLString) {
            // Error
            fprintf(stderr, "coral: Wrong URL string\n");
            isLegal = NO;
            break;
        }
    }
    
    // Check URL string
    if (!COURLString) {
        // Error
        fprintf(stderr, "coral: No URL is specified\n");
        isLegal = NO;
    }
    
    // Start Cocoa run loop
    int result = 0;
    if (isLegal) {
        result = NSApplicationMain(argc, (const char**)argv);
    }
    
    [pool release];
    return result;
}
