#include"CDataFileParser.h"
#include"CString.h"
#include"FileIO/CFileRead.h"
#include"FileIO/CFileWrite.h"
#include"Compress/CCompressZlib.h"
#include"../Auxiliary/CString.h"
#include"../Auxiliary/Debug/CAssert.h"
#include"../Auxiliary/Debug/CWarning.h"
#include"../Auxiliary/Debug/CTrace.h"


namespace Maid
{

/*!
 *	\class CData CDataFileParser.h
 *	\brief f[^
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CData::CData()
{
	m_Type = TYPE_STRING;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *	\param	text	[i ]	eLXg
 */
CData::CData( const mstring& text )
{
	m_Type = TYPE_STRING;
	m_Data = text;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *	\param	val	[i ]	鐔l
 */
CData::CData( int val )
{
	char buf[16];
	sprintf( buf, "%d", val );

	m_Type = TYPE_INTEGER;
	m_Data = CString::ConvertSJIStoMAID(buf);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^𕶎ƂĎ擾
/*!
 	\param	str	[ o]	ݒ肳ϐ
 */
mstring CData::GetString()	const
{
	MAID_ASSERT( m_Type!=TYPE_STRING, "l𕶎ŎoƂĂ܂ " << m_Data );

	return m_Data;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^𐮐lƂĎ擾
/*!
 	\param	val	[ o]	ݒ肳ϐ
 */
int CData::GetInteger()	const
{
	MAID_ASSERT( m_Type!=TYPE_INTEGER, "𐔒lŎoƂĂ܂ " << m_Data );

	return CString::AtoI( m_Data );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̌^擾
/*!
 *	\return	ǒ^
 */
CData::TYPE CData::GetType() const
{
	return m_Type;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ʂĐݒ肷
/*!
 *	\param	str	[ o]	ʂ镶
 */
void CData::Reset( const mstring& str )
{
	if( str.empty() )	 { m_Type = TYPE_INTEGER; }
	ef( str[0]=='\"' )
	{
		m_Data = str.substr( 1, str.length()-2 );
		m_Type = TYPE_STRING;
		return ;
	}
	if( IsRange('0',str[0],'9')|| str[0]=='-' )	{ m_Type = TYPE_INTEGER; }
	else										{ m_Type = TYPE_STRING; }

	m_Data = str;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@Cɏގ̃f[^Ŏ擾
/*!
 *	\return ̂܂܏߂镶
 */
const mstring CData::GetFileTypeData() const
{
	if( m_Type!=TYPE_STRING ) { return m_Data; }

	return MAIDTEXT("\"") + m_Data + MAIDTEXT("\"");

}


/*!
 *	\class	CDataTag DenDataFileParser.h
 *	\brief	ef[^ ̔z
\n			^O͂Ȃ炸ł
 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CDataTag::CDataTag()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CDataTag::~CDataTag()
{
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃^O̖Oݒ肷
/*!
 *	\param  TagName		[i ]	ݒ肷^O
 */
void CDataTag::SetTagName( const mstring& TagName )
{
	m_TagName = CString::ToLower(TagName); 
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^ǉ
/*!
 *	\param  Data		[i ]	ǉf[^
 */
void CDataTag::AddData( const mstring& Data   )
{
	m_DataList.push_back( Data ); 
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^ǉ
/*!
 *	\param  Data		[i ]	ǉf[^
 */
void CDataTag::AddData( int Data   )
{
	m_DataList.push_back( Data ); 
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^ǉ
/*!
 *	\param  Data		[i ]	ǉf[^
 */
void	CDataTag::AddData( const CData& Data   )
{
	m_DataList.push_back( Data ); 
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^ǉ
/*!
 *	݂̔zĂ삵܂
 *
 *
 *	\param  Index		[i ]	ݒ肷ʒu
 *	\param  Data		[i ]	ݒ肷f[^
 */
void	CDataTag::SetData( unt Index, const CData& Data   )
{
	if( !(Index<m_DataList.size()) ) { m_DataList.resize( Index+1 ); }

	m_DataList[Index] = Data;

}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃^O̖O擾
/*!
 *	\return	^O̖O
\n			^O͂Ȃ炸ł
 */
const mstring& CDataTag::GetTagName() const
{
	return m_TagName; 
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃^OɊi[Ăvf擾
/*!
 *	\return  vf
 */
unt	   CDataTag::GetLength() const 
{
	return (unt)m_DataList.size(); 
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃^OɃZbgĂlo
/*!	͈͊O擾悤Ƃassert
 *
 *	\param  Index		[i ]	擾f[^ԍ
 *
 *	\return w肵vf
 */
const CData& CDataTag::GetData( unt Index )const
{
	MAID_ASSERT( !(Index<m_DataList.size()), "͈͊O̎w" );
	return m_DataList[Index];
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃^OɃZbgĂ镶o
/*!	w肵ʒu͈͊Oł Default Ԃ
 *
 *	\param  Index		[i ]	擾f[^ԍ
 *	\param  Default		[i ]	Gɖ߂iftHg"")
 *
 *	\return ֐̐ w肵
 *			֐̎s Default
 */
mstring CDataTag::GetStr( unt Index, const mstring& Default ) const
{
	if( !(Index<m_DataList.size()) ) { return Default; }

	const CData& data = m_DataList[Index];

	if( data.GetType()!=CData::TYPE_STRING ) { return Default; }

	return data.GetString();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃^OɃZbgĂlo
/*!	w肵ʒulłȂ Default Ԃ
 *
 *	\param  Index		[i ]	擾f[^ԍ
 *	\param  Default		[i ]	Gɖ߂iftHgłOj
 *
 *	\return ֐̐ w肵l
 *			֐̎s Default
 */
int    CDataTag::GetNum( unt Index, int Default ) const
{
	if( !(Index<m_DataList.size()) ) { return Default; }

	const CData& data = m_DataList[Index];

	if( data.GetType()!=CData::TYPE_INTEGER ) { return Default; }

	return data.GetInteger();
}







/*!
    \class CDataFileParser CDataFileParser.h
    \brief ̏ŏꂽt@C̓ǂݍ݂sNX
*/

inline bool IsSpace( const wchar_t str )
{
	return str==' ' || str=='\t' || str==','|| str=='\r'|| str=='\n';
}

inline mstring ReadTorken( const mstring& vec, unt& pos )
{
	while( true )
	{
		if( !(pos<vec.length()) ) { return mstring(); }
		const unt32 c = vec[pos];
		if( !IsSpace(c) ) { break; }
		++pos;
	}

	mstring str;
	const unt32 c = vec[pos];

	if( c=='\"' )
	{	//	擪 " ̏ꍇAƂ݂Ȃēǂݍ
		str += c;
		pos++;
		while( true )
		{
			if( !(pos<vec.length()) ) { return str; }
			const unt32 k = vec[pos];
			str += k;
			pos++;

			if( k=='\"' ) { break; }
		}
	}else
	{
		while( true )
		{
			if( !(pos<vec.length()) ) { return str; }
			const unt32 k = vec[pos];

			if( IsSpace(k) ) { break; }
			else
			{
				str += k;
				pos += 1;
				if( k==';') { break; }
			}
		}
	}
	return str;
}


/*!
 *	\class	DATAFILEINFO DenDataFileParser.h
 *	\brief	k` f[^t@CɓĂwb_
\n			kt@C̏ꍇ͐擪ɂ܂B
 */

struct DATAFILEINFO
{
	unt	FileType[2];	//!<	'DFPFile' + '\\0'
	unt	DecodeSize;		//WJ̃TCY(̍\̂͊܂݂܂ f[^݂̈̂łj
	unt	Flag;			//etO
	unt08	tmp[128-16];	//\obt@
};

static const unt DFPFileTYPE_0 = Str2Binary32('D','F','P','F');
static const unt DFPFileTYPE_1 = Str2Binary32('i','l','e','\0');


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CDataFileParser::CDataFileParser()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
CDataFileParser::~CDataFileParser()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! \[Xt@C̓ǂݍ݁A
/*!
 *	\param  FileName		[i ]	͂\[Xt@C
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
void CDataFileParser::Load( const mstring& FileName )
{
	MySTL::vector<unt08>	FileData;
	CFileRead::Read( FileName, FileData );

	return Load( FileData );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ォǂݍ
/*!
 *	\param  FileData		[i ]	͂z
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
void CDataFileParser::Load( const MySTL::vector<unt08>& FileData )
{
	mstring ParseText;

	if( IsCompressData(FileData) )
	{
		//	k`AWJĂs
		DATAFILEINFO* pInfo = (DATAFILEINFO*)&(FileData[0]);

		MySTL::vector<unt08> DecodeData( pInfo->DecodeSize );
		CCompressZlib cmp;

		const unt DecSize = cmp.Decode( &(FileData[sizeof(DATAFILEINFO)]), (unt)FileData.size()-sizeof(DATAFILEINFO), &(DecodeData[0]), (unt)DecodeData.size() );

		if( DecSize!=pInfo->DecodeSize )	{ MAID_ASSERT( true, MAIDTEXT("WJ̃TCY܂ ") << DecSize << MAIDTEXT(" ") << pInfo->DecodeSize ); }

		DecodeData.push_back( '\0' );
		ParseText = CString::ConvertSJIStoMAID((char*)(&DecodeData[0]));

	}else
	{
		MySTL::vector<unt08> v = FileData;
		v.push_back( '\0' );
		ParseText = CString::ConvertSJIStoMAID((char*)(&v[0]));
	}


	Parse( ParseText );
}

bool CDataFileParser::IsCompressData( const MySTL::vector<unt08>& Data )
{
	if( Data.size()>sizeof(DATAFILEINFO) )
	{
		DATAFILEINFO* pInfo = (DATAFILEINFO*)&(Data[0]);

		if( pInfo->FileType[0]==DFPFileTYPE_0 && pInfo->FileType[1]==DFPFileTYPE_1 )
		{
			return true;
		}
	}

	return false;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! f[^̉
/*!
 *	\param  Data		[i ]	͂z(WJĂ邱Ɓj
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
void CDataFileParser::Parse( const mstring& Data )
{
	Clear();
	unt	pos=0;

	//	es'#'Ŏn܂
	//	sARAXy[XA^ułPg[N
	//	; ̏ꍇRg
	
	SPDATATAG pDataTag;
	while( true )
	{
		if( !(pos<Data.length()) ) { break; }

		const mstring str = ReadTorken( Data, pos );

		if( str.empty() ) { break; }

		if( str[0]==';' )
		{
			//	Rg̓XLbv
			while( true )
			{
				if( !(pos<Data.length()) ) { break; }

				const unt c = Data[pos];
				pos++;
				if( c=='\n' ) { break; }
			}
		}
		ef( str[0]=='#' )
		{
			pDataTag.reset( new CDataTag );

			const mstring s = str.substr(1);

			pDataTag->SetTagName(s);
			m_ParseData.push_back( pDataTag );
		}
		else
		{
			if( !pDataTag ) { break; }

			CData Data;
			Data.Reset(str);
			pDataTag->AddData(Data);
		}
	}

	m_NowLine = m_ParseData.begin();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̏Ԃt@Cɕۑ
/*!
 *	\param  FileName		[i ]	ۑt@C
 *	\param  IsCmpress		[i ]	kt@CƂĕۑ邩HiftHgfalse)
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
void CDataFileParser::Save( const mstring& FileName, bool IsCmpress )
{
	MySTL::vector<unt08> Data;
	Save( Data, IsCmpress );

	if( Data.empty() ) 
	{
		CFileWrite::Create( FileName );
		return ; 
	}

	CFileWrite::Write( FileName, &(Data[0]), (int)Data.size() );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̏Ԃɕۑ
/*!
 *	\param  Data		[ o]	ۑz(ŏ clear() ܂j
 *	\param  IsCmpress	[i ]	kt@CƂĕۑ邩HiftHgfalse)
 *
 *	\return ֐̐łO
 *			֐̎słOȊO
 */
void CDataFileParser::Save( MySTL::vector<unt08>& Data, bool IsCmpress )
{
	MySTL::string str;

	{
		mstring wstr;
		for( TAGLIST::iterator ite=m_ParseData.begin(); ite!=m_ParseData.end(); ++ite )
		{
			const SPDATATAG& pTag = (*ite);

			wstr += MAIDTEXT("#") + pTag->m_TagName + MAIDTEXT(" ");

			for( unt i=0; i<pTag->GetLength(); ++i )
			{
				wstr += pTag->GetData(i).GetFileTypeData();

				if( i!=pTag->GetLength()-1 ) { wstr += MAIDTEXT(","); }
			}

			wstr += '\n';
		}

		str = CString::ConvertMAIDtoSJIS(wstr);
	}

	if( str.empty() ) { return; }

	if( IsCmpress )
	{
		const unt InfoSize = sizeof(DATAFILEINFO);
		const unt DataSize = (unt)str.length();

		CCompressZlib cmp;
		Data.resize( InfoSize+DataSize );	// kꍇ̓wb_Ă

		unt EncSize=0;

		if( DataSize!=0 )
		{
			EncSize = cmp.Encode( str.c_str(), DataSize, &(Data[InfoSize]), DataSize );
			if( EncSize>=DataSize ) 
			{
				//	kłȂAʂɃZ[u
				Data.resize( str.length() );
				::memcpy( &(Data[0]), str.c_str(), str.length() );
				return;
			}
		}

		// kɐf[^̃Zbg
		Data.resize( InfoSize+EncSize );
		ZERO( &(Data[0]), InfoSize );
		{
			DATAFILEINFO* pInfo = (DATAFILEINFO*)&(Data[0]);
			pInfo->FileType[0] =  DFPFileTYPE_0;
			pInfo->FileType[1] =  DFPFileTYPE_1;
			pInfo->DecodeSize =  DataSize;
			pInfo->Flag =  0;
		}
	}else
	{
		Data.resize( str.length() );
		::memcpy( &(Data[0]), str.c_str(), str.length() );
	}
//	MAID_TRACE( MAIDTEXT("CDataFileParser::Save3"));

}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂ݂񂾃^Of[^擾
/*!	t@C̓ǂݍ݂Ɠ悤ɂ̊֐Ăяo\n
 *	^OIɂPi
 *
 *	\return ^ȌI[NULL
 *			̃^Õ|C^
 */
SPDATATAG	CDataFileParser::NextTag()
{
//	MAID_ASSERT( m_ParseData.empty(), MAIDTEXT("܂ǂݍł܂") );
	if( m_NowLine==m_ParseData.end() )
	{
		return SPDATATAG(); 
	}

	SPDATATAG pTag = *m_NowLine;
	++m_NowLine;

	return pTag;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ŏw肵^Õ^O擾
/*!	݂̃^Oʒuԋ߂̂擾ł܂
 *
 *	\return ȂNULL
\n			̃^Õ|C^
 */
SPDATATAG	CDataFileParser::NextTag( const mstring& strTagName )
{
//	MAID_ASSERT( m_ParseData.empty(), MAIDTEXT("܂ǂݍł܂") );

	const mstring str = CString::ToLower(strTagName);
	for( TAGLIST::iterator ite=m_NowLine; ite!=m_ParseData.end(); ++ite )
	{
		if( (*ite)->GetTagName()==str )
		{
			m_NowLine = ite;
			++m_NowLine;
			return (*ite);
		}
	}

	return SPDATATAG(); 
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵^O
/*!	
 *	ԍŏɌ^OԂ܂\n
 *
 *	\return ȂNULL
 *			炻̃|C^
 */
SPDATATAG	CDataFileParser::SerchTag( const mstring& FileName ) const
{
//	MAID_ASSERT( m_ParseData.empty(), MAIDTEXT("܂ǂݍł܂") );
	const mstring str = CString::ToLower(FileName);

	for( TAGLIST::const_iterator ite=m_NowLine; ite!=m_ParseData.end(); ++ite )
	{
		if( (*ite)->GetTagName()==str )	{ return (*ite); }
	}
	for( TAGLIST::const_iterator ite=m_ParseData.begin(); ite!=m_NowLine; ++ite )
	{
		if( (*ite)->GetTagName()==str ) { return (*ite); }
	}
	return SPDATATAG();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ^Ȏ}
/*!	
 *	ԍŌɒǉ܂
 *
 *	\param	pTag	[i ]	V}^O
 */
void CDataFileParser::InsertTag( const SPDATATAG& pTag )
{
	MAID_ASSERT( pTag.get()==NULL, MAIDTEXT("NULLł") );
	MAID_ASSERT( pTag->GetTagName().empty(), MAIDTEXT("^Osł") );

	m_ParseData.push_back( pTag );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! õZbg
/*!	
 *
 */
void CDataFileParser::Clear()
{
	m_ParseData.clear();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ^Öʒuӂ肾ɂǂ
/*!	
 */
void CDataFileParser::Reset()
{
	m_NowLine = m_ParseData.begin();
}


}