#include"CException.h"
#include"../CString.h"


namespace Maid
{
	/*!
	 	@class	CException CException.h
	 	@brief	ONX
	 */
	CException::CException( const mstring& t )
		: Text(t), FileName(mstring()), Line(0)
	{
	}

	CException::CException( const mstring& t, const char* szFile, int Line ) 
		: Text(t), FileName(CString::ConvertSJIStoMAID(szFile)), Line(Line)
	{
	}

	void CException::WriteLog()
	{
		MySTL::string t = CString::ConvertMAIDtoSJIS(Text);
		MySTL::string f = CString::ConvertMAIDtoSJIS(FileName);

		FILE* hFile = ::fopen( "warning.txt", "a" );
		::fprintf( hFile, "O: %s %ds %s\n",t.c_str(), Line, f.c_str() );
		::fclose( hFile );
	}




}