#include"CFileWrite.h"
#include"../CString.h"
#include"../Debug/CWarning.h"
#include"../Debug/CAssert.h"

#include<string>

namespace Maid
{
/*!
 	@class	CFileWrite CFileWrite.h
 	@brief	t@Cɂď݂݂̂̃NX
\n			̂ƂP̃t@Cɏނł
\n			̂g\
 */ 
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CFileWrite::CFileWrite() : m_Handle(NULL)
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CFileWrite::~CFileWrite()
{
	Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ރt@CJ
/*!
 	@param	FileName	[i ]	Jt@C
 	@param	eOption		[i ]	J[h
 */
void CFileWrite::Open( const mstring& FileName, CFileWrite::OPENOPTION eOption )
{
	Close();

	MySTL::string OpenMode;

	switch( eOption )
	{
	case OPENOPTION_NEW:	{ OpenMode = "wb"; }break;
	case OPENOPTION_ADD:	{ OpenMode = "ab";  }break;
	}

	MySTL::string str = CString::ConvertMAIDtoSJIS(FileName);

	m_Handle = ::fopen( str.c_str(), OpenMode.c_str() );

	if( m_Handle==NULL )
	{
		MAID_WARNING( "t@C̃I[vɎs" << str );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݃J[\̈ړ
/*!
 *	t@C͈͂𒴂w肪ꍇ@͈͓ɂȂ悤ɃNbv
 *	\param	Size	[i ]	ړʁioCgPʁj
 *	\param	ePos	[i ]	_
 *
 *	\return	֐̐ DENRESULT_OK
 *			֐̎s 0ȊO
 */
void	CFileWrite::Seek( int Size, POSITION ePos )
{
	MAID_ASSERT( m_Handle==NULL, "t@CJĂ܂" );
	if( m_Handle==NULL ) { return ; }

	long Origin;
	switch( ePos )
	{
	case POSITION_BEGIN:		{ Origin = SEEK_SET; }break;
	case POSITION_END:		{ Origin = SEEK_END; }break;
	case POSITION_CURRENT:	{ Origin = SEEK_CUR; }break;
	}
	
	::fseek( m_Handle, Size, Origin );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@Cɏ
/*!
 *	\param	pData		[i ]	݂f[^̐擪AhX
 *	\param	DataSize	[i ]	ރTCYioCgPʁj
 *
 *	\return	ۂɏ񂾃oCg
 */
int CFileWrite::Write( const void* pData, int DataSize )
{
	if( DataSize==0 ) { return 0; }

	MAID_ASSERT( m_Handle==NULL, "t@CJĂ܂" );
	if( m_Handle==NULL ) { return 0; }

	const int count = (int)::fwrite( pData, DataSize, 1, m_Handle );

	if( count!=1 )
	{
		MAID_WARNING( "񂾍ڐႢ܂ ߂l " << count );
	}

	return DataSize;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JĂt@C
/*!
 */
void CFileWrite::Close()
{
	if( m_Handle==NULL ) { return ; }

	::fclose( m_Handle );
	m_Handle = NULL;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FileName Ɉꊇ݂
/*!
 	 Open, Write Ə̂߂ǂ̂ŗpӂ܂
 
 	@param	FileName	[i ]	݂t@Ciłɑ݂ĂƂ͔j󂳂܂
 	@param	pData		[i ]	݂f[^̐擪AhX
 	@param	Size		[i ]	ރTCYioCgPʁj
 
 	@return	񂾃t@CTCY
 
 	@code
 	MySTL::vector<STRUCT>	Data;
 	CFileWrite::Write( MAIDTEXT("hoge.dat"), &Data[0], Data.size()*sizeof(STRUCT) );	//	œǂݍ݂̏I
 	@endcode
 */
int CFileWrite::Write( const mstring& FileName, const void* pData, int Size )
{
	CFileWrite	hFile;

	hFile.Open( FileName, OPENOPTION_NEW );
	const int size = hFile.Write( pData, Size );

	if( size!=Size ) { return 0; }

	return size;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! FileName 0bytẽt@C쐬
/*!
 	@param	FileName	[i ]	݂t@Ciłɑ݂ĂƂ͔j󂳂܂
 
 */
void	CFileWrite::Create( const mstring& FileName )
{
	CFileWrite	hFile;

	hFile.Open( FileName, OPENOPTION_NEW );
}

}
