
#include"CPackFileManager.h"
#include"../CString.h"
#include<stdio.h>

#include"CFileReadNormal.h"
#include"CFileReadFileRange.h"
#include"CFileReadMemory.h"
#include"CFileWrite.h"
#include"CFileRead.h"

#include"../Debug/CWarning.h"
#include"../Debug/CTrace.h"
#include"../CRand.h"
#include"../CString.h"

#include"../Compress/CCompressZlib.h"
#include"../Windows/CShell.h"

namespace Maid
{
	using namespace CString;

	enum COMPRESSTYPE
	{
		COMPRESSTYPE_NONE=0,	//!<	k
		COMPRESSTYPE_ZLIB,		//!<	ZLib ł̈k
	};

	/*!
	 *	\class	PACKHEAD CPackFileManager.h
	 *	\brief	pbNt@C̃wb_
	\n			t@C̐擪ɗ
	 *
	 */
	struct PACKHEAD
	{
		unt32	FileCode;	//!<	'DAF2'
		enum VERSION
		{
			VERSION_0x0100=0x0100,
		};

		VERSION	Version;		//!<	t@Co[W
		unt32	FileCount;		//!<	Sŉt@Ci[Ă邩H
		unt32	HashTable;		//!<	ɎgnbVe[u̒

		unt32	InfoSizeComp;	//!<	A[JCu񂪓Ăf[^̒ik̃TCYj
		unt32	InfoSize;		//!<	A[JCu񂪓Ăf[^̒iWJ̃TCYj

		COMPRESSTYPE CompressType;		//!<	k`
		unt32	ArchiveOffset;	//!<	A[JCuf[^t@C̐擪̃ItZbg
		unt32	KeyCode[4];		//!<	A[JCu𕜍Ƃ̃L[
	};

	static const unt32 PACKHEAD_CODE = Str2Binary32( 'D', 'A', 'F', '2' );

	/*!
	 *	\class	FILEINFO DenPackFileManager.h
	 *	\brief	pbNt@Cɂet@C̏wb_
	\n			PACKHEAD ̌ PACKHEAD::FileCount Aĕł
	\n			̍\̂̊eAhX͂S̔{ɂȂ悤ɂ܂߂܂
	 *
	 */
	struct FILEINFO
	{
		unt32 StructSize;		//!<	̍\̂̑傫ioCgPʁj
		unt32 Position;		//!<	wt@C̈ʒuiA[JCuf[^̐擪̃ItZbgj
		unt32 CompressSize;	//!<	A[JCũt@CTCY
		unt32 FileSize;		//!<	ۂ̃t@CTCY

		COMPRESSTYPE CompressType;		//!<	k`
		char FileName[1];		//!<	̃t@C( StructSize - sizeof(FILEINFO) jׂďɂȂĂ܂
	};

	//! nbVe[uɍœKȐ߂
	/*!
	 *	MinValue	傫fԂ܂
	 *
	 *	\param  MinValue		[i ]	ŒKvȒl
	 *
	 *	\return MinValue	ȏ̑f
	 *			ȂEEEEmȂiOOG
	 */
	inline unt32	GetHashTableNum( unt32 MinValue )
	{
		MySTL::vector<unt32>	ValueList;	//	܂Ōoꂽf
		unt32 CmpValue;

		ValueList.push_back(2);
		CmpValue = 1;

		while( true )
		{
			CmpValue += 2;	//	ɑf͂Ȃ̂łQ₷
			unt32 j =  0;

			while( true )
			{
				if( j==ValueList.size() )
				{	//	Ō܂ŌČȂfł
					if( MinValue < CmpValue ) { return CmpValue; }
					ValueList.push_back(CmpValue);
					break;
				}

				//	r̒lŊ؂ꂽfł͂Ȃ
				if( (CmpValue%ValueList[j])==0 ) { break; }
				++j;
			}
		}

		return CmpValue;
	}


static const unt32 COPY_PACET = 1024*256;	//	̃Rs[Ŏst@CTCY
static const unt32 MD5CHECKSIZE = 1024*256;	//	̃Rs[Ŏst@CTCY
static unt08 COPYBUF[COPY_PACET];				//	MD5 ̃`FbNɂg




/*!
 *	\class	CPackFile DenPackFileManager2.h
 *	\brief	pbNt@CǗNX
 *
 */	
class CPackFile
{
public:
	void	Load( const mstring& FileName );
	void	Clear();
	boost::shared_ptr<IFileRead>	FindFile( const mstring& FileName );

	bool	IsExist( const mstring& FileName );

	mstring GetFileName() const { return m_FileName; }

private:
	PACKHEAD	m_PackHead;	//	t@Cwb_

	mstring		m_FileName;	//!<	ǂݍ񂾃t@C

	unt32		m_ArchiveKey;	//!<	A[JCu𕜍Ƃ̃L[R[h

	struct _FILEINFO
	{
		unt32 StructSize;			//!<	̍\̂̑傫ioCgPʁj
		unt32 Position;				//!<	wt@C̈ʒuiA[JCuf[^̐擪̃ItZbgj
		unt32 CompressSize;			//!<	A[JCũt@CTCY
		unt32 FileSize;				//!<	ۂ̃t@CTCY

		COMPRESSTYPE CompressType;	//!<	k`
		mstring FileName;			//!<	̃t@C
	};

	typedef MySTL::multimap<mstring, _FILEINFO>	FILEMAP;
	typedef MySTL::pair<mstring, _FILEINFO>		FILEMAPPAIR;

	FILEMAP	m_InfoTable;	//!<	m_FileInfo QƂĂe[u

};


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! pbNt@Cǂݍ
/*!
 *	\param	FileName	[i ]	ǂݍރpbNt@C
 *
 *	\return		֐̐ void_OK
\n				s void_OK ȊO
 */
void CPackFile::Load( const mstring& FileName )
{
	Clear();

	{	//	܂̓wb_̓ǂݍ
		CFileReadNormal	hFile;
		hFile.Open(FileName);
		hFile.Read( &m_PackHead, sizeof(m_PackHead) );

		m_ArchiveKey = 0;
		m_ArchiveKey |= (((m_PackHead.KeyCode[0]>> 0)&0xFF)<<24);
		m_ArchiveKey |= (((m_PackHead.KeyCode[1]>> 8)&0xFF)<<16);
		m_ArchiveKey |= (((m_PackHead.KeyCode[2]>>16)&0xFF)<< 8);
		m_ArchiveKey |= (((m_PackHead.KeyCode[3]>>24)&0xFF)<< 0);

		m_PackHead.FileCount     ^= m_ArchiveKey;
		m_PackHead.HashTable     ^= m_ArchiveKey;
		m_PackHead.InfoSizeComp  ^= m_ArchiveKey;
		m_PackHead.InfoSize      ^= m_ArchiveKey;
		m_PackHead.ArchiveOffset ^= m_ArchiveKey;
	}

	{
		if( m_PackHead.FileCode!=PACKHEAD_CODE ) { return; }

		switch( m_PackHead.Version )
		{
		case PACKHEAD::VERSION_0x0100:{}break;
		default:
			{
				MAID_ASSERT( true, MAIDTEXT("o[Wł ") << m_PackHead.Version );
			}break;
		}
	}

	MySTL::vector<unt08>	InfoImage;
	{
		//	pbNĂt@Cǂݎ

		MySTL::vector<unt08>	tmp(m_PackHead.InfoSizeComp);
		InfoImage.resize( m_PackHead.InfoSize );

		CFileReadNormal	hFile;
		hFile.Open(FileName);
		hFile.Seek( sizeof(m_PackHead), IFileRead::POSITION_BEGIN );
		hFile.Read( &(tmp[0]), (int)tmp.size() );

		if( m_PackHead.CompressType==COMPRESSTYPE_ZLIB )
		{
			CCompressZlib cmp;
			cmp.Decode( &(tmp[0]), (unt32)tmp.size(), &(InfoImage[0]), (unt32)InfoImage.size() );
		}else
		{
			InfoImage = tmp;
		}
	}

	{	//	ǂݍ񂾃f[^oɐU蕪
		FILEINFO* pInfo = (FILEINFO*)&InfoImage[0];

		for( unt32 i=0; i<m_PackHead.FileCount; ++i )
		{
			_FILEINFO dat;

			dat.StructSize   = pInfo->StructSize   ^ m_ArchiveKey;
			dat.Position     = pInfo->Position	 ^ m_ArchiveKey;
			dat.CompressSize = pInfo->CompressSize ^ m_ArchiveKey;
			dat.FileSize     = pInfo->FileSize	 ^ m_ArchiveKey;
			dat.CompressType = pInfo->CompressType;
			dat.FileName     = CString::ConvertSJIStoMAID(pInfo->FileName);

//			MAID_TRACE( dat.FileName );
			m_InfoTable.insert(FILEMAPPAIR(dat.FileName,dat));
			pInfo = (FILEINFO*)((unt08*)pInfo+ dat.StructSize);
		}
	}

	m_FileName = FileName;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! õNA
/*!
 */
void	CPackFile::Clear()
{
	m_InfoTable.clear();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍłpbNt@C̒Ƀf[^邩ׂ
/*!
 *	\param	FileName	[i ]	Tof[^
 *
 *	\return		t@C true
\n				s false
 */
bool	CPackFile::IsExist( const mstring& FileName )
{
	const FILEINFO* pInfo = NULL;

	{
		MySTL::pair< FILEMAP::iterator, FILEMAP::iterator > HashRange = m_InfoTable.equal_range( FileName );

		for( FILEMAP::iterator ite=HashRange.first; ite!=HashRange.second; ++ite )
		{
			const _FILEINFO& p = (*ite).second;
			if( p.FileName==FileName ) { return true; }
		}
	}

	return false;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍłpbNt@Cf[^擾
/*!
 	\param	FileName	[i ]	Tof[^
 	\param	pFile		[ o]	f[^
 */
boost::shared_ptr<IFileRead> CPackFile::FindFile( const mstring& FileName )
{
	_FILEINFO pInfo;

	{
		MySTL::pair< FILEMAP::iterator, FILEMAP::iterator > HashRange = m_InfoTable.equal_range( FileName );

		for( FILEMAP::iterator ite=HashRange.first; ite!=HashRange.second; ++ite )
		{
			const _FILEINFO& p = (*ite).second;
			if( p.FileName==FileName )
			{
				pInfo = p;
				break;
			}
		}

		if( pInfo.FileName.empty() )
		{
			MAID_THROWEXCEPTION(MAIDTEXT("Xgɑ݂܂") );
		}
	}





	//	f[^̂ňɓnďI

	boost::shared_ptr<IFileRead> pRet;

	switch( pInfo.CompressType )
	{
	case COMPRESSTYPE_NONE:
		{
			//	k̏ꍇ̓t@Cǂݍނ悤ɂ

			CFileReadFileRange* p = new CFileReadFileRange;

			p->Open( m_FileName, m_PackHead.ArchiveOffset+pInfo.Position, pInfo.FileSize );

			pRet.reset( p );

		}break;

	case COMPRESSTYPE_ZLIB:
		{
			//	kĂꍇ͓WJďI

			boost::shared_array<unt08>	pDst( new unt08[pInfo.FileSize] );
			MySTL::vector<unt08>		Src ( pInfo.CompressSize );

			CFileReadNormal hFile;

			hFile.Open( m_FileName );
			hFile.Seek( m_PackHead.ArchiveOffset+pInfo.Position, IFileRead::POSITION_BEGIN );
			hFile.Read( &(Src[0]), (int32)Src.size() );

			{
				CCompressZlib	cmp;
				const unt32	DecSize = cmp.Decode( &(Src[0]), (int32)Src.size(), pDst.get(), pInfo.FileSize );

				MAID_ASSERT( pInfo.FileSize!=DecSize, MAIDTEXT("WJTCYႢ܂ ") << pInfo.FileSize << MAIDTEXT(" ") << DecSize );

				CFileReadMemory* p = new CFileReadMemory;
				p->Open( pDst, pInfo.FileSize );
				pRet.reset( p );
			}
		}break;

	default:
		{
			MAID_ASSERT( true, "k`sł" );
		}break;
	}

	return pRet;
}


/*!
 *	\class	CPackFileManager DenPackFileManager2.h
 *	\brief	CPackFileǗNX
 *
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CPackFileManager::CPackFileManager()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! pbNt@C̓o^
/*!
 *	\param	PackFileName	[i ]	o^pbNt@C
 *
 *	\return		t@CĴɐ void_OK
\n				s void_OK ȊO
 */
void CPackFileManager::Mount( const mstring& PackFileName,  const mstring& MountDirectory )
{
	if( !CFileRead::IsExist(PackFileName) )
	{
		MAID_WARNING( PackFileName + MAIDTEXT("݂Ă܂") );
		return ;
	}

	SPPACKFILE pPackFile( new CPackFile );

	pPackFile->Load(PackFileName);

	mstring dir;

	if( MountDirectory.empty() )
	{
		const mstring KeyName = PackFileName.substr(0,PackFileName.length()-(GetExtension(PackFileName).length()+1) );
		dir = CreateMountDirectory(ToLower(KeyName));
	}else
	{
		dir = CreateMountDirectory(ToLower(MountDirectory));
	}

	m_PackFileList[dir].push_back(pPackFile);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! pbNt@C̓o^
/*!
 	\param	PackFileName	[i ]	o^pbNt@C
 */
void CPackFileManager::UnMount( const mstring& PackFileName )
{
	const mstring dir = CreateMountDirectory(ToLower(PackFileName));

	MOUNTLIST::iterator ite = m_PackFileList.find(dir);

	if( ite==m_PackFileList.end() ) { return; }

	{
		PACKLIST& vec = ite->second;

		for( PACKLIST::iterator i=vec.begin(); i!=vec.end(); ++i )
		{
			if( (*i)->GetFileName()==PackFileName )
			{
				vec.erase(i);
				break;
			}
		}
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍłpbNt@C̒Ƀf[^邩ׂ
/*!
 *	\param	FileName	[i ]	Tof[^
 *
 *	\return		t@C true
\n				s false
 */
bool CPackFileManager::IsExist( const mstring& FileName )
{
	//	CPackFileManager::FindFile@̃RsyB炻ςĂ

	//	KwpbNt@C̓ǂݍ
	//	FileName  \\data\hoge\default.txt Ǝw肳ꂽꍇ
	//	PF \\data\hoge pbNt@C default.txt T
	//	QF  \\data pbNt@C hoge\default.txt T

	const mstring name = CreateMountDirectory(ToLower(FileName));

	mstring Dir  = GetDirectory(name);
	mstring File = GetFileName(name);

	while( true )
	{
		if( Dir.empty() ) { break; }	//	tH_Ȃ猟Is

		MOUNTLIST::iterator ite = m_PackFileList.find(Dir);

		if( ite!=m_PackFileList.end() )
		{
			PACKLIST& dat = ite->second;

			for( PACKLIST::reverse_iterator ite=dat.rbegin(); ite!=dat.rend(); ++ite )
			{
				if( (*ite)->IsExist(File) ) 
				{	//	I
					return true; 
				}
			}
		}

		//	ǌȂAtH_炵Ď
		const mstring newDir = GetDirectory(Dir);

		File = Dir.substr(newDir.length()+1) + MAIDTEXT("\\") + File;
		Dir  = newDir;
	}

	return false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! o^ĂpbNt@C̒t@CTo
/*!
 	@param	FileName	[i ]	Tt@C
 	@param	pFile		[ o]	t@C
 */
boost::shared_ptr<IFileRead> CPackFileManager::FindFile( const mstring& FileName )
{
	//	KwpbNt@C̓ǂݍ
	//	FileName  \\data\hoge\default.txt Ǝw肳ꂽꍇ
	//	PF \\data\hoge pbNt@C default.txt T
	//	QF  \\data pbNt@C hoge\default.txt T

	const mstring name = CreateMountDirectory(ToLower(FileName));

	mstring Dir  = GetDirectory(name);
	mstring File = GetFileName(name);

	while( true )
	{
		if( Dir.empty() ) { break; }	//	tH_Ȃ猟s

		MOUNTLIST::iterator ite = m_PackFileList.find(Dir);

		if( ite!=m_PackFileList.end() )
		{
			PACKLIST& dat = ite->second;

			for( PACKLIST::reverse_iterator ite=dat.rbegin(); ite!=dat.rend(); ++ite )
			{
				boost::shared_ptr<IFileRead> pFile = (*ite)->FindFile(File);

				if( pFile.get()!=NULL ) { return pFile; }
			}
		}

		//	ǌȂAtH_炵Ď
		const mstring newDir = GetDirectory(Dir);

		File = Dir.substr(newDir.length()+1) + MAIDTEXT("\\") + File;
		Dir  = newDir;
	}

	MAID_THROWEXCEPTION(MAIDTEXT("A[JCu܂"));

	return boost::shared_ptr<IFileRead>();
}


mstring CPackFileManager::CreateMountDirectory( const mstring& name )
{
	//	t@C '/'  '\' ɕϊ
	mstring dir = name;

	{
		//	Pڂ͕K'\'ɂĂ
		if( dir.empty() ) { dir = MAIDTEXT("\\"); }
		else
		{
			dir.insert(0,MAIDTEXT("\\"));
		}
	}

	for( unt32 i=0; i<dir.length(); ++i )
	{
		unt32 c = dir[i];
		if( c=='/' ) { dir[i] = '\\'; }
	}

	return dir;
}




/*!
 *	\class	CPackFileCreater DenPackFileManager2.h
 *	\brief	pbNt@C쐬NX
 *
 */

	struct TEMPORARYFILEINFO
	{
		mstring	SourcePath;		//	ϊÕt@CpX
		mstring	TemporaryPath;	//	e|ɓĂƂ̃t@C
		unt32			SourceFileSize;	//	kÕt@CTCY
		unt32			DestFileSize;	//	k̃t@CTCY
		COMPRESSTYPE	CompressType;	//	k@
	};



static const char TEMPORARY_DIRECTORY[] = "tmp";	//	t@CA[JCuƂɈꎞt@CɂĂtH_





//	e|ɍ쐬t@C '\' ':' Ă̂łϊ
mstring ConvertTmporaryDirectoryName( const mstring& DirectoryName )
{
	mstring ret;

	for( int i=0; i<(int)DirectoryName.length(); ++i )
	{
		const unt32 c = DirectoryName[i];
		switch( c )
		{
		case '\\':
		case ':': { ret += '.';	}break;
		default:  { ret += c;	}break;
		}
	}

	return ret;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! kȂt@C̐ݒ
/*!
 *	\param	List	[i ]	kȂt@Cʂgq(啶E͋ʂ܂j
 */
void CPackFileCreater::SetNoCompressList( const MySTL::vector<mstring>& List )
{
	//	gqŋʂȂŁAK\ŋʂׂEEE߂ǂ(GLDM)

	m_NoCompressList.clear();

	for( unt32 i=0; i<List.size(); ++i )
	{
		m_NoCompressList.insert( ToLower(List[i]) );
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! pbNt@C쐬̊Jn
/*!
 *	̊֐ GetStatus() ŏԂ 
\n	STATE_SUCCESS	ƐI
\n	STATE_ERROR		ƎsďI
 *
 *	\param	DirectoryName	[i ]	pbNt@ĈfBNg
 *	\param	OutputName		[i ]	o͐t@C
 *
 *	\return 쐬Jn void_OK
\n			Ȃ void_OK ȊO
 */
void CPackFileCreater::BeginArchive( const mstring& DirectoryName, const mstring& OutputName )
{
	m_Status.State = STATUS::STATE_OK;
	m_Status.Progress = 0;
	m_Status.Text.clear();

	m_DirectoryName = DirectoryName;
	m_OutputName    = OutputName;

	m_Thread.SetFunc( MakeThreadObject( &CPackFileCreater::PackThread, this) );
	m_Thread.Execute();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̏Ԃ擾
/*!
 *	\return ݂̏
 */
CPackFileCreater::STATUS CPackFileCreater::GetStatus()
{
	STATUS s;
	{
		CThreadMutexLocker Lock(m_Section);
		s = m_Status;
	}

	return s;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! s̃pbNI
/*!
 *	R̂ƂȂ BeginArchive() Ă񂾌ɂӖ܂
 */
void   CPackFileCreater::OnCancel()
{
	m_Thread.Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Zlibgks
/*!
 *	kɎsĂAʂ̃t@C쐬܂
 *	\param	src	[i ]	f[^̃t@CpX
 *	\param	dst	[i ]	쐬̃t@CpX
 */
void CPackFileCreater::CreateZlibCompressFile( const mstring& src, const mstring& dst )
{
	MySTL::vector<unt08>	tmp;
	CFileRead::Read( src, tmp );

	if( tmp.empty() ) { CFileWrite::Create( dst ); return ; }

	MySTL::vector<unt08>	ArcData;
	ArcData.resize( tmp.size() );

	unt32 EncSize;
	CCompressZlib cmp;
	EncSize = cmp.Encode( &(tmp[0]), (unt32)tmp.size(), &(ArcData[0]), (unt32)ArcData.size() );
	if( EncSize < tmp.size() )
	{
		ArcData.resize( EncSize );

		AddAlignmentByte( ArcData, 16 );
		CFileWrite::Write( dst, &(ArcData[0]), ArcData.size() );
	}else
	{
		CreateNoCompressFile( src, dst );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C̓]s
/*!
 *	\param	src	[i ]	f[^̃t@CpX
 *	\param	dst	[i ]	쐬̃t@CpX
 */
void CPackFileCreater::CreateNoCompressFile( const mstring& src, const mstring& dst )
{
	MySTL::vector<unt08> dat;

	CFileRead::Read( src, dat );

	if( dat.empty() ) { CFileWrite::Create( dst ); return ; }

	AddAlignmentByte( dat, 16 );
	CFileWrite::Write( dst, &(dat[0]), dat.size() );
}


void CPackFileCreater::AddAlignmentByte( MySTL::vector<unt08>& dat, int size )
{
	const int mod = dat.size() % size;

	if( mod==0 ) { return ; }

	const int alignment = size - mod;

	for( int i=0; i<alignment; ++i )
	{
		dat.push_back( 0xCC );
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ۂɃpbNt@C쐬֐
/*!
 *	̊֐͕ʃXbhœĂ܂
 *
 *	\param	Brige	[i ]	󂯓nf[^
 *
 *	\return ɂO
 */
unt32	CPackFileCreater::PackThread( volatile  CThreadController::BRIGEDATA& Brige )
{
	MySTL::vector<TEMPORARYFILEINFO>	TemporaryInfo;


	{	// t@Č
		{
			CThreadMutexLocker Lock(m_Section);
			m_Status.Text = MAIDTEXT("pbNt@Č");
		}
		FILELIST	PackList;	//	kt@CXgiׂďĂ܂j
		PickupFile( m_DirectoryName, PackList );

		TemporaryInfo.resize(PackList.size());
		for( int i=0; i<(int)PackList.size(); ++i )
		{
			TemporaryInfo[i].SourcePath = PackList[i];
		}
	}

/*	//	eXg[`
	for( FILELIST::iterator ite=PackList.begin(); ite!=PackList.end(); ++ite ) { MAID_TRACE( "%s", ite->c_str() );	}
//*/

	CShell::CreateDirectory( MAIDTEXT(TEMPORARY_DIRECTORY) );

	{
		//	A[JCut@C̍쐬
		//	e|tH_쐬ĂɈUt@C쐬

		const EXTLIST& ExtList = m_NoCompressList;

		for( int i=0; i<(int)TemporaryInfo.size(); ++i ) 
		{
			TEMPORARYFILEINFO& info = TemporaryInfo[i];

			if( Brige.IsExit )
			{
				CThreadMutexLocker Lock(m_Section);
				m_Status.State = STATUS::STATE_CANCEL;
				m_Status.Text  = MAIDTEXT("I܂");
				return 0;
			}


			//	t@CktmptH_ɃRs[
			//	kłȂꍇ͕ʂɃRs[
			const mstring SrcPath= info.SourcePath;
			const mstring TmporaryFileName = ConvertTmporaryDirectoryName(SrcPath);
			const mstring DstPath= MAIDTEXT(TEMPORARY_DIRECTORY)+MAIDTEXT("\\")+TmporaryFileName;
			{
				CThreadMutexLocker Lock(m_Section);
				m_Status.Text  = SrcPath + MAIDTEXT(" ̈k");
				m_Status.Progress = i*50/(int)TemporaryInfo.size();
			}

//			bool	IsCompFail = false;

			// 񈳏kXgɂȂ爳kȂ
			if( ExtList.find( GetExtension(SrcPath) )!=ExtList.end() ) 
			{
				CreateNoCompressFile( SrcPath, DstPath );
				info.CompressType   = COMPRESSTYPE_NONE;
				info.SourceFileSize = CShell::GetFileSize(SrcPath);
				info.DestFileSize   = CShell::GetFileSize(DstPath);
				info.TemporaryPath  = DstPath;
			}
			else
			{
				CreateZlibCompressFile( SrcPath, DstPath );

				const unt SrcSize = CShell::GetFileSize(SrcPath);
				const unt DstSize = CShell::GetFileSize(DstPath);

				if( SrcSize==DstSize )
				{
					info.CompressType   = COMPRESSTYPE_NONE;
					m_NoCompressFileList.push_back(MAIDTEXT("kɎŝňkȂŌł߂܂:") + SrcPath );
				}else
				{
					info.CompressType   = COMPRESSTYPE_ZLIB;
				}
				info.SourceFileSize = SrcSize;
				info.DestFileSize   = DstSize;
				info.TemporaryPath  = DstPath;
			}
		}
	}



	//	ۂɃt@C
	{
		{
			CThreadMutexLocker Lock(m_Section);
			m_Status.Text  = MAIDTEXT(" A[JCuwb_̍쐬");
		//	m_Status.Progress = i*50/TemporaryInfo.size();
		}


		MySTL::vector<unt08>	ArchiveInfo;
		MySTL::vector<unt08>	ArchiveInfoCompress;
		const unt32 HashValue = GetHashTableNum((unt32)TemporaryInfo.size());

		//	ƂÍ̂ŁAp̈ÍL[쐬
		const unt32 AngouKey = Str2Binary32(CRand::Get(0x100),CRand::Get(0x100),CRand::Get(0x100),CRand::Get(0x100));


		{
			//	A[JCu̍쐬
			const unt32 CurrentDirCount = (unt32)m_DirectoryName.length()+1;	// +1  '\\' 
			ArchiveInfo.resize((sizeof(TEMPORARYFILEINFO)+256)*TemporaryInfo.size());	//	kÕf[^łziꂾ΂邱Ƃ͂Ȃ͂j

			ZERO( &ArchiveInfo[0], ArchiveInfo.size() );
			unt32 pos=0;
			unt32 offset=0;

			for( int i=0; i<(int)TemporaryInfo.size(); ++i ) 
			{
				TEMPORARYFILEINFO& src	= TemporaryInfo[i];
				FILEINFO* pDst			= (FILEINFO*)&ArchiveInfo[pos];

				const MySTL::string PackName = ConvertMAIDtoSJIS(src.SourcePath.substr(CurrentDirCount));

				const unt32 StructSize = (sizeof(FILEINFO) + (unt32)PackName.length()+3)&~3;

				pDst->StructSize = StructSize ^ AngouKey;
				pDst->Position   = offset^ AngouKey;
				pDst->CompressSize   = src.DestFileSize ^ AngouKey;
				pDst->FileSize		 = src.SourceFileSize ^ AngouKey;
				pDst->CompressType   = src.CompressType;
				::memcpy( pDst->FileName, PackName.c_str(), PackName.length() );

//				MAID_TRACE(		MAIDTEXT("name:")<<src.SourcePath
//							<<	MAIDTEXT("Position:")<<offset
//							<<	MAIDTEXT("CompressSize:")<<src.DestFileSize
//							<<	MAIDTEXT("FileSize:")<<src.SourceFileSize
//							);

				if( Brige.IsExit )
				{
					CThreadMutexLocker Lock(m_Section);
					m_Status.State = STATUS::STATE_CANCEL;
					m_Status.Text  = MAIDTEXT("I܂");
					return 0;
				}

				pos    += StructSize;
				offset += src.DestFileSize;
			}


			{	//	k

				ArchiveInfoCompress.resize(ArchiveInfo.size());
				CCompressZlib cmp;
				const unt32 EncSize = cmp.Encode( &(ArchiveInfo[0]), (unt32)ArchiveInfo.size(), &(ArchiveInfoCompress[0]), (unt32)ArchiveInfoCompress.size() );

				if( EncSize < ArchiveInfo.size() )
				{
					ArchiveInfoCompress.resize(EncSize);
				}else
				{
					ArchiveInfoCompress = ArchiveInfo;
				}
			}
		}


		//	wb_̍쐬

		PACKHEAD	Head;

		const unt32 ArchiveOffset = (sizeof(PACKHEAD)+(unt32)ArchiveInfoCompress.size()+3)&(~3);
		const unt32 dummybyte = ArchiveOffset - (sizeof(PACKHEAD)+(unt32)ArchiveInfoCompress.size());

		{
			Head.FileCode = PACKHEAD_CODE;
			Head.Version  = PACKHEAD::VERSION_0x0100;
			Head.FileCount= (unt32)TemporaryInfo.size() ^ AngouKey;
			Head.HashTable= GetHashTableNum((unt32)TemporaryInfo.size()) ^ AngouKey;
			Head.InfoSizeComp = (unt32)ArchiveInfoCompress.size() ^ AngouKey;
			Head.InfoSize     = (unt32)ArchiveInfo.size() ^ AngouKey;
			Head.ArchiveOffset= ArchiveOffset ^ AngouKey;

			if( ArchiveInfoCompress.size()==ArchiveInfo.size() )	{ Head.CompressType = COMPRESSTYPE_NONE; }
			else													{ Head.CompressType = COMPRESSTYPE_ZLIB; }


			Head.KeyCode[0] = Str2Binary32(((AngouKey>>24)&0xFF),CRand::Get(0x100),CRand::Get(0x100),CRand::Get(0x100));
			Head.KeyCode[1] = Str2Binary32(CRand::Get(0x100),((AngouKey>>16)&0xFF),CRand::Get(0x100),CRand::Get(0x100));
			Head.KeyCode[2] = Str2Binary32(CRand::Get(0x100),CRand::Get(0x100),((AngouKey>> 8)&0xFF),CRand::Get(0x100));
			Head.KeyCode[3] = Str2Binary32(CRand::Get(0x100),CRand::Get(0x100),CRand::Get(0x100),((AngouKey>> 0)&0xFF));
		}

		//	t@Cւ̏

		CFileWrite hFile;

		hFile.Open( m_OutputName, CFileWrite::OPENOPTION_NEW );
		hFile.Write( &Head, sizeof(Head) );
		hFile.Write( &(ArchiveInfoCompress[0]), (int)ArchiveInfoCompress.size() );

		{
			//	_~[f[^̍쐬
			if( dummybyte!=0 )
			{
				MySTL::vector<unt08> dummy(dummybyte,0);
				hFile.Write( &(dummy[0]), (int)dummy.size() );
			}
		}
//		MAID_TRACE( MAIDTEXT("Head:") << sizeof(Head)
//				<< MAIDTEXT("ArchiveInfo:") << ArchiveInfoCompress.size()
//				<< MAIDTEXT("ArchiveOffset:") << ArchiveOffset
//				<< MAIDTEXT("dummybyte:") << dummybyte
//				);

		for( int i=0; i<(int)TemporaryInfo.size(); ++i ) 
		{
			TEMPORARYFILEINFO& src	= TemporaryInfo[i];

			if( Brige.IsExit )
			{
				CThreadMutexLocker Lock(m_Section);
				m_Status.State = STATUS::STATE_CANCEL;
				m_Status.Text  = MAIDTEXT("I܂");
				return 0;
			}

			{
				CThreadMutexLocker Lock(m_Section);
				m_Status.Progress = i*50/(unt32)TemporaryInfo.size()+50;
				m_Status.Text  = src.SourcePath + MAIDTEXT(" ̃A[JCu");
			}

			MySTL::vector<unt08>	tmp;
			CFileRead::Read( src.TemporaryPath, tmp );

			if( !tmp.empty() )
			{
				hFile.Write( &(tmp[0]), (unt32)tmp.size() );
			}
		}
	}





	//	e|ɍ쐬t@C̍폜
	for( int i=0; i<(int)TemporaryInfo.size(); ++i ) 
	{
		TEMPORARYFILEINFO& src	= TemporaryInfo[i];

		CShell::DeleteFile( src.TemporaryPath );
	}

	//	fBNg
	CShell::DeleteDirectory( MAIDTEXT(TEMPORARY_DIRECTORY) );



	{
		CThreadMutexLocker Lock(m_Section);

		m_Status.State = STATUS::STATE_SUCCESS;
		m_Status.Text  = MAIDTEXT("I܂");
		m_Status.Progress = 100;
	}

	return 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵fBNgɂt@C񋓂
/*!
 	fBNg̃fBNg܂
 
 	\param	Dir		[i ]	fBNg
 	\param	List	[ o]	񋓐
 */
void	CPackFileCreater::PickupFile( const mstring& Dir, FILELIST& List )
{
	CShell::FINDOBJECTLIST	CandidateFile;

	CandidateFile = CShell::PickupFile( Dir+MAIDTEXT("\\*.*") );

	for( CShell::FINDOBJECTLIST::iterator ite=CandidateFile.begin(); ite!=CandidateFile.end(); ++ite )
	{
		const mstring str = ite->GetFileName();

		if( str[0]=='.' ) { continue; }

		switch( ite->GetFileType() )
		{
		case CShell::CFindObject::TYPE_FILE:
			{
				List.push_back( ToLower(Dir+MAIDTEXT("\\")+str) );	//<- łɏĂ
			}break;

		case CShell::CFindObject::TYPE_DIRECTORY:
			{
				PickupFile( Dir+MAIDTEXT("\\")+str, List );
			}break;
		}
	}
}


}
