#ifndef CThreadMutex_h
#define CThreadMutex_h

/*!
 	\file
 	\brief	XbhNX
 */

#include"../../Setup/CompileMode.h"
#include"../Macro.h"

#include"../../Setup/Win32.h"

namespace Maid
{
	class CThreadMutex
	{
	public:
		CThreadMutex();
		~CThreadMutex();

		void Lock();
		void Unlock();

	private:
		CRITICAL_SECTION	m_Section;
	};

	class CThreadMutexLocker
	{
	public:
		CThreadMutexLocker(CThreadMutex& cs) : m_rSection(cs) { m_rSection.Lock(); }
		~CThreadMutexLocker() { m_rSection.Unlock(); }
	protected:
		CThreadMutex& m_rSection;
	};

}

#endif