#include"CDllWrapper.h"
#include"../Debug/cassert.h"
#include"../Debug/cwarning.h"
#include"../CString.h"

namespace Maid
{
/*!
 	@class	CDllWrapper CDLLWrapper.h
 	@brief	DLL ̃bpNX
 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CDllWrapper::CDllWrapper()
:m_hDll(NULL)
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CDllWrapper::~CDllWrapper()
{
	Free();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! DLL ̓ǂݍ
/*!
 	@param	DllName [i ]	ǂݍނckk
 
	@exception CExceptionNotDLL I[vɎsꍇ
 */
void CDllWrapper::Load( const mstring& DllName )
{
	Free();

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(DllName);

	HINSTANCE hInst  = ::LoadLibrary( sjis_name.c_str() );

	if( hInst==NULL ) 
	{
		MAID_ASSERT( true, DllName << "܂" );
		MAID_THROWEXCEPTION( DllName + MAIDTEXT("܂") );
	}

	m_DllName = DllName;
	m_hDll    = hInst;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ֐AhX̎擾
/*!
 *	\param	FunctionName [i ]	擾֐
 *
 *	\return ֐݂炻̃AhX
\n			݂Ȃmtkk
 */
FARPROC	CDllWrapper::GetProcAddress( const mstring& FunctionName ) const
{
	MAID_ASSERT( m_hDll==NULL, "ckkǂݍł܂" );
	if( m_hDll==NULL ) { return NULL; }

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(FunctionName);

	return ::GetProcAddress( m_hDll, sjis_name.c_str() );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ񂾂ckk̊J
/*!
 */
void CDllWrapper::Free()
{
	if( m_hDll!=NULL )
	{
		::FreeLibrary(m_hDll);
		m_hDll = NULL;
	}
}

}