/*!
 	@file 
 	@brief	wlkm[h
 */

#ifndef CXMLNode_h
#define CXMLNode_h

#include"../../Setup/CompileMode.h"
#include"../Macro.h"
#include"../mstring.h"

#include<vector>
#include<map>
#include<boost/smart_ptr.hpp>

namespace Maid
{

	class CXMLText
	{
	public:
		CXMLText();
		CXMLText( const mstring& Text );

		int GetInt() const;
		float GetFloat() const;
		const mstring& GetStr() const;

		bool IsEmpty() const;
	private:
		mstring	m_Text;
	};

	class CXMLNode;
	typedef boost::shared_ptr<CXMLNode>	SPXMLNODE;

	class CXMLNode
	{
	public:
		typedef MySTL::map<mstring,CXMLText> ATTRIBUTELIST;
		typedef MySTL::vector<SPXMLNODE>			NODELIST;

		CXMLNode();


		mstring	GetName() const;

		enum TYPE {
			TYPE_EMPTY,		//	m[h
			TYPE_TEXT,		//	eLXgm[h
			TYPE_ELEMENT,	//	vfm[h
			TYPE_COMMENT	//	Rgm[h
		};

		TYPE GetType() const;

		int GetAttributeLength()const;
		CXMLText GetAttribute( const mstring& Name )const;
		const ATTRIBUTELIST& GetAttributeTable() const;

		CXMLText GetText() const;
		mstring GetComment() const;
		mstring GetElementName() const;

		bool IsEmpty() const;

		int  GetChildLength()const;
		CXMLNode&	GetChildNode( int index )const;

		void SetElementName( const mstring& Name );
		void SetText( const mstring& Text );
		void SetComment( const mstring& Text );
		void SetAttribute( const mstring& Name, const CXMLText& Value );
		void DeleteAttribute( const mstring& Name );


		void AddChildNode( const SPXMLNODE& pNode );
		void InsertChildNode( int Index, const SPXMLNODE& pNode );
		void DeleteChildNode( int Index );
		void SetChildNode( int Index, const SPXMLNODE& pNode );


	private:
		mstring			m_Name;
		TYPE			m_Type;
		NODELIST		m_ChildList;
		ATTRIBUTELIST	m_AttributeList;
		CXMLText		m_Text;
	};

}
#endif
