/*!
 	@file 
 	@brief	wlkǂݍ݃NX
 */

#ifndef CXMLReader_h
#define CXMLReader_h

#include"../../Setup/CompileMode.h"
#include"../Macro.h"

#include"CXMLNode.h"
#include"CXMLDocument.h"

#include<stack>

namespace Maid
{
	class CXMLReader
	{
	public:
		void Load( const mstring& FileName );
		void LoadText( const MySTL::vector<unt08>& TextImage  );

		void NextNode();
		bool IsEndNode();
		void AscendNode();
		void DescendNode();

		bool IsTopNode();

		enum NODETYPE
		{
			NODETYPE_EMPTY,		//	ŝ݂Ƃ
			NODETYPE_ELEMENT,	//	f[^<a>cccc</a> 
			NODETYPE_TAG,		//	qf[^<a>EEE(ɂ낢날)EEE</a> 
		};

		NODETYPE GetNodeType()const;


		mstring GetNodeName()const;
		mstring GetString()const;
		int GetInteger()const;
		float GetFloat()const;
		CXMLText GetAttribute( const mstring& Name )const;

	private:
		CXMLNode& GetCurrentNode()const;
		CXMLNode& GetTextNode( CXMLNode& parent )const;

	private:
		CXMLDocument	m_Docment;

		struct NODESTACK
		{
			NODESTACK( CXMLNode& n )
				:ParentNode(n)
			{

				ChildPos = 0;
			}

			CXMLNode& ParentNode;
			int	ChildPos;
		};

		MySTL::stack<NODESTACK>	m_ParentStack;
	};

	class CXMLReaderAutoDescend_base
	{
	public:
		CXMLReaderAutoDescend_base( CXMLReader& r )
			:m_Reader(r)
		{
			m_Reader.AscendNode();
		}

		~CXMLReaderAutoDescend_base()
		{
			m_Reader.DescendNode();
		}
	private:
		CXMLReader& m_Reader;
	};

	#define CXMLReaderAutoDescend2( a, writer ) CXMLReaderAutoDescend_base p##a(writer)
	#define CXMLReaderAutoDescend( writer )  CXMLReaderAutoDescend2(__LINE__, writer)

}
#endif
