/*!
 	@file 
 	@brief	wlkt@C쐬NX
 */

#ifndef CXMLWriter_h
#define CXMLWriter_h

#include"../../Setup/CompileMode.h"
#include"../Macro.h"
#include"CXMLDocument.h"
#include<stack>

namespace Maid
{
	class CXMLWriter
	{
	public:
		CXMLWriter();

		void AscendNode( const mstring& ElementName );
		void DescendNode();

		void NextNode();

		void SetElementName( const mstring& name );
		void SetValueText( const mstring& value );
		void SetValueFloat( float value );
		void SetValueInt( int value );

		void SetTag( const mstring& element, const mstring& value );
		void SetTag( const mstring& element, const float& value );
		void SetTag( const mstring& element, const int&   value );

		void AddAttribute( const mstring& name, const mstring& value );
		void AddAttribute( const mstring& name, const float& value );
		void AddAttribute( const mstring& name, const int& value );

		void Save( const mstring& FileName );
		void Save( MySTL::vector<unt08>& FileImage );

	private:

		void SetValue( const SPXMLNODE& pNode );
		void ConvertSaveText( const CXMLNode& Node, mstring& text );

	private:
		SPXMLNODE		m_pCurrentNode;

		MySTL::stack<SPXMLNODE>	m_ParentStack;
	};

	class CXMLWriterAutoDescend_base
	{
	public:
		CXMLWriterAutoDescend_base( CXMLWriter& w, const mstring& ElementName )
			:m_Writer(w)
		{
			m_Writer.AscendNode(ElementName);
		}

		~CXMLWriterAutoDescend_base()
		{
			m_Writer.DescendNode();
		}
	private:
		CXMLWriter& m_Writer;
	};

	#define CXMLWriterAutoDescend2( a, writer, name ) CXMLWriterAutoDescend_base p##a(writer,name)
	#define CXMLWriterAutoDescend( writer, name )  CXMLWriterAutoDescend2(__LINE__, writer, name)

}

#endif