#include"CGUICheckButton.h"

namespace Maid
{
	/*!
	 *	\class	CGUICheckButton CGUICheckButton.h
	 *	\brief	`FbN{^̓ŎgpĂ{^Xi
	 */
	class ButtonListener : public CGUIButton::Listener
	{
	public:
		ButtonListener( const CGUICheckButton* p ) : m_pOwner(p){}
		virtual bool IsCollision( const POINT2DI& pos ) const
		{
			return m_pOwner->GetListener()->IsCollision( pos );
		}
	private:
		const CGUICheckButton*	m_pOwner;
	};

	/*!
	 *	\class	CGUICheckButton CGUICheckButton.h
	 *	\brief	`FbN{^NX
	\n			 Windows ̃`FbN{^Ƃ
	 */
enum PARTSID
{
	PARTSID_BUTTON=0,
};
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CGUICheckButton::CGUICheckButton()
{
	m_IsCheck = false;

	m_Button.SetID(PARTSID_BUTTON);
	m_Button.SetCallBack( MakeGUICallBackObject(&CGUICheckButton::GUICallBack,this) );
	m_Button.SetListener( SPGUIBUTTONLISTENER( new ButtonListener(this) ) );
}

CGUICheckButton::CGUICheckButton( const CGUICheckButton& button ) : IGUIParts( button )
{
	m_IsCheck = button.m_IsCheck;

	m_Button.SetID(PARTSID_BUTTON);
	m_Button.SetCallBack( MakeGUICallBackObject(&CGUICheckButton::GUICallBack,this) );
	m_Button.SetListener( SPGUIBUTTONLISTENER( new ButtonListener(this) ) );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xi̓o^
/*!	Xio^ȂꍇA܂Ȃ̂ŒӁI
 *
 *	\param	pListener	[i ]	VXi
 */
void	CGUICheckButton::SetListener( const SPGUICHECKBUTTONLISTENER& pListener )
{
	m_pListener = pListener;
	m_pListener->m_pOwner = this;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xi̎擾
/*!
 *	\return łɐݒ肳Ă郊Xi
 */
const SPGUICHECKBUTTONLISTENER&	CGUICheckButton::GetListener() const
{
	return m_pListener;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `FbNĂ邩H
/*!
 *	\return `FbNĂȂ true
 */
bool CGUICheckButton::IsCheck() const
{
	return m_IsCheck;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `FbNԂ̕ύX
/*!
 *	\param	IsCheck	[i ]	`FbNԂɂȂ true
 */
void CGUICheckButton::SetCheck( bool IsCheck )
{
	m_IsCheck = IsCheck;
}



CGUICheckButton& CGUICheckButton::operator = ( const CGUICheckButton& rha )
{
	m_Button	= rha.m_Button;
	m_pListener = rha.m_pListener;
	m_IsCheck	= rha.m_IsCheck;
	m_Button.SetCallBack( MakeGUICallBackObject(&CGUICheckButton::GUICallBack,this) );
	m_Button.SetListener( SPGUIBUTTONLISTENER( new ButtonListener(this) ) );

	return *this;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 *	Ȃǂ IGUIParts::OnLocalMove QƂ邱
 */
void CGUICheckButton::OnLocalMove()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnMove();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	Ȃǂ IGUIParts::OnLocalDraw QƂ邱
 */
void CGUICheckButton::OnLocalDraw( const POINT2DI& pos, CGraphic& Render )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	m_pListener->OnDraw( pos, Render );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[cɃJ[\邩H
/*!
 *	Ȃǂ IGUIParts::IsLocalCollision QƂ邱
 */
bool CGUICheckButton::IsLocalCollision( const POINT2DI& pos ) const
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->IsCollision( pos );
}

void CGUICheckButton::OnLocalMouseIn  ( const POINT2DI& pos )
{
	m_Button.OnMouseIn( pos );
}

void CGUICheckButton::OnLocalMouseOut ( const POINT2DI& pos )
{
	m_Button.OnMouseOut( pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseDown QƂ邱
 */
void CGUICheckButton::OnLocalMouseDown( const POINT2DI& pos )
{
	m_Button.OnMouseDown( pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseUp QƂ邱
 */
void CGUICheckButton::OnLocalMouseUp  ( const POINT2DI& pos )
{
	m_Button.OnMouseUp( pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃J[\ɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseMove QƂ邱
 */
void CGUICheckButton::OnLocalMouseMove( const POINT2DI& pos )
{
	m_Button.OnMouseMove( pos );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyDown QƂ邱
 */
void CGUICheckButton::OnLocalKeyDown( unt08 KeyCode )
{
	m_Button.OnKeyDown( KeyCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyUp QƂ邱
 */
void CGUICheckButton::OnLocalKeyUp( unt08 KeyCode )
{
	m_Button.OnKeyUp( KeyCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂEƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusIn QƂ邱
 */
void CGUICheckButton::OnLocalFocusIn()
{
	m_Button.OnFocusIn();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂEƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusOut QƂ邱
 */
void CGUICheckButton::OnLocalFocusOut()
{
	m_Button.OnFocusOut();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ԂςɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalChangeState QƂ邱
 */
void CGUICheckButton::OnLocalChangeState( bool NewStateEnable, bool NewStateVisible )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnChengeState( NewStateEnable, NewStateVisible );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! oɎĂfthp[cR[obN֐
/*!
 *	\param	GUIParts	[i ]	fthp[c
 *	\param	Message		[i ]	Ă郁bZ[W
 */
void CGUICheckButton::GUICallBack( unt32 GUIParts, GUIMESSAGE Message )
{
	switch( GUIParts )
	{
	case PARTSID_BUTTON:
		{
			switch( Message )
			{
			case GUIMESSAGE_PARTS_FOCUSIN:
				{
					m_pListener->OnFocusIn();
					CallBack(GUIMESSAGE_PARTS_FOCUSIN);
				}break;

			case GUIMESSAGE_PARTS_FOCUSOUT:
				{
					m_pListener->OnFocusOut();
					CallBack(GUIMESSAGE_PARTS_FOCUSOUT);
				}break;

			case GUIMESSAGE_BUTTON_MOUSEDOWN:
				{
					m_pListener->OnMouseDown();
					CallBack(GUIMESSAGE_BUTTON_MOUSEDOWN);
				}break;

			case GUIMESSAGE_BUTTON_MOUSEUP:
				{
					m_pListener->OnMouseUp();
					CallBack(GUIMESSAGE_BUTTON_MOUSEUP);
				}break;

			case GUIMESSAGE_PARTS_MOUSEIN:
				{
					m_pListener->OnMouseIn();
					CallBack(GUIMESSAGE_PARTS_MOUSEIN);
				}break;

			case GUIMESSAGE_PARTS_MOUSEOUT:
				{
					m_pListener->OnMouseOut();
					CallBack(GUIMESSAGE_PARTS_MOUSEOUT);
				}break;

			case GUIMESSAGE_BUTTON_CLICK:
				{
					m_IsCheck = !m_IsCheck;
					m_pListener->OnMouseClick();

					CallBack(GUIMESSAGE_CHECK_CHANGESTATE);
				}break;
			}
		}break;
	}
}


}
