#include"CGUIManager.h"
#include"CGUIParts.h"

namespace Maid
{

	static mstring s_CharCodeString;
	/*!
	 *	\class	CGUIManager CGUIManager.h
	 *	\brief	fthIuWFNgǗNX
	 */
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CGUIManager::CGUIManager()
{
	m_pMouse = NULL;
	m_pKey   = NULL;
	m_pInputMethod = NULL;
	m_IsEnable = true;
	m_IsVisible= true;
	m_DefaultPos.x = 0;
	m_DefaultPos.y = 0;

	m_pFocusParts = NULL;
	m_State = STATE_NORMAL;

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CGUIManager::~CGUIManager()
{
	if( m_pKey!=NULL )
	{
		const_cast<CKeybord*>(m_pKey)->SetCharCodeFunction( ICharCodeDriver::CHARCODEFUNCTION() );
	}

	if( m_pInputMethod!=NULL )
	{
		const_cast<CInputMethod*>(m_pInputMethod)->SetResultFunction( IInputMethodDriver::RESULTCODEFUNCTION() );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fthp[c̏s
/*!
 *	t[ĂԂ
 */
void CGUIManager::OnMove()
{
	if( !m_IsEnable ) { return ; }

	for( PARTSLIST::iterator ite=m_PartsList.begin(); ite!=m_PartsList.end(); ++ite )
	{
		IGUIParts* pParts = ite->second;
		pParts->OnMove();
	}


	POINT2DI	pos( 0, 0 );
	bool	IsMouseMove = false;
	bool	IsMouseDown = false;
	bool	IsMouseOut  = false;

	MySTL::vector<unt08>	KeyInCode;
	MySTL::vector<unt08>	KeyOutCode;

	if( m_pMouse!=NULL )
	{
		pos = POINT2DI( m_pMouse->GetX() - m_DefaultPos.x,  m_pMouse->GetY() - m_DefaultPos.y );

		IsMouseMove = m_pMouse->GetDeltaX()!=0 || m_pMouse->GetDeltaY()!=0;

		IsMouseDown = m_pMouse->IsInL();
		IsMouseOut  = m_pMouse->IsOutL();
	}

	if( m_pKey!=NULL )
	{
		for( int32 i=0; i<CKeybord::BUTTON_MAX; ++i )
		{
			if( i==CKeybord::BUTTON_TAB ) { continue; }
			if( IsKeyIn(i) ) { KeyInCode.push_back(i); }
		}

		for( int32 i=0; i<CKeybord::BUTTON_MAX; ++i )
		{
			if( i==CKeybord::BUTTON_TAB ) { continue; }
			if( m_pKey->IsOut(i) ) { KeyOutCode.push_back(i); }
		}
	}


	if( !KeyInCode.empty() )
	{
		for( int i=0; i<(int)KeyInCode.size(); ++i ) { OnMoveKeyBoradIn(KeyInCode[i]); }
	}

	if( !KeyOutCode.empty() )
	{
		for( int i=0; i<(int)KeyOutCode.size(); ++i ) { OnMoveKeyBoradOut(KeyOutCode[i]); }
	}

	switch( m_State )
	{
	case STATE_NORMAL:
		{
/*
			if( IsKeyIn(CKeybord::BUTTON_TAB) )
			{
				//	L[{[htH[JX؂ւꂽAύX
				if( m_PartsList.empty() ) { break; }

				if( m_pFocusParts==NULL )
				{
					m_pFocusParts = m_PartsList.begin()->second;
				}else
				{
					m_pFocusParts->OnFocusOut();

					const unt32 id = m_pFocusParts->GetID();
					PARTSLIST::iterator ite = m_PartsList.find(id);
					++ite;

					if( ite==m_PartsList.end() ) { m_pFocusParts = m_PartsList.begin()->second; }
					else						 { m_pFocusParts = ite->second; }
				}
				m_pFocusParts->OnFocusIn();
			}
*/

			if( IsMouseMove )
			{
				//	}EXAtH[JXT
				//	p[cœĂ烁bZ[Ŵ
				IGUIParts* pParts = SerchParts(pos.x,pos.y);

				if( m_pFocusParts!=pParts )
				{
					ForceMouseCheck();
				}else
				{
					if( m_pFocusParts!=NULL ) { m_pFocusParts->OnMouseMove(pos); }
				}
			}

			if( IsMouseDown )
			{
				//	}EXꂽA[hύX
				if( m_pFocusParts!=NULL )
				{
					m_pFocusParts->OnMouseDown(pos);
					m_State = STATE_MOUSEDOWN;
				}
			}

			if( m_pKey!=NULL && m_pFocusParts!=NULL )
			{
				if( !s_CharCodeString.empty() )	{ m_pFocusParts->OnCharCode( s_CharCodeString ); s_CharCodeString.clear(); }
			}

		}break;

	case STATE_MOUSEDOWN:
		{
			//	̏Ԃ̎ m_pFocusParts==NULL ͂肦Ȃ

			if( IsMouseMove )
			{
				const bool old = m_pFocusParts->IsMouseIn();
				const bool now = m_pFocusParts->IsCollision(pos);
					
				if( !old &&  now ) { m_pFocusParts->OnMouseIn(pos);  }//	̂͊Oō͓Ă
				ef(  old && !now ) { m_pFocusParts->OnMouseOut(pos); }//	̂͒ō͊O
				else
				{
					m_pFocusParts->OnMouseMove(pos);
				}
			}

			if( IsMouseOut )
			{
				m_pFocusParts->OnMouseUp(pos);
				m_State = STATE_NORMAL;

				//	 m_pFocusParts->OnMouseUp(pos) ̒
				//	m_pFocusParts==NULL ɂȂĂ܂Ƃ̂
				//	NULL `FbNsB
				//	݌v~XłBbZ[Wł肵Ȃƃ_ۂ

				if( m_pFocusParts!=NULL )
				{
					if( !m_pFocusParts->IsCollision(pos) ) 
					{
						ForceMouseCheck();
					}
				}
			}
		}break;
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fthp[c̕`s
/*!
 *	t[ĂԂ
 */
void CGUIManager::OnDraw( CGraphic& Render )
{
	if( !m_IsVisible ) { return ; }

	for( MySTL::list<IGUIParts*>::iterator ite=m_DrawPriority.begin(); ite!=m_DrawPriority.end(); ++ite )
	{
		(*ite)->OnDraw( m_DefaultPos, Render );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̓fBoCX̃Zbg
/*!
 *	\param	pKey			[i ]	L[{[hiL[{[h̑󂯕tȂꍇ͂mtkkj
 *	\param	pMouse			[i ]	}EXi}EX̑󂯕tȂꍇ͂mtkkj
 *	\param	pInputMethod	[i ]	edoiedofth(eLXg{bNX)gȂꍇ͂mtkkj
 */
void CGUIManager::SetInputDevice( const CKeybord* pKey, const CMouse* pMouse, const CInputMethod* pInputMethod )
{
	m_pKey   = pKey;
	m_pMouse = pMouse;
	m_pInputMethod = pInputMethod;


	if( m_pKey!=NULL )
	{
		const_cast<CKeybord*>(m_pKey)->SetCharCodeFunction( MakeCharCodeFunctionObject(&CGUIManager::CharCodeCallBack,this) );
	}

	if( m_pInputMethod!=NULL )
	{
		const_cast<CInputMethod*>(m_pInputMethod)->SetResultFunction( MakeResultCodeFunctionObject(&CGUIManager::IMECodeCallBack,this) );
	}

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `̊{W̃Zbg
/*!
 *	\param	x	[i ]	`Ww
 *	\param	y	[i ]	`Wx
 */
void CGUIManager::SetPos( int32 x, int32 y )
{
	m_DefaultPos.x = x;
	m_DefaultPos.y = y;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ԃ̕ύX
/*!
 *	\param	IsEnable	[i ]	fthp[csH
 *	\param	IsVisible	[i ]	fthp[c̕`sH
 */
void CGUIManager::SetStateAll( bool IsEnable, bool IsVisible )
{
	SetEnableAll ( IsEnable );
	SetVisibleAll( IsVisible );
}
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ԃ̕ύX
/*!
 *	\param	IsEnable	[i ]	fthp[csH
 */
void CGUIManager::SetEnableAll( bool IsEnable )
{
	m_IsEnable = IsEnable;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Ԃ̕ύX
/*!
 *	\param	IsVisible	[i ]	fthp[c̕`sH
 */
void CGUIManager::SetVisibleAll( bool IsVisible )
{
	m_IsVisible = IsVisible;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[tH[JX̕ύX
/*!
 *	\param	PartsID	[i ]	VtH[JX^fthp[ĉhc
 */
void CGUIManager::SetFocus( unt32 PartsID )
{
	if( PartsID==NOFORCUS )
	{
		if( m_pFocusParts!=NULL ) { m_pFocusParts->OnFocusOut(); }
		m_pFocusParts = NULL;
		return ;
	}

	PARTSLIST::iterator ite = m_PartsList.find(PartsID);

	if( ite==m_PartsList.end() ) { return ; }

	if( m_pFocusParts==ite->second ) { return ; }

	if( m_pFocusParts!=NULL ) { m_pFocusParts->OnFocusOut(); }
	m_pFocusParts = ite->second;
	m_pFocusParts->OnFocusIn();
	m_State = STATE_NORMAL;
}


unt32 CGUIManager::GetFocus()
{
	if( m_pFocusParts==NULL ) { return NOFORCUS; }

	return m_pFocusParts->GetID();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WW̎擾
/*!
 *	\return 	WWw
 */
int32	CGUIManager::GetPosX() const
{
	return m_DefaultPos.x;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WW̎擾
/*!
 *	\return 	WWx
 */
int32	CGUIManager::GetPosY() const
{
	return m_DefaultPos.y;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! GUIp[c̓o^
/*!
 *	hĉ̂o^ꍇAȑÔfthp[c͍폜܂
 *
 *	\param 	PartsID	[i ]	o^hc
 *	\param 	pParts	[i ]	o^p[c
 */
void CGUIManager::RegistGUIParts( unt32 PartsID, IGUIParts* pParts )
{
	pParts->SetCallBack( m_CallBack );
	pParts->SetID ( PartsID );
	pParts->m_pOwner = this;

	m_PartsList[PartsID] = pParts;

	m_DrawPriority.push_back( pParts );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! GUIp[c̍폜
/*!
 *	hĉ̂o^ꍇAȑÔfthp[c͍폜܂
 *
 *	\param 	PartsID	[i ]	폜^hc
 */
void CGUIManager::DeleteGUIParts( unt32 PartsID )
{
	PARTSLIST::iterator ite = m_PartsList.find(PartsID);

	if( ite==m_PartsList.end() ) { return ; }

	for( MySTL::list<IGUIParts*>::iterator i=m_DrawPriority.begin(); i!=m_DrawPriority.end(); ++i )
	{
		if( (*i)->m_PartsID==PartsID )
		{
			m_DrawPriority.erase( i );
			break;
		}
	}


	IGUIParts* pParts = ite->second;

//	pParts->SetCallBack( GUIMESSAGEFUNCTION() );
	pParts->ClearCallBack(  );
	pParts->SetID ( GUIID_NONE );
	pParts->m_pOwner = NULL;

	if( m_pFocusParts==pParts ) 
	{
		m_State = STATE_NORMAL;
		m_pFocusParts = NULL; 
	}

	m_PartsList.erase( ite );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! o^ĂGUIp[cɂȂɂɃR[obN֐̐ݒ
/*!
 *	\param 	CallBack	[i ]	R[obN֐
 */
void CGUIManager::SetCallBack( const GUIMESSAGEFUNCTION& CallBack )
{
	m_CallBack = CallBack;
	for( PARTSLIST::iterator ite=m_PartsList.begin(); ite!=m_PartsList.end(); ++ite )
	{
		IGUIParts* pParts = ite->second;
		pParts->SetCallBack( CallBack );
	}
}


const CMouse*		CGUIManager::GetMouse()	const { return m_pMouse;		}
const CKeybord*		CGUIManager::GetKey()	const { return m_pKey;			}
const CInputMethod* CGUIManager::GetIME()	const { return m_pInputMethod;	}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵 PartsID ԎOɕ`悷悤ɂ
/*!
 *	̊֐QĂԂƁAɌĂ񂾃p[c͌ɌĂ񂾃p[c̉ɕ`悳܂
 *
 *	1,2,3,4,5 ̃p[cꍇ
 *	SetGUIPartsTopMoust( 3 )  
 *
 *  1,2,4,5,3
 *
 *	SetGUIPartsTopMoust( 4 )  
 *
 *  1,2,5,3,4
 *
 *  ƂȂ܂B
 *
 *	\param 	PartsID	[i ]	w肷p[chc
 */
void CGUIManager::SetGUIPartsTopMoust( unt32 PartsID )
{
	for( MySTL::list<IGUIParts*>::iterator ite=m_DrawPriority.begin(); ite!=m_DrawPriority.end(); ++ite )
	{
		IGUIParts* pParts = (*ite);
		if( pParts->m_PartsID==PartsID )
		{
			m_DrawPriority.erase( ite );
			m_DrawPriority.push_back( pParts );
			break;
		}
	}
}

//	}EX`FbNɍs킹
//	V{^𑝂₵ꍇȂǂɍs
void CGUIManager::ForceMouseCheck()
{
	const POINT2DI pos( m_pMouse->GetX() - m_DefaultPos.x,  m_pMouse->GetY() - m_DefaultPos.y );

	IGUIParts* pParts = SerchParts(pos.x,pos.y);

	if( m_pFocusParts!=pParts )
	{
		if( m_pFocusParts!=NULL )	{ m_pFocusParts->OnFocusOut(); m_pFocusParts->OnMouseOut( pos ); }
		if( pParts!=NULL )			{ pParts->OnMouseIn( pos ); pParts->OnFocusIn(); }
		m_pFocusParts = pParts;
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵}EXWɂp[cT
/*!
 *	m_DefaultPos ̉e͊eł邱
 *
 *	\param	x	[i ]	}EXXW
 *	\param	y	[i ]	}EXYW
 *
 *	\retrn	̍WɂGUIp[c
\n			ȂNULL
 */
IGUIParts* CGUIManager::SerchParts( int32 x, int32 y )
{
	const POINT2DI pos( x, y );
	for( PARTSLIST::iterator ite=m_PartsList.begin(); ite!=m_PartsList.end(); ++ite )
	{
		IGUIParts* pParts = ite->second;

		if( !pParts->IsEnable() ) { continue; }

		if( pParts->IsCollision(pos) ) { return pParts; }
	}

	return NULL;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! OnMove() ̃L[{[hƂ̏
/*!
 *	\param	KeyCode	[i ]	͂ꂽL[R[h
 */
void CGUIManager::OnMoveKeyBoradIn( unt08 KeyCode )
{
	if( m_pFocusParts==NULL )
	{
		for( PARTSLIST::iterator ite=m_PartsList.begin(); ite!=m_PartsList.end(); ++ite )
		{
			if( ite->second->IsEnable() )
			{
				m_pFocusParts = ite->second;
				m_pFocusParts->OnFocusIn();
				break;
			}
		}

	}

	m_pFocusParts->OnKeyDown(KeyCode);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! OnMove() ̃L[{[h͂ȂƂ̏
/*!
 *	\param	KeyCode	[i ]	͂ꂽL[R[h
 */
void CGUIManager::OnMoveKeyBoradOut( unt08 KeyCode )
{
	if( m_pFocusParts==NULL )
	{
		//	͂肦ȂǁAꉞ
	}else
	{
		m_pFocusParts->OnKeyUp(KeyCode);
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[s[g܂߂āAL[ꂽuԂH
/*!
 *	\param	KeyCode	[i ]	ׂL[R[h
 */
bool CGUIManager::IsKeyIn( unt08 KeyCode )
{
	if( m_pKey!=NULL )
	{
		if( m_pKey->IsRepeat(KeyCode,30,20) ) { return true; }
	}

	return false;
}


void CGUIManager::CharCodeCallBack( unt32 str )
{
	s_CharCodeString += str;
}

void CGUIManager::IMECodeCallBack( const mstring& str )
{
	s_CharCodeString += str;
}

}
