/*!
 *	\file
 *	\brief	fthIuWFNgǗNX
 *
 */

#ifndef CGUIManager_h
#define CGUIManager_h


#include"CGUIPartsDefine.h"
#include<list>
#include<boost/function.hpp>

namespace Maid
{
	class IGUIParts;
	class CGUIManager
	{
	public:

		enum
		{
			NOFORCUS = 0xFFFFFFFF,
		};

		CGUIManager();
		~CGUIManager();
		void	OnMove();
		void	OnDraw( CGraphic& Render );

		void SetInputDevice( const CKeybord* pKey, const CMouse* pMouse, const CInputMethod* pInputMethod );
		void SetPos( int32 x, int32 y );
		void SetStateAll( bool IsEnable, bool IsVisible );
		void SetEnableAll( bool IsEnable );
		void SetVisibleAll( bool IsVisible );
		void SetFocus( unt32 PartsID );

		unt32 GetFocus();

		int32	GetPosX() const;
		int32	GetPosY() const;

		void RegistGUIParts( unt32 PartsID, IGUIParts* pParts );
		void DeleteGUIParts( unt32 PartsID );

		void SetCallBack( const GUIMESSAGEFUNCTION& CallBack );

		void SetGUIPartsTopMoust( unt32 PartsID );

		void ForceMouseCheck();


		const CMouse*		GetMouse()	const;
		const CKeybord*		GetKey()	const;
		const CInputMethod* GetIME()	const;

	private:
		IGUIParts* SerchParts( int32 x, int32 y );
		void OnMoveKeyBoradIn( unt08 KeyCode );
		void OnMoveKeyBoradOut( unt08 KeyCode );

		bool IsKeyIn( unt08 KeyCode );


	private:
		typedef MySTL::map<unt32, IGUIParts*> PARTSLIST;
		PARTSLIST		m_PartsList;

		IGUIParts*	m_pFocusParts;	//!<	݃tH[JXĂp[c

		MySTL::list<IGUIParts*>	m_DrawPriority;	//	`揇(擪ԉ)

	private:
		GUIMESSAGEFUNCTION	m_CallBack;			//!<	GUIp[cɂȂɂꍇɃR[obN֐

		const CMouse*   m_pMouse;
		const CKeybord* m_pKey;
		const CInputMethod* m_pInputMethod;
		bool		m_IsEnable;
		bool		m_IsVisible;
		POINT2DI	m_DefaultPos;	//!< GUIp[c̊W

		enum STATE
		{
			STATE_NORMAL,		//	ʂ̏
			STATE_MOUSEDOWN,	//	}EX{^ĂŒ
		};

		STATE	m_State;

	private:
		void CharCodeCallBack( unt32 str );
		void IMECodeCallBack( const mstring& str );
	};


}

#endif
