#include"CGUIRadioButton.h"

namespace Maid
{
	/*!
	 *	\class	ButtonListener CGUIRadioButton.h
	 *	\brief	WI{^̓ŎgpĂ{^Xi
	 */
	class ButtonListener : public CGUIButton::Listener
	{
	public:
		ButtonListener( const CGUIRadioButton* p ) : m_pOwner(p){}
		virtual bool IsCollision( const POINT2DI& pos ) const
		{
			return m_pOwner->GetListener()->IsCollision( pos );
		}
	private:
		const CGUIRadioButton*	m_pOwner;
	};

	/*!
	 *	\class	CGUIRadioButton CGUIRadioButton.h
	 *	\brief	WI{^NX
	\n			P̂ŃWI{^ۂ삷邯ǁA
	\n			PCX^XP{^Ȃ̂ŁAO[vݒKv
	 */
enum PARTSID
{
	PARTSID_BUTTON=0,
};
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CGUIRadioButton::CGUIRadioButton()
{
	m_IsCheck = false;

	m_Button.SetID(PARTSID_BUTTON);
	m_Button.SetCallBack( MakeGUICallBackObject(&CGUIRadioButton::GUICallBack,this) );
	m_Button.SetListener( SPGUIBUTTONLISTENER( new ButtonListener(this) ) );
}

CGUIRadioButton::CGUIRadioButton( const CGUIRadioButton& button ) : IGUIParts( button )
{
	Copy( button );
}

CGUIRadioButton::~CGUIRadioButton()
{
	if( m_pGroup.get()!=NULL )
	{
		for( int i=0; i<(int)m_pGroup->m_GroupList.size(); ++i )
		{
			if( m_pGroup->m_GroupList[i]==this )
			{
				m_pGroup->m_GroupList.erase( m_pGroup->m_GroupList.begin()+i );
			}
		}
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xi̓o^
/*!	Xio^ȂꍇA܂Ȃ̂ŒӁI
 *
 *	\param	pListener	[i ]	VXi
 */
void	CGUIRadioButton::SetListener( const SPGUIRADIOBUTTONLISTENER& pListener )
{
	m_pListener = pListener;
	m_pListener->m_pOwner = this;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xi̎擾
/*!
 *	\return łɐݒ肳Ă郊Xi
 */
const SPGUIRADIOBUTTONLISTENER&	CGUIRadioButton::GetListener() const
{
	return m_pListener;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `FbNĂ邩H
/*!
 *	\return `FbNĂȂ true
 */
bool CGUIRadioButton::IsCheck() const
{
	return m_IsCheck;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `FbNԂ̕ύX
/*!
 *	\param	IsCheck	[i ]	`FbNԂɂȂ true
 */
void CGUIRadioButton::SetCheck( bool IsCheck )
{
	if( IsCheck )
	{
		if( m_pGroup.get()!=NULL )
		{
			for( int i=0; i<(int)m_pGroup->m_GroupList.size(); ++i )
			{
				CGUIRadioButton* pButton = m_pGroup->m_GroupList[i];
				if( pButton==this ) { continue; }

				pButton->SetCheck(false);
			}
		}
	}

	m_IsCheck = IsCheck;
}



CGUIRadioButton& CGUIRadioButton::operator = ( const CGUIRadioButton& rha )
{
	Copy( rha );

	return *this;
}

void CGUIRadioButton::SetGroup( const SPGUIRADIOBUTTONGROUP& pGroup )
{
	m_pGroup = pGroup;

	if( m_pGroup.get()!=NULL )
	{
		m_pGroup->m_GroupList.push_back( this );
	}
}

void CGUIRadioButton::Copy( const CGUIRadioButton& rha )
{
	m_Button	= rha.m_Button;
	m_pListener = rha.m_pListener;
	m_IsCheck	= rha.m_IsCheck;
	m_pGroup = rha.m_pGroup;
	m_Button.SetID(PARTSID_BUTTON);
	m_Button.SetCallBack( MakeGUICallBackObject(&CGUIRadioButton::GUICallBack,this) );
	m_Button.SetListener( SPGUIBUTTONLISTENER( new ButtonListener(this) ) );

	if( m_pGroup.get()!=NULL )
	{
		for( int i=0; i<(int)m_pGroup->m_GroupList.size(); ++i )
		{
			if( m_pGroup->m_GroupList[i]==&rha ) { m_pGroup->m_GroupList[i] = this; }
		}
	}

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 *	Ȃǂ IGUIParts::OnLocalMove QƂ邱
 */
void CGUIRadioButton::OnLocalMove()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnMove();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	Ȃǂ IGUIParts::OnLocalDraw QƂ邱
 */
void CGUIRadioButton::OnLocalDraw( const POINT2DI& pos, CGraphic& Render )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	m_pListener->OnDraw( pos, Render );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[cɃJ[\邩H
/*!
 *	Ȃǂ IGUIParts::IsLocalCollision QƂ邱
 */
bool CGUIRadioButton::IsLocalCollision( const POINT2DI& pos ) const
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->IsCollision( pos );
}

void CGUIRadioButton::OnLocalMouseIn  ( const POINT2DI& pos )
{
	m_Button.OnMouseIn( pos );
}

void CGUIRadioButton::OnLocalMouseOut ( const POINT2DI& pos )
{
	m_Button.OnMouseOut( pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseDown QƂ邱
 */
void CGUIRadioButton::OnLocalMouseDown( const POINT2DI& pos )
{
	m_Button.OnMouseDown( pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseUp QƂ邱
 */
void CGUIRadioButton::OnLocalMouseUp  ( const POINT2DI& pos )
{
	m_Button.OnMouseUp( pos );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃J[\ɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseMove QƂ邱
 */
void CGUIRadioButton::OnLocalMouseMove( const POINT2DI& pos )
{
	m_Button.OnMouseMove( pos );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyDown QƂ邱
 */
void CGUIRadioButton::OnLocalKeyDown( unt08 KeyCode )
{
	m_Button.OnKeyDown( KeyCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyUp QƂ邱
 */
void CGUIRadioButton::OnLocalKeyUp( unt08 KeyCode )
{
	m_Button.OnKeyUp( KeyCode );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂEƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusIn QƂ邱
 */
void CGUIRadioButton::OnLocalFocusIn()
{
	m_Button.OnFocusIn();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂEƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusOut QƂ邱
 */
void CGUIRadioButton::OnLocalFocusOut()
{
	m_Button.OnFocusOut();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ԂςɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalChangeState QƂ邱
 */
void CGUIRadioButton::OnLocalChangeState( bool NewStateEnable, bool NewStateVisible )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnChengeState( NewStateEnable, NewStateVisible );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! oɎĂfthp[cR[obN֐
/*!
 *	\param	GUIParts	[i ]	fthp[c
 *	\param	Message		[i ]	Ă郁bZ[W
 */
void CGUIRadioButton::GUICallBack( unt32 GUIParts, GUIMESSAGE Message )
{
	switch( GUIParts )
	{
	case PARTSID_BUTTON:
		{
			switch( Message )
			{
			case GUIMESSAGE_PARTS_FOCUSIN:
				{
					m_pListener->OnFocusIn();
				}break;

			case GUIMESSAGE_PARTS_FOCUSOUT:
				{
					m_pListener->OnFocusOut();
				}break;

			case GUIMESSAGE_BUTTON_MOUSEDOWN:
				{
					m_pListener->OnMouseDown();
					CallBack(GUIMESSAGE_BUTTON_MOUSEDOWN);
				}break;

			case GUIMESSAGE_BUTTON_MOUSEUP:
				{
					m_pListener->OnMouseUp();
					CallBack(GUIMESSAGE_BUTTON_MOUSEUP);
				}break;

			case GUIMESSAGE_BUTTON_CLICK:
				{
					if( !m_IsCheck ) { SetCheck(true); }

					m_pListener->OnMouseClick();
					CallBack(GUIMESSAGE_RADIO_CHANGEBUTTON);
/*
					if( m_IsCheck )
					{
						//	`FbNĂāAꂽꍇ@@Ȃ
					}else
					{
						SetCheck(true);
						m_pListener->OnMouseClick();
						CallBack(GUIMESSAGE_RADIO_CHANGEBUTTON);
					}
*/
				}break;
			}
		}break;
	}
}


}
