#include"CSingleWindowAppWindows.h"
#include"../../auxiliary/CString.h"
#include"../../auxiliary/Windows/CShell.h"
#include"../../auxiliary/Debug/CWarning.h"
#include"../../auxiliary/Debug/CAssert.h"
#include"../../auxiliary/Debug/CException.h"

#include"CSingleWindowMessageImpl1.h"

namespace Maid
{


void CSingleWindowAppWindows::PostWindowMessage( const SPSINGLEWINDOWMESSAGE& pMess )
{
	CThreadMutexLocker Lock(m_MessageMutex);

	m_WindowMessageQue.push_back( pMess );
}


CWindow::CALLBACKCODE CSingleWindowAppWindows::wmClose( CWindowsMessage& msg )
{
	const SPSINGLEWINDOWMESSAGE pMess( new SingleWindowMessage::Base(SingleWindowMessage::Base::PUSHCLOSEBUTTON) );

	PostWindowMessage( pMess );

	return CWindow::CALLBACKCODE_EXIT;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WM_ACTIVE Ƃ̏
/*!
 *	\param	Param	[i ]	bZ[We
 */
CWindow::CALLBACKCODE CSingleWindowAppWindows::wmActivate( CWindowsMessage& msg )
{
	const bool IsMinimized = msg.GetWPARAM(CWindowsMessage::PARAM_HI) != 0;

	bool IsActive = false;

	switch( msg.GetWPARAM(CWindowsMessage::PARAM_LO) )
	{
	case WA_ACTIVE:
	case WA_CLICKACTIVE:
		{
			if( IsMinimized )
			{
				return CWindow::CALLBACKCODE_CONTINUE;
			}else
			{
				IsActive = true;
			}
		}break;


	case WA_INACTIVE:
		{
			IsActive = false;
		}break;
	}


	SingleWindowMessage::Activate* pMess = new SingleWindowMessage::Activate;
	pMess->IsActive = IsActive;
	PostWindowMessage( SPSINGLEWINDOWMESSAGE(pMess) );

	return CWindow::CALLBACKCODE_CONTINUE;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WM_NCLBUTTONDBLCLKƂ̏
/*!
 *	\param	Param	[i ]	bZ[We
 */
CWindow::CALLBACKCODE	CSingleWindowAppWindows::wmNcLButtonDblClk( CWindowsMessage& msg ) 
{
	if( !m_Initialize ) { return CWindow::CALLBACKCODE_CONTINUE; }
	//@^Cgo[_uNbNƂ̍ő剻
	//	WM_SYSCOMMAND::SC_MAXIMIZE@ʂȂ̂łł͂
	if( (INT)msg.GetWPARAM()==HTCAPTION ) { return CWindow::CALLBACKCODE_EXIT; }

	return CWindow::CALLBACKCODE_CONTINUE;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WM_SYSCOMMAND Ƃ̏
/*!
 *	\param	Param	[i ]	bZ[We
 */
CWindow::CALLBACKCODE	CSingleWindowAppWindows::wmSysCommand( CWindowsMessage& msg ) 
{
	if( !m_Initialize ) { return CWindow::CALLBACKCODE_CONTINUE; }

	switch( msg.GetWPARAM() )
	{
	case SC_MAXIMIZE:	//@ő剻{^Ƃ
		{
			const SPSINGLEWINDOWMESSAGE pMess( new SingleWindowMessage::Base(SingleWindowMessage::Base::PUSHMAXIMIZEBUTTON) );

			PostWindowMessage( pMess );

			return CWindow::CALLBACKCODE_EXIT;
		}
		break;

	case SC_MINIMIZE:	//	ŏ{^Ƃ
		{
		}
		break;

	case SC_RESTORE:
		{
		}
		break;
	}

	return CWindow::CALLBACKCODE_CONTINUE;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WM_KEYDOWN Ƃ̏
/*!
 *	\param	Param	[i ]	bZ[We
 */
CWindow::CALLBACKCODE	CSingleWindowAppWindows::wmKeyDown( CWindowsMessage& msg )
{
	if( !m_Initialize ) { return CWindow::CALLBACKCODE_CONTINUE; }

	switch( msg.GetWPARAM() )
	{
	case VK_F1:
		{	// F1 ŃtXN[EBhE[h֐؂ւ
			if( !IsBitOn(msg.GetLPARAM(),30) )
			{
			}
		}
		break;
	}

	return CWindow::CALLBACKCODE_CONTINUE;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WM_PAINT Ƃ̏
/*!
 *	\param	Param	[i ]	bZ[We
 */
CWindow::CALLBACKCODE CSingleWindowAppWindows::wmSysKeyDown( CWindowsMessage& msg )
{
	if( !m_Initialize ) { return CWindow::CALLBACKCODE_CONTINUE; }
/*
	switch( Param.GetWPARAM() )
	{
	case VK_RETURN:
		{
			if( IsBitOn(Param.GetLPARAM(),29) )
			{
				const CVideoCardDriverD3D9* pDriver = static_cast<const CVideoCardDriverD3D9*>(m_Graphic.GetVideoCardDriver().get());
				const IVideoCardDriver::SCREENMODE     bpp = m_Graphic.GetInitState().ScreenMode;
				if( bpp!=IVideoCardDriver::SCREENMODE_WINDOW )
				{
					ChangeScreenMode( IVideoCardDriver::SCREENMODE_WINDOW, false );
				}else
				{
					if( pDriver->GetBackBufferFormat(IVideoCardDriver::SCREENMODE_FULL_32BIT)!=D3DFMT_UNKNOWN )	{ ChangeScreenMode( IVideoCardDriver::SCREENMODE_FULL_32BIT, false );	}
					ef( pDriver->GetBackBufferFormat(IVideoCardDriver::SCREENMODE_FULL_16BIT)!=D3DFMT_UNKNOWN )	{ ChangeScreenMode( IVideoCardDriver::SCREENMODE_FULL_16BIT, false );	}
				}

			}
		}break;
	}
*/
	return CWindow::CALLBACKCODE_CONTINUE;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WM_PAINT Ƃ̏
/*!
 *	\param	Param	[i ]	bZ[We
 */
CWindow::CALLBACKCODE	CSingleWindowAppWindows::wmPaint( CWindowsMessage& msg )
{
	if( !m_Initialize ) { return CWindow::CALLBACKCODE_CONTINUE; }

	PAINTSTRUCT ps;

	::BeginPaint( msg.GetHWND(), &ps );

	if( ps.rcPaint.bottom-ps.rcPaint.top  == 0 ) { goto NOBLT; }
	if( ps.rcPaint.right -ps.rcPaint.left == 0 ) { goto NOBLT; }

	{
		const SPSINGLEWINDOWMESSAGE pMess( new SingleWindowMessage::Base(SingleWindowMessage::Base::REDRAW) );
		PostWindowMessage( pMess );
	}

NOBLT:
	::EndPaint( msg.GetHWND(), &ps );

	return CWindow::CALLBACKCODE_CONTINUE;
}


void CSingleWindowAppWindows::OnIMEResult( const mstring& str )
{
	SingleWindowMessage::ImeResult* pMess = new SingleWindowMessage::ImeResult;
	pMess->Code = str;
	PostWindowMessage( SPSINGLEWINDOWMESSAGE(pMess) );
}

void CSingleWindowAppWindows::OnCharCode( unt32 code )
{
	SingleWindowMessage::CharCode* pMess = new SingleWindowMessage::CharCode;
	pMess->Code = code;
	PostWindowMessage( SPSINGLEWINDOWMESSAGE(pMess) );
}

}
