#ifndef CCamera_h
#define CCamera_h

/*!
 	@file
 	@brief	RcJ
 */

#include"../Setup/CompileMode.h"
#include"../Auxiliary/Macro.h"
#include"../template/Mathematics.h"

namespace Maid
{
	class CCamera
	{
	public:
		CCamera();
		virtual ~CCamera();

		void SetPerspective( float Fov, float Aspect, float Near, float Far );
		void SetOrthogonal( float Fov, float Aspect, float Near, float Far, float ProjectionDepth );

		void SetPosition( const POINT3DF&  pos );
		void SetTarget  ( const POINT3DF&  pos );
		void SetUpVector( const VECTOR3DF& vec );

		void Set2DPosition( int Width, int Height, float Near, float Far );

		const MATRIX4DF& GetViewMatrix() const;
		const MATRIX4DF& GetProjectionMatrix() const;

		void  Move( const VECTOR3DF& offset );
		void  Move( const VECTOR3DF& pos, const VECTOR3DF& target );

		const POINT3DF&  GetPosition() const;
		const POINT3DF&  GetTarget  () const;
		const VECTOR3DF& GetUpVector() const;

		bool	IsCameraIn( const POINT3DF& pos )const;

	private:
		POINT3DF	m_Pos;		// J̈ʒu
		POINT3DF	m_Target;	// J̒ړ_
		VECTOR3DF	m_Up;		// ̌

		MATRIX4DF	m_ViewMatrix;
		MATRIX4DF	m_ProjectionMatrix;

		bool	m_IsCalcViewMatrix;	//!<	m_ViewMatrixČvZH
	};


}
#endif