
#include"CCustomVertexTemplate.h"

namespace Maid
{
	FVFINFO::FVFINFO()
	{
		Format = VERTEXFORMAT_NONE;
		StructSize = 0;
		OffsetPosition = NOT_CONTAIN;
		OffsetColor    = NOT_CONTAIN;
		OffsetWeight   = NOT_CONTAIN;
		OffsetWeightIndex = NOT_CONTAIN;
		OffsetNormal   = NOT_CONTAIN;
		OffsetUV1      = NOT_CONTAIN;
		IndexBlendMax  = NOT_CONTAIN;
	}

	/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
	//! w肳ꂽ_tH[}bg璸_AhXo
	/*!
		@param  Format		[i ]	T_tH[}bg
	*/
	FVFINFO GetFVFInfo( VERTEXFORMAT Format )
	{
		FVFINFO Info;
		switch( Format )
		{
		case VERTEXFORMAT_3DCOLORNORMAL:
			{
				CUSTOMVERTEX_3DCOLORNORMAL v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color    - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal   - (unt32)&v;
			}break;

		case VERTEXFORMAT_3DSPRITENORMAL:
			{
				CUSTOMVERTEX_3DSPRITENORMAL v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color    - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal   - (unt32)&v;
				Info.OffsetUV1      = (unt32)&v.Texture  - (unt32)&v;
			}break;
		case VERTEXFORMAT_3DT0W1:
			{
				CUSTOMVERTEX_3DT0W1 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.IndexBlendMax = 1;
			}break;
		case VERTEXFORMAT_3DT0W2:
			{
				CUSTOMVERTEX_3DT0W2 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeight   = (unt32)&v.Blend[0]  - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.IndexBlendMax = 2;
			}break;
		case VERTEXFORMAT_3DT0W3:
			{
				CUSTOMVERTEX_3DT0W3 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeight   = (unt32)&v.Blend[0]  - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.IndexBlendMax = 3;
			}break;
		case VERTEXFORMAT_3DT0W4:
			{
				CUSTOMVERTEX_3DT0W4 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeight   = (unt32)&v.Blend[0]  - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.IndexBlendMax = 4;
			}break;

		case VERTEXFORMAT_3DT1W1:
			{
				CUSTOMVERTEX_3DT1W1 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.OffsetUV1      = (unt32)&v.Texture  - (unt32)&v;
				Info.IndexBlendMax = 1;
			}break;
		case VERTEXFORMAT_3DT1W2:
			{
				CUSTOMVERTEX_3DT1W2 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeight   = (unt32)&v.Blend[0]  - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.OffsetUV1      = (unt32)&v.Texture  - (unt32)&v;
				Info.IndexBlendMax = 2;
			}break;
		case VERTEXFORMAT_3DT1W3:
			{
				CUSTOMVERTEX_3DT1W3 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeight   = (unt32)&v.Blend[0]  - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.OffsetUV1      = (unt32)&v.Texture  - (unt32)&v;
				Info.IndexBlendMax = 3;
			}break;
		case VERTEXFORMAT_3DT1W4:
			{
				CUSTOMVERTEX_3DT1W4 v;
				Info.OffsetPosition = (unt32)&v.Position - (unt32)&v;
				Info.OffsetColor    = (unt32)&v.Color  - (unt32)&v;
				Info.OffsetNormal   = (unt32)&v.Normal - (unt32)&v;
				Info.OffsetWeight   = (unt32)&v.Blend[0]  - (unt32)&v;
				Info.OffsetWeightIndex = (unt32)&v.Index[0] - (unt32)&v;
				Info.OffsetUV1      = (unt32)&v.Texture  - (unt32)&v;
				Info.IndexBlendMax = 4;
			}break;

		default: { MAID_ASSERT( true, MAIDTEXT("w肵tH[}bgɑΉł܂ł ") << Format ); }break;
		}

		Info.Format     = Format;
		Info.StructSize = GetFVFSize(Format);

		return Info;
	}
}