
#include"CFont.h"
#include"../Auxiliary/Macro.h"
#include"../auxiliary/CString.h"

namespace Maid
{
	SIZE2DI IFont::CalcTextSize( const mstring& text )
	{
		int TextLineLength =0;	//	Ps̍ő啶(1byteCode  +1 2byteCode +2)
		int	CountCF=0;	// '\n' 邩H
		int	NowStrCount=0;	//	ݍs̕(1byteCode  +1 2byteCode +2)

		for( int i=0; i<(int)text.length(); ++i )
		{
			const unt32 c = text[i];

			if( !CString::IsHankaku(c) )
			{
				NowStrCount += 2;
			}else
			{
				if( c=='\r' ) { continue; }
				ef( c=='\t' ) { continue; }
				ef( c=='\n' ) 
				{
					TextLineLength = max( TextLineLength, NowStrCount );
					CountCF++; 
					NowStrCount = 0;
				}else
				{
					NowStrCount += 1;
				}
			}
		}
		TextLineLength = max( TextLineLength, NowStrCount );


		const int w = GetSize().w * TextLineLength;
		const int h = GetSize().h * (CountCF+1);

		return SIZE2DI(w,h);
	}
}

