/*!
 	@file
 	@brief	tHg̃x[XNX
\n			̃NXpĊeg悤ɂ܂
*/
#ifndef CFont_h
#define CFont_h

#include"../Setup/CompileMode.h"
#include"../Auxiliary/mstring.h"
#include"../template/Mathematics.h"
#include<boost/smart_ptr.hpp>

namespace Maid
{
	/*!
	 	@brief	tHgNX
	\n			̃NXpĊeg悤ɂ܂
	\n			CX^XꍇAłɃtHg͍쐬Ă܂
	 */
	class IFont
	{
	public:
		virtual ~IFont(){}	//!<	fXgN^

		//! tHg̎擾
		/*!
		 	@return tHg
		 */
		virtual mstring GetFontName() const=0;

		//! tHg̏c̎擾
		/*!
		 	pTCY擾܂
		 
		 	@return tHg̉
		 */
		virtual SIZE2DI GetSize() const=0;

		//! A`GCAX邩H
		/*!
		 	@return Ȃtrue
		 */
		virtual bool IsAntialias() const=0;

		//! H
		/*!
		 	@return Ȃtrue
		 */
		virtual bool IsBold() const=0;

		//! Α̂H
		/*!
		 	@return Α̂Ȃtrue
		 */
		virtual bool IsItalic() const=0;


		SIZE2DI CalcTextSize( const mstring& text );
	};

	typedef boost::shared_ptr<IFont> SPFONT;
}

#endif
