/*!	
	@file
	@brief	Q[gfNX
*/

#ifndef CModelFile_h
#define CModelFile_h


#include"../Setup/CompileMode.h"
#include"../Storage/CStorageObject.h"
#include"../template/GlobalPointer.h"
#include"CTextureFile.h"
#include"CVertexModel.h"
#include"CIndexModel.h"
#include"CTextureModel.h"
#include"CRenderMessage.h"

#include<map>

namespace Maid
{

	class CGraphic;
	class CModelFile
	{
	public:

		struct LAYERINFO
		{
			int				VertexCount;
			CVertexModel	Point;
			CVertexModel	Normal;
		
			struct PRIMITIVE
			{
				CIndexModel Index;
				int Count;
				
				COLOR_R32G32B32F Color;
				CTextureModel ColorTex;
				CVertexModel  ColorUV;

				float Alpha;
			};
			
			MySTL::vector<PRIMITIVE>	Primitive;
		};

	public:
		CModelFile();
		~CModelFile();

		void Load( const mstring& FileName );
		void Delete();

		mstring GetFileName() const;
		bool IsNowLoading();

		int GetLayerCount()const;
		LAYERINFO GetLayer( int no, float time )const;

	private:

		enum STATE
		{
			STATE_EMPTY,
			STATE_LOADING_MODEL,
			STATE_LOADING_TEXTURE,
			STATE_WORKING
		};

		STATE	m_State;
		
	private:
		
		class _CModelFile : public IModelFile , public GlobalPointer<CGraphic>
		{
		public:
			_CModelFile();
			_CModelFile( const _CModelFile& rha );
		protected:
			virtual void LoadedDelete( const mstring& FileName );
			virtual void LoadEnd( const SPSTORAGEFUNCTION_RETURNPARAM& param, MODELDATA& info );

		private:
			void PostVertex( const SPBINARY& pBinary, const mstring& name, VERTEXFORMAT fmt );
			void PostIndex ( const SPBINARY& pBinary, const mstring& name, int IndexStride );
			void DelVertex( const mstring& name );
			void DelIndex ( const mstring& name );
		};

		_CModelFile	m_ModelFile;

		MySTL::map<int,CTextureFile>	m_TextureMap;
	};
}

#endif
