#include"CPixelShaderDefault.h"
#include"../Auxiliary/CString.h"
#include"../Auxiliary/Debug/CAssert.h"

#include"CGraphic.h"

namespace Maid
{

	ReferenceCount<mstring>	CPixelShaderDefault::s_Cache;

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CPixelShaderDefault::CPixelShaderDefault()
{
}

CPixelShaderDefault::CPixelShaderDefault( const CPixelShaderDefault& rha )
{
	const mstring id = rha.m_CodeName;

	if( !id.empty() )
	{
		m_CodeName = id;
		s_Cache.Add(id);
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CPixelShaderDefault::~CPixelShaderDefault()
{
	Delete();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CuŗpӂĂVF[_[쐬
/*!
	@param	name	[i ]	쐬VF[_[
 */
void CPixelShaderDefault::Create( PIXELSHADERNAME::NAME name )
{
	Delete();

	const mstring codename = PIXELSHADERNAME::GeneratDefault( name );

	if( s_Cache.Add(codename) )
	{
		GlobalPointer<CGraphic>::Get()->RegistPixelShaderDefault( codename );
	}

	m_CodeName = codename;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! VF[_[j
/*!
 */
void CPixelShaderDefault::Delete()
{
	if( m_CodeName.empty() ) { return ; }

	if( s_Cache.Del(m_CodeName) )
	{
		GlobalPointer<CGraphic>::Get()->DeletePixelShader( m_CodeName );
	}

	m_CodeName.clear();
}


mstring CPixelShaderDefault::GetID() const
{
	MAID_ASSERT( m_CodeName.empty(), "܂ǂݍł܂" );
	return m_CodeName;
}


CPixelShaderDefault& CPixelShaderDefault::operator = ( const CPixelShaderDefault& rha )
{
	Delete();

	const mstring id = rha.m_CodeName;

	if( !id.empty() )
	{
		m_CodeName = id;
		s_Cache.Add(id);
	}

	return *this;
}

}