
#include"CSprite.h"
#include"Color.h"
#include"../Auxiliary/xml/CXMLDocument.h"
#include"../Auxiliary/CString.h"
#include"../Auxiliary/Debug/CAssert.h"
#include"../Auxiliary/Debug/CWarning.h"

namespace Maid
{


/*!
 *	\class	CSpriteFile CSprite.h
 *	\brief	XvCgt@Cǂݍ݃NX
 *
 *	\par	XvCgt@CtH[}bg
 *
\n	<FileName>dog01.png</FileName>		\Ɏgt@C
\n	<Cell>								摜̐؂蔲g^OB
\n		<RectNo>0</RectNo>
\n		<left>001</left>
\n		<right>288</right>
\n		<top>32</top>
\n		<bottom>330</bottom>
\n	</Cell>
\n
\n	<sprite>							\Ɏg^O
\n		<SpriteNo>0</SpriteNo>
\n		<OffsetX>16</OffsetX>
\n		<OffsetY>21</OffsetY>
\n		<Parts>								\W\^O
\n			<PosX>0</PosX>
\n			<PosY>0</PosY>
\n			<CellNo>0</CellNo>
\n		</Parts>
\n	</sprite>
\n	
\n	<Animation>							Aj[V^O
\n		<Animationo>0</Animationo>
\n		<Frame>
\n			<SpriteNo>100</SpriteNo>	\XvCgNO
\n			<DrawFrame>10</DrawFrame>	\ԁit[j
\n		</Frame>
\n		<Frame>
\n			<Jump>1</Jump>				\Aj[VWv	
\n		</Frame>
\n	</Animation>
\n
 */

CSpriteFile::CACHELIST  CSpriteFile::s_CacheList;


static const int	SPRITE_JUMP = -1;
/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CSpriteFile::CSpriteFile()
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CSpriteFile::~CSpriteFile()
{
	Release();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! XvCgt@C̓ǂݍ
/*!
 *	\param	FileName	[i ]	ǂݍރt@C
 *
 *	\return		ǂݍ݂ɐ MRESULT_OK
\n				s MRESULT_OK ȊO
 */
void CSpriteFile::Load( const mstring& FileName )
{
	//	LbVɃf[^Ȃ炻ō쐬ďI
	Release();

	const mstring str = CString::ToLower(FileName);

	CACHELIST::iterator ite = s_CacheList.find( str );
	if( ite!=s_CacheList.end() )
	{
		m_FileName	 = FileName;
		m_pCacheData = ite->second;
		return ;
	}


	//	ȂV쐬
	CXMLDocument	xml;
	xml.Load( FileName );

	SPSPRITEFILE			pFile( new SPRITEFILE );
	
	CXMLNode& node = xml.GetRoot();

	for( int i=0; i<node.GetChildLength(); ++i ) {
		CXMLNode& c = node.GetChildNode(i);

		if( c.GetType()!=CXMLNode::TYPE_ELEMENT ) { continue; }


		const mstring element = CString::ToLower(c.GetElementName());

		if( element==MAIDTEXT("filename") ){
		
			mstring			CurrentDir = CString::GetDirectory(FileName);
			if( !CurrentDir.empty() ) { CurrentDir += '\\'; }

			mstring	ImageFile;
			
			ReadFileName( c, ImageFile );
			pFile->Texture.Load(CurrentDir+ImageFile);
		}
		ef( element==MAIDTEXT("cell") ) {
			RECT2DI rc;
			int no;
			ReadCell( c, no, rc );

			if( (int)pFile->CellList.size()<=no ) { pFile->CellList.resize( no+1 ); }
			pFile->CellList[no] = rc;
		}
		ef( element==MAIDTEXT("sprite") ) {
			SPRITEDATA sp;
			int no;
			ReadSprite( c, no, sp );

			if( (int)pFile->SpriteList.size()<=no ) { pFile->SpriteList.resize( no+1 ); }
			pFile->SpriteList[no] = sp;
		}
		ef( element==MAIDTEXT("animation") ) {
			ANIMATION anim;
			int no;
			ReadAnimation( c, no, anim );

			if( (int)pFile->AnimationList.size()<=no ) { pFile->AnimationList.resize( no+1 ); }
			pFile->AnimationList[no] = anim;
		}
	}

	m_FileName	 = FileName;
	m_pCacheData = pFile;
	s_CacheList[str] = pFile;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! eNX`̎擾
/*!
 *	\return		XvCgf[^
 */
const CTextureFile& CSpriteFile::GetTexture() const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("܂ǂݍł܂") );
	return m_pCacheData->Texture;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ؂蔲f[^擾
/*!
 *	\param	No	[i ]	擾ԍ
 *
 *	\return		؂蔲W
 */
const RECT2DI& CSpriteFile::GetCell( int No ) const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("܂ǂݍł܂") );
	MAID_ASSERT( !(No<(int)m_pCacheData->CellList.size()), MAIDTEXT("͈͊Oł ") << No );
	return m_pCacheData->CellList[No];
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! XvCgf[^̎擾
/*!
 *	\param	No	[i ]	XvCgf[^ԍ
 *
 *	\return		_f[^
 */
const CSpriteFile::SPRITEDATA& CSpriteFile::GetSprite( int No ) const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("܂ǂݍł܂") );
	MAID_ASSERT( !(No<(int)m_pCacheData->SpriteList.size()), MAIDTEXT("͈͊Oł ") << No );
	return m_pCacheData->SpriteList[No];
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Aj[Vf[^̎擾
/*!
 *	\param	No	[i ]	Ajp^[ԍ
 *
 *	\return		Aj[Vf[^
 */
const CSpriteFile::ANIMATION& CSpriteFile::GetAnimation( int No ) const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("܂ǂݍł܂") );
	MAID_ASSERT( !(No<(int)m_pCacheData->SpriteList.size()), MAIDTEXT("͈͊Oł ") << No );

	return m_pCacheData->AnimationList[No];
}

const MySTL::vector<RECT2DI>&	CSpriteFile::GetCellList() const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("܂ǂݍł܂") );

	return m_pCacheData->CellList;
}





/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍ񂾃f[^̃NA
/*!
 */
void CSpriteFile::Release()
{
	if( !IsLoad() ) { return ; }

	// LbVf[^LbV폜
	CACHELIST::iterator ite = s_CacheList.find(CString::ToLower(m_FileName));
	if( ite!=s_CacheList.end() && m_pCacheData.use_count()<=2 ) // <=2  m_pCacheData  s_CacheList ɂłQ
	{
		s_CacheList.erase( ite );
	}

	m_pCacheData.reset();
	m_FileName.clear();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݓǂݍł邩H
/*!
 */
bool CSpriteFile::IsLoad() const
{
	return !m_FileName.empty();
}

bool CSpriteFile::IsNowLoading()
{
	if( !IsLoad() ) { return false; }

	return m_pCacheData->Texture.IsNowLoading();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Aj[VSŉp^[邩ׂ
/*!
 *	\return Aj[V
 */
int	CSpriteFile::GetAnimationCount() const
{
	if( !IsLoad() ) { return 0; }

	return (unt)m_pCacheData->AnimationList.size();
}


void CSpriteFile::ReadFileName( const CXMLNode& node, mstring& FileName  )
{
	MAID_ASSERT( CString::ToLower(node.GetElementName())!=MAIDTEXT("filename"), MAIDTEXT("sȗvfł") );

	for( int i=0; i<node.GetChildLength(); ++i )
	{
		const CXMLNode& n = node.GetChildNode(i);
		if( n.GetType()!=CXMLNode::TYPE_TEXT ) { continue; }

		FileName = n.GetText().GetStr();
		break;
	}
}

void CSpriteFile::ReadCell( const CXMLNode& node, int& no, RECT2DI& rc )
{
	MAID_ASSERT( CString::ToLower(node.GetElementName())!=MAIDTEXT("cell"), MAIDTEXT("sȗvfł") );

	int l,r,t,b;
	for( int i=0; i<node.GetChildLength(); ++i )
	{
		const CXMLNode& n = node.GetChildNode(i);
		if( n.GetType()!=CXMLNode::TYPE_ELEMENT ) { continue; }

		const mstring name = CString::ToLower(n.GetElementName());
		const int val = n.GetChildNode(0).GetText().GetInt();

		if( name==MAIDTEXT("index") ) { no = val; }
		ef( name==MAIDTEXT("left")  ) { l = val; }
		ef( name==MAIDTEXT("right") ) { r = val; }
		ef( name==MAIDTEXT("top")   ) { t = val; }
		ef( name==MAIDTEXT("bottom")) { b = val; }
	}

	rc = RECT2DI(l,t,r-l,b-t);
}

void CSpriteFile::ReadSprite( const CXMLNode& node, int& no, SPRITEDATA& sp )
{
	MAID_ASSERT( CString::ToLower(node.GetElementName())!=MAIDTEXT("sprite"), MAIDTEXT("sȗvfł") );

	for( int i=0; i<node.GetChildLength(); ++i ){
		const CXMLNode& n = node.GetChildNode(i);
		if( n.GetType()!=CXMLNode::TYPE_ELEMENT ) { continue; }

		const mstring name = CString::ToLower(n.GetElementName());

		if( name==MAIDTEXT("index")   ) { no = n.GetChildNode(0).GetText().GetInt(); }
		ef( name==MAIDTEXT("parts")   ) {

			SPRITEDATA::PARTS p;
			for( int j=0; j<n.GetChildLength(); ++j ) {
				const CXMLNode& nn = n.GetChildNode(j);
				if( nn.GetType()!=CXMLNode::TYPE_ELEMENT ) { continue; }

				const mstring name = CString::ToLower(nn.GetElementName());

				if( name==MAIDTEXT("posx")   ) { p.DrawPos.x = nn.GetChildNode(0).GetText().GetInt(); }
				ef( name==MAIDTEXT("posy")   ) { p.DrawPos.y = nn.GetChildNode(0).GetText().GetInt(); }
				ef( name==MAIDTEXT("cellno") ) { p.CellNo    = nn.GetChildNode(0).GetText().GetInt(); }

			}
			sp.PartsList.push_back( p );
		}
	}
}

void CSpriteFile::ReadAnimation( const CXMLNode& node, int& no, ANIMATION& anim )
{
	MAID_ASSERT( CString::ToLower(node.GetElementName())!=MAIDTEXT("animation"), MAIDTEXT("sȗvfł") );

	for( int i=0; i<node.GetChildLength(); ++i ){
		const CXMLNode& n = node.GetChildNode(i);
		if( n.GetType()!=CXMLNode::TYPE_ELEMENT ) { continue; }

		const mstring name = CString::ToLower(n.GetElementName());

		if( name==MAIDTEXT("index") ) { no = n.GetChildNode(0).GetText().GetInt();; }
		ef( name==MAIDTEXT("frame") ) {
			ANIMATIONFRAME a;
			for( int j=0; j<n.GetChildLength(); ++j ) {
				const CXMLNode& nn = n.GetChildNode(j);
				if( nn.GetType()!=CXMLNode::TYPE_ELEMENT ) { continue; }

				const mstring name = CString::ToLower(nn.GetElementName());

				if( name==MAIDTEXT("spriteno") ) { a.SpriteNo = nn.GetChildNode(0).GetText().GetInt(); }
				ef( name==MAIDTEXT("drawframe")) { a.Frame    = nn.GetChildNode(0).GetText().GetInt(); }
				ef( name==MAIDTEXT("jump")     )
				{
					a.SpriteNo = SPRITE_JUMP;
					a.Frame    = nn.GetChildNode(0).GetText().GetInt();
				}
			}
			anim.push_back(a);
		}
	}

}




/*!
 *	\class	CSprite DenSprite.h
 *	\brief	XvCgAjǗNX
\n			̃NX͐lǗ邾Ȃ̂ŕ`@\͂܂
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CSprite::CSprite()
{
	m_IsPlay = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CSprite::~CSprite()
{
	Release();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! XvCgt@C̓ǂݍ
/*!
 *	\param	FileName	[i ]	Vp^[
 *
 */
void CSprite::Load( const mstring& FileName )
{
	Release();

	m_Sprite.Load(FileName);

	SetPlayState( true );
	m_ChangeCount = -1;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Pt[i߂
/*!
 */
void CSprite::CountInc()
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	if( !IsPlay() ) { return ; }

	if( m_ChangeCount==-1 ) { return ; }	//!<	Ō܂ōĐĂ ̂܂
	ef( m_ChangeCount==0 )
	{
		const CSpriteFile::ANIMATION& patern = m_Sprite.GetAnimation(m_Pattern);

		m_Koma++;	//	R}iŖ[~
		if( !(m_Koma<(int)patern.size()) )
		{
			m_ChangeCount = -1;
		}else
		{
			const CSpriteFile::ANIMATIONFRAME& data = patern[m_Koma];

			if( data.SpriteNo==SPRITE_JUMP )	//	Wv߂̎
			{
				const int JumpNo = data.Frame;
				m_NowSprite   = patern[JumpNo].SpriteNo;
				m_ChangeCount = patern[JumpNo].Frame-1;
				m_Koma		  = JumpNo;
			}else
			{
				m_NowSprite   = data.SpriteNo;
				m_ChangeCount = data.Frame-1;
			}
		}
	}else
	{
		m_ChangeCount--;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Pt[߂
/*!
 */
void CSprite::CountDec()
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	if( !IsPlay() ) { return ; }

	const CSpriteFile::ANIMATION& patern = m_Sprite.GetAnimation(m_Pattern);
	if( m_ChangeCount==-1 )
	{	//!<	Ō܂ōĐĂ Ō

		--m_Koma;
		const CSpriteFile::ANIMATIONFRAME& data = patern[m_Koma];
		m_NowSprite   = data.SpriteNo;
		m_ChangeCount = 0;
	}else
	{
		const CSpriteFile::ANIMATIONFRAME& data = patern[m_Koma];

		if( data.Frame==m_ChangeCount )
		{
			if( m_Koma==0 ) { return ; }
			--m_Koma;
			const CSpriteFile::ANIMATIONFRAME& data = patern[m_Koma];
			m_NowSprite   = data.SpriteNo;
			m_ChangeCount = 0;

		}else
		{
			m_ChangeCount++;
		}
	}


}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒuw肵t[߂
/*!
 *	\param	Frame	[i ]	i߂t[
 */
void CSprite::JumpFrame( int Frame )
{
	if( 0<Frame )
	{
		for( int i=0; i<Frame; ++i ) { CountInc(); }
	}else
	{
		for( int i=0; i<(-Frame); ++i ){	CountDec();	}
	}

}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Đp^[ύX
/*!
 *	\param	No	[i ]	Vp^[
 */
void CSprite::ChangePattern( int No )
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	if( !IsLoad() ) { return ; }
	const CSpriteFile::ANIMATION& patern = m_Sprite.GetAnimation(No);

	m_NowSprite   = patern[0].SpriteNo;
	m_ChangeCount = patern[0].Frame;
	m_Pattern = No;
	m_Koma    = 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̍Đp^[ԍ̎擾
/*!
 */
int CSprite::GetPattern() const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	return m_Pattern;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̕`悷ׂXvCgf[^擾
/*!
 */
SPRITE CSprite::GetNowSprite() const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );

	return SPRITE(  m_Sprite.GetTexture(),
					m_Sprite.GetCellList(),
					m_Sprite.GetSprite(m_NowSprite)
	);
}




/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ǂݍłXvCgf[^
/*!
 */
void CSprite::Release()
{
	m_Sprite.Release();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Đ̃XvCgI[܂Ői񂾂H
/*!
 *	\return I[܂ŏIĂ true
\n			܂ false
 */
bool CSprite::IsEnd() const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	return 	m_ChangeCount == -1;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ĐԂ̕ύX
/*!
 *	\param	IsPlay	[i ]	ĐȂ true
 */
void CSprite::SetPlayState( bool IsPlay )
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	m_IsPlay = IsPlay;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ĐH
/*!
 *	\return ĐȂ true
 */
bool CSprite::IsPlay() const
{
	MAID_ASSERT( !IsLoad(), MAIDTEXT("t@Cǂݍ܂Ă܂") );
	return m_IsPlay;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݓǂݍł邩H
/*!
 *	\return ǂݍłȂ true
 */
bool CSprite::IsLoad() const
{
	return m_Sprite.IsLoad();
}

bool CSprite::IsNowLoading()
{
	return m_Sprite.IsNowLoading();
}

}
