#include"CVertex.h"
#include"../Auxiliary/Debug/CAssert.h"
#include"../Auxiliary/CString.h"
#include"CResourceNameGenerator.h"
#include"CRenderMessageImpl3.h"
#include"CCustomVertexTemplate.h"

#include"Core/CGraphicCore.h"


namespace Maid
{

ReferenceCount<mstring>	CVertex::s_Cache;
unt CVertex::s_AutoCount;




CVertex::~CVertex()
{
	Destroy();
}


void CVertex::Create( VERTEXFORMAT fmt, void* pVertex, int Count )
{
	Destroy();

	mstring name = VERTEXNAME::GeneratMemory( s_AutoCount );

	if( s_Cache.Add(name) )
	{
		boost::shared_ptr<RenderMessage::RegistVertex> pMess( new RenderMessage::RegistVertex );

		pMess->ResistID = name;
		pMess->Format = fmt;

		const unt size = GetFVFSize(fmt) * Count;
		pMess->Vertex.resize( size );
		::memcpy( &(pMess->Vertex[0]), pVertex, size );

		GlobalPointer<CGraphicCore>::Get()->PostRenderMessage( pMess, true );

		++s_AutoCount;
	}

	m_VertexName = name;

}

void CVertex::Destroy()
{
	if( m_VertexName.empty() ) { return ; }

	if( s_Cache.Del(m_VertexName) )
	{
		boost::shared_ptr<RenderMessage::DeleteVertex> pMess( new RenderMessage::DeleteVertex );

		pMess->DeleteID = m_VertexName;

		GlobalPointer<CGraphicCore>::Get()->PostRenderMessage( pMess, true );
	}

	m_VertexName.clear();
}

mstring CVertex::GetID() const
{
	return m_VertexName;
}


}

