#ifndef COLOR_A04R04G04B04I_h
#define COLOR_A04R04G04B04I_h

/*!
 	@file
 	@brief	PsNZ킷NX
\n			A04R04G04B04 intger tH[}bg Ver.
 */

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"

#include"PixelConvertFunction.h"

namespace Maid
{
	/*!
	 *	\class	COLOR_A04R04G04B04I COLOR_A04R04G04B04I.h
	 *	\brief	At@tPUrbgsNZ
	 */
	class COLOR_A04R04G04B04I
	{
	public:
		COLOR_A04R04G04B04I(){}	//!<	RXgN^
		COLOR_A04R04G04B04I( unt08 a, unt08 r, unt08 g, unt08 b ){ SetARGB( a, r, g, b ); }	//!<	RXgN^
		template <class COLOR>
		COLOR_A04R04G04B04I( const COLOR& Col ){ SetARGB( Col.GetA(), Col.GetR(), Col.GetG(), Col.GetB() ); }	//!<	RXgN^

		unt08 GetA() const	{ return PIXELCONVERT04_08((m_ARGB&0xF000)>>12);	}	//!<	At@̎擾
		unt08 GetR() const	{ return PIXELCONVERT04_08((m_ARGB&0x0F00)>> 8);	}	//!<	Ԑ̎擾
		unt08 GetG() const	{ return PIXELCONVERT04_08((m_ARGB&0x00F0)>> 4);	}	//!<	ΐ̎擾
		unt08 GetB() const	{ return PIXELCONVERT04_08((m_ARGB&0x000F)>> 0);	}	//!<	̎擾

		operator unt16() const { return m_ARGB; }	//!<	ꊇϊ

		void SetA( unt08 a )	{ m_ARGB = (m_ARGB&~0xF000)|(PIXELCONVERT08_04(a)<<12);	}	//!<	At@̐ݒ
		void SetR( unt08 r )	{ m_ARGB = (m_ARGB&~0x0F00)|(PIXELCONVERT08_04(r)<< 8);	}	//!<	Ԑ̐ݒ
		void SetG( unt08 g )	{ m_ARGB = (m_ARGB&~0x00F0)|(PIXELCONVERT08_04(g)<< 4);	}	//!<	ΐ̐ݒ
		void SetB( unt08 b )	{ m_ARGB = (m_ARGB&~0x000F)|(PIXELCONVERT08_04(b)<< 0);	}	//!<	̐ݒ

		void SetARGB( unt08 a, unt08 r, unt08 g, unt08 b )	//!<	ɐݒ
		{
			SetA( a );
			SetR( r );
			SetG( g );
			SetB( b );
		}

		//!	ႤsNZtH[}bgƂ̃Rs[
		template <class PIXEL>
		COLOR_A04R04G04B04I& operator = (const PIXEL &src)
		{
			SetARGB(src.GetA(),src.GetR(),src.GetG(),src.GetB());
			return *this;
		}

		//!	sNZtH[}bgƂ̃Rs[
		COLOR_A04R04G04B04I& operator = (const COLOR_A04R04G04B04I& src)
		{
			m_ARGB = src.m_ARGB;
			return *this;
		}

	private:
		unt16 m_ARGB;
	};
}

#endif
