#ifndef CSurfaceBuffer_h
#define CSurfaceBuffer_h

#include"../../../Setup/CompileMode.h"
#include"../../../template/Mathematics.h"
#include"../../CSurfaceInfo.h"
#include"../../Color.h"

#include<boost/smart_ptr.hpp>

namespace Maid
{

	/*!
	 	@class	ISurfaceBufferInfo CSurfaceBuffer.h
	 	@brief	T[tFX̏\\
	\n			ISurfaceBuffer::Lock() ł̃NX擾܂
	 
	 */
	class ISurfaceBufferInfo
	{
	public:
		virtual ~ISurfaceBufferInfo(){}	//!<	fXgN^

		//! eC̐擪AhX̎擾
		/*! 
		 	@param	PosY	[i ]	擾C( PosY<GetHeight() ł邱Ɓj
		 
		 	@return w肵CAhX
		 */
		virtual void* GetLinePtr( int PosY )const=0;

		void* GetPixelPtr( int PosX, int PosY ) const;

		//! T[tFX̐擪AhX̎擾
		/*! 
		 	̃AhXW(0,0)̃AhXłƂ͌܂ikT[tFXj
		 
		 	@return T[tFX̐擪AhX
		 */
		virtual void* GetAddress() const=0;

		//! J[bNAbve[uipbgj̎擾
		/*! 
		 	@return pbg̐擪AhX
		 */
		virtual void* GetCLUT() const=0;

		//! T[tFX̉̎擾
		/*! 쐬ĂT[tFX̉擾܂
		\n	ISurface::GetWidth() Ɠł
		 
		 	@return T[tFX̉
		 */
		virtual int		GetWidth() const=0;
		//! T[tFX̏c̎擾
		/*! 쐬ĂT[tFX̏c擾܂
		\n	ISurface::GetHeight() Ɠł
		 
		 	@return T[tFX̏c
		 */
		virtual int		GetHeight() const=0;


		//! T[tFX̃sNZtH[}bg̎擾
		/*! 쐬ĂT[tFX̃sNZtH[}bg擾܂
		 
		 	@return T[tFX̃sNZtH[}bg
		 */
		virtual PIXELFORMAT GetPixelFormat() const=0;

		//! T[tFX̃sb`̎擾
		/*! 
		 	@return T[tFX̃sb`
		 */
		virtual int		GetPitch() const=0;


		COLOR_A08R08G08B08I GetPixel( int x, int y );
		void SetPixel( int x, int y, const COLOR_A08R08G08B08I& col );
	};

	typedef boost::shared_ptr<ISurfaceBufferInfo>	SPSURFACEBUFFERINFO;


	/*!
	 	@class	ISurfaceBuffer CSurfaceBuffer.h
	 	@brief	T[tFXobt@̊{NX
	 */
	class ISurfaceBuffer
	{
	public:
		virtual ~ISurfaceBuffer(){}	//!<	fXgN^

		//! T[tFX̑傫̎擾
		/*! 
		 	@return	T[tFX̉Ac
		 */
		virtual SIZE2DI GetSize() const=0;


		//! sNZtH[}bg̎擾
		/*! 
		 	@return	sNZtH[}bg
		 */
		virtual PIXELFORMAT GetPixelFormat() const=0;

		//! T[tFX̃bN
		/*!
		 	T[tFX̓AhXɃANZXł悤ɂ܂
		\n	Lock() Ăяoꍇ͕K Unlock() Ăяo悤ɂ邱
		\n	CSurfaceLoacker gƕ֗ł
		 
		 	@param	info	[ o]	bNɐƂɊe񂪓
		 */
		virtual void Lock( SPSURFACEBUFFERINFO& info )=0;

		//! T[tFX̃AbN
		/*!
		 	Lock()@ŃbNT[tFXĂюg悤ɃAbN܂
		\n	CSurfaceLoacker gƕ֗ł
		 */
		virtual void Unlock()=0;

	};

	typedef boost::shared_ptr<ISurfaceBuffer> SPSURFACEBUFFER;
	typedef boost::shared_ptr<const ISurfaceBuffer> SPCONSTSURFACEBUFFER;



	/*!
	 	@class	CSurfaceBufferLoacker DenSurfaceBuffer.h
	 	@brief	ISurfaceBuffer::Lock(), ISurfaceBuffer::Unlock() 
	\n			IɍsNX
	 
	 	@code
		{
			SPSURFACEBUFFER pSurface( new ISurfaceXXXXX );
			SPSURFACEBUFFERINFO pinfo;

			CSurfaceLoacker lock( pSurface.get(), pinfo  );	//	ŃbN

			//	ł낢s	

		}	//	lock ̃fXgN^ pSurface->Unlock() 
		
	 	@endcode
	 */
	class CSurfaceBufferLoacker
	{
	public:

		CSurfaceBufferLoacker( ISurfaceBuffer& Surface, SPSURFACEBUFFERINFO& info )
			: m_Surface( Surface )
		{
			m_Surface.Lock( info );
		}

		~CSurfaceBufferLoacker()	//!<	fXgN^
		{
			m_Surface.Unlock();
		}
	private:
		ISurfaceBuffer& m_Surface;
	};
}


#endif