#ifndef CSurfaceBufferMemory_h
#define CSurfaceBufferMemory_h

#include"../../../Setup/CompileMode.h"
#include"CSurfaceBuffer.h"


namespace Maid
{
	/*!
	 	@class	CSurfaceBufferMemory CSurfaceBufferMemory.h
	 	@brief	T[tFXobt@ I Ver.
	 */
	class CSurfaceBufferMemory : public ISurfaceBuffer
	{
	public:
		CSurfaceBufferMemory();
		~CSurfaceBufferMemory();

		virtual SIZE2DI GetSize() const;
		virtual PIXELFORMAT GetPixelFormat() const;

		virtual void Lock( SPSURFACEBUFFERINFO& info );
		virtual void Unlock();

		void Create( const SIZE2DI& size, PIXELFORMAT fmt );
		void Destroy();

		void SetReverseSurface( bool IsReverse );

		void* GetPlanePTR();

	private:
		MySTL::vector<unt08>	m_Plane;
		MySTL::vector<unt08>	m_CLUT;

		SIZE2DI		m_Size;
		PIXELFORMAT m_PixelFormat;
		bool m_IsReverse;
	};

	typedef boost::shared_ptr<CSurfaceBufferMemory> SPSURFACEBUFFERMEMORY;

}


#endif