/*!
 	@file
 	@brief	`敽ʃNX DIB Ver.
 */

#ifndef CSurfaceDIB_h
#define CSurfaceDIB_h

#include"../../../../Setup/CompileMode.h"
#include"../../../../Setup/Win32.h"

#include"../CSurfaceBuffer.h"

namespace Maid
{
	class CSurfaceDIB : public ISurfaceBuffer
	{
	public:
		CSurfaceDIB();
		virtual ~CSurfaceDIB();

		virtual SIZE2DI GetSize() const;
		virtual PIXELFORMAT GetPixelFormat() const;

		virtual void Lock( SPSURFACEBUFFERINFO& info );
		virtual void Unlock();

		void CreateBuffer( int Width, int Height, PIXELFORMAT Format );
		void Destory();

		HBITMAP GetHBITMAP() const;

	private:
		HBITMAP		m_hDIB;			//!<	DIBnh
		void*		m_pPlane;		//!<	WJv[
		SIZE2DI		m_Size;			//!<	m_pPlanẻ
		PIXELFORMAT	m_PixelFormat;	//!<	m_pPlanẽsNZtH[}bg
		int			m_Pitch;		//!<	PC̃oCg
	};

	typedef boost::shared_ptr<CSurfaceDIB>	SPSURFACEDIB;

}

#endif
